/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.classinliner.ClassInlinerReceiverSet;
import com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClassInlinerCostAnalysis {
    private final AppView<AppInfoWithLiveness> appView;
    private final InliningIRProvider inliningIRProvider;
    private final ClassInlinerReceiverSet receivers;
    private int estimatedCost = 0;

    ClassInlinerCostAnalysis(AppView<AppInfoWithLiveness> appView, InliningIRProvider inliningIRProvider, ClassInlinerReceiverSet receivers) {
        this.appView = appView;
        this.inliningIRProvider = inliningIRProvider;
        this.receivers = receivers;
    }

    private boolean exceedsInstructionBudgetAfterIncrement(int increment) {
        this.estimatedCost += increment;
        return this.estimatedCost > this.appView.options().classInlinerOptions().getClassInliningInstructionAllowance();
    }

    private int estimateSizeOfNonMaterializingInstructions(InvokeMethod invoke, IRCode inlinee) {
        int result = 0;
        Set<Value> receiverAliasesInInlinee = null;
        for (Instruction instruction : inlinee.instructions()) {
            switch (instruction.opcode()) {
                case 5: {
                    break;
                }
                case 28: 
                case 30: {
                    Value object = instruction.isInstanceGet() ? instruction.asInstanceGet().object() : instruction.asInstancePut().object();
                    Value root = object.getAliasedValue();
                    if (receiverAliasesInInlinee == null) {
                        receiverAliasesInInlinee = this.getReceiverAliasesInInlinee(invoke, inlinee);
                    }
                    if (!receiverAliasesInInlinee.contains(root)) break;
                    if (this.appView.options().isGeneratingClassFiles()) {
                        ++result;
                        break;
                    }
                    result += instruction.isInstanceGet() ? 2 : 2;
                    break;
                }
                case 56: {
                    if (this.appView.options().isGeneratingClassFiles()) {
                        ++result;
                        break;
                    }
                    ++result;
                    break;
                }
            }
        }
        return result;
    }

    private Set<Value> getReceiverAliasesInInlinee(InvokeMethod invoke, IRCode inlinee) {
        List<Value> arguments = inlinee.collectArguments();
        Set<Value> receiverAliasesInInlinee = Sets.newIdentityHashSet();
        for (int i = 0; i < invoke.inValues().size(); ++i) {
            Value inValue = invoke.inValues().get(i);
            if (this.receivers.isReceiverAlias(inValue)) {
                receiverAliasesInInlinee.add(arguments.get(i));
                continue;
            }
            assert (!this.receivers.isReceiverAlias(inValue.getAliasedValue()));
        }
        return receiverAliasesInInlinee;
    }

    boolean willExceedInstructionBudget(IRCode code, DexProgramClass eligibleClass, Map<InvokeMethod, ProgramMethod> directInlinees, List<ProgramMethod> indirectInlinees) {
        if (this.appView.appInfo().alwaysClassInline.contains(eligibleClass.type)) {
            return false;
        }
        for (ProgramMethod inlinee : indirectInlinees) {
            int increment = ((DexEncodedMethod)inlinee.getDefinition()).getCode().estimatedSizeForInlining();
            if (!this.exceedsInstructionBudgetAfterIncrement(increment)) continue;
            return true;
        }
        int numberOfSeenDirectInlinees = 0;
        int numberOfDirectInlinees = directInlinees.size();
        for (InvokeMethod invoke : code.instructions(Instruction::isInvokeMethod)) {
            ProgramMethod inlinee = directInlinees.get(invoke);
            if (inlinee == null) continue;
            IRCode inliningIR = this.inliningIRProvider.getAndCacheInliningIR(invoke, inlinee);
            int increment = ((DexEncodedMethod)inlinee.getDefinition()).getCode().estimatedSizeForInlining() - this.estimateSizeOfNonMaterializingInstructions(invoke, inliningIR);
            assert (increment >= 0);
            if (this.exceedsInstructionBudgetAfterIncrement(increment)) {
                return true;
            }
            if (++numberOfSeenDirectInlinees != numberOfDirectInlinees) continue;
            break;
        }
        assert (numberOfSeenDirectInlinees == numberOfDirectInlinees);
        return false;
    }
}

