/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.LibraryMethod;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.ExactDynamicType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleConstValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.ir.code.AliasedValueConfiguration;
import com.android.tools.r8.ir.code.AssumeAndCheckCastAliasedValueConfiguration;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InstructionOrPhi;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.AssumeRemover;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.classinliner.ClassInliner;
import com.android.tools.r8.ir.optimize.classinliner.ClassInlinerReceiverSet;
import com.android.tools.r8.ir.optimize.classinliner.FieldValueHelper;
import com.android.tools.r8.ir.optimize.classinliner.analysis.NonEmptyParameterUsage;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsage;
import com.android.tools.r8.ir.optimize.classinliner.constraint.ClassInlinerMethodConstraint;
import com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import com.android.tools.r8.ir.optimize.inliner.NopWhyAreYouNotInliningReporter;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.kotlin.KotlinClassLevelInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.AndroidApiLevelUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.WorkList;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;

final class InlineCandidateProcessor {
    private static final AliasedValueConfiguration aliasesThroughAssumeAndCheckCasts = AssumeAndCheckCastAliasedValueConfiguration.getInstance();
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory dexItemFactory;
    private final Inliner inliner;
    private final Function<DexProgramClass, ClassInliner.EligibilityStatus> isClassEligible;
    private final MethodProcessor methodProcessor;
    private final ProgramMethod method;
    private final Instruction root;
    private Value eligibleInstance;
    private DexProgramClass eligibleClass;
    private ObjectState objectState;
    private final Map<InvokeMethod, Inliner.InliningInfo> directMethodCalls = new IdentityHashMap<InvokeMethod, Inliner.InliningInfo>();
    private final ProgramMethodSet indirectMethodCallsOnInstance = ProgramMethodSet.create();
    private final Map<InvokeMethod, ProgramMethod> directInlinees = new IdentityHashMap<InvokeMethod, ProgramMethod>();
    private final List<ProgramMethod> indirectInlinees = new ArrayList<ProgramMethod>();
    private final ClassInlinerReceiverSet receivers;

    InlineCandidateProcessor(AppView<AppInfoWithLiveness> appView, Inliner inliner, Function<DexProgramClass, ClassInliner.EligibilityStatus> isClassEligible, MethodProcessor methodProcessor, ProgramMethod method, Instruction root) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.inliner = inliner;
        this.isClassEligible = isClassEligible;
        this.method = method;
        this.root = root;
        this.methodProcessor = methodProcessor;
        this.receivers = new ClassInlinerReceiverSet(root.outValue());
    }

    private boolean forceInlineDirectMethodInvocations(IRCode code, InliningIRProvider inliningIRProvider) throws IllegalClassInlinerStateException {
        if (this.directMethodCalls.isEmpty()) {
            return false;
        }
        this.inliner.performForcedInlining(this.method, code, this.directMethodCalls, inliningIRProvider, this.methodProcessor, Timing.empty());
        if (this.root.isNewInstance()) {
            do {
                this.directMethodCalls.clear();
                for (Instruction instruction : this.eligibleInstance.uniqueUsers()) {
                    DexMethod invokedMethod;
                    InvokeDirect invoke;
                    Value receiver;
                    if (!instruction.isInvokeDirect() || (receiver = (invoke = instruction.asInvokeDirect()).getReceiver().getAliasedValue()) != this.eligibleInstance || (invokedMethod = invoke.getInvokedMethod()) == this.dexItemFactory.objectMembers.constructor) continue;
                    if (!this.dexItemFactory.isConstructor(invokedMethod)) {
                        throw new IllegalClassInlinerStateException();
                    }
                    DexProgramClass holder = DexProgramClass.asProgramClassOrNull(this.appView.definitionForHolder(invokedMethod, this.method));
                    if (holder == null) {
                        throw new IllegalClassInlinerStateException();
                    }
                    ProgramMethod singleTarget = holder.lookupProgramMethod(invokedMethod);
                    if (singleTarget == null || !((DexEncodedMethod)singleTarget.getDefinition()).isInliningCandidate(this.method, Inliner.Reason.ALWAYS, (AppInfoWithClassHierarchy)this.appView.appInfo(), (WhyAreYouNotInliningReporter)NopWhyAreYouNotInliningReporter.getInstance())) {
                        throw new IllegalClassInlinerStateException();
                    }
                    this.directMethodCalls.put(invoke, new Inliner.InliningInfo(singleTarget, this.eligibleClass));
                    break;
                }
                if (this.directMethodCalls.isEmpty()) continue;
                this.inliner.performForcedInlining(this.method, code, this.directMethodCalls, inliningIRProvider, this.methodProcessor, Timing.empty());
            } while (!this.directMethodCalls.isEmpty());
        }
        return true;
    }

    private boolean forceInlineIndirectMethodInvocations(IRCode code, InliningIRProvider inliningIRProvider) throws IllegalClassInlinerStateException {
        if (this.indirectMethodCallsOnInstance.isEmpty()) {
            return false;
        }
        IdentityHashMap<InvokeMethodWithReceiver, Inliner.InliningInfo> methodCallsOnInstance = new IdentityHashMap<InvokeMethodWithReceiver, Inliner.InliningInfo>();
        Set<Instruction> currentUsers = this.eligibleInstance.uniqueUsers();
        while (!currentUsers.isEmpty()) {
            Set<Instruction> indirectOutValueUsers = Sets.newIdentityHashSet();
            for (Instruction instruction : currentUsers) {
                Value receiver;
                InvokeMethodWithReceiver invoke;
                DexMethod invokedMethod;
                if (instruction.isAssume() || instruction.isCheckCast()) {
                    indirectOutValueUsers.addAll(instruction.outValue().uniqueUsers());
                    continue;
                }
                if (!instruction.isInvokeMethodWithReceiver() || (invokedMethod = (invoke = instruction.asInvokeMethodWithReceiver()).getInvokedMethod()) == this.dexItemFactory.objectMembers.constructor || (receiver = invoke.getReceiver().getAliasedValue(aliasesThroughAssumeAndCheckCasts)) != this.eligibleInstance) continue;
                ExactDynamicType exactReceiverType = DynamicType.createExact(ClassTypeElement.create(this.eligibleClass.getType(), Nullability.definitelyNotNull(), this.appView));
                ProgramMethod singleTarget = invoke.lookupSingleProgramTarget(this.appView, this.method, exactReceiverType);
                if (singleTarget == null || !this.indirectMethodCallsOnInstance.contains(singleTarget)) {
                    throw new IllegalClassInlinerStateException();
                }
                methodCallsOnInstance.put(invoke, new Inliner.InliningInfo(singleTarget, null));
            }
            currentUsers = indirectOutValueUsers;
        }
        if (!methodCallsOnInstance.isEmpty()) {
            this.inliner.performForcedInlining(this.method, code, methodCallsOnInstance, inliningIRProvider, this.methodProcessor, Timing.empty());
        } else assert (this.indirectMethodCallsOnInstance.stream().filter(method -> ((DexEncodedMethod)method.getDefinition()).getOptimizationInfo().mayHaveSideEffects()).allMatch(method -> ((DexEncodedMethod)method.getDefinition()).isInstanceInitializer() && !((DexEncodedMethod)method.getDefinition()).getOptimizationInfo().getContextInsensitiveInstanceInitializerInfo().mayHaveOtherSideEffectsThanInstanceFieldAssignments()));
        return true;
    }

    private void rebindIndirectEligibleInstanceUsersFromPhis() {
        Set<Value> aliases = SetUtils.newIdentityHashSet(this.eligibleInstance);
        Set<Phi> expectedDeadOrTrivialPhis = Sets.newIdentityHashSet();
        WorkList worklist = WorkList.newIdentityWorkList();
        this.eligibleInstance.uniqueUsers().forEach(worklist::addIfNotSeen);
        this.eligibleInstance.uniquePhiUsers().forEach(worklist::addIfNotSeen);
        while (worklist.hasNext()) {
            InstructionOrPhi instructionOrPhi = (InstructionOrPhi)worklist.next();
            if (instructionOrPhi.isPhi()) {
                Phi phi = instructionOrPhi.asPhi();
                expectedDeadOrTrivialPhis.add(phi);
                phi.uniqueUsers().forEach(worklist::addIfNotSeen);
                phi.uniquePhiUsers().forEach(worklist::addIfNotSeen);
                continue;
            }
            Instruction instruction = instructionOrPhi.asInstruction();
            if (!aliasesThroughAssumeAndCheckCasts.isIntroducingAnAlias(instruction)) continue;
            aliases.add(instruction.outValue());
            instruction.outValue().uniqueUsers().forEach(worklist::addIfNotSeen);
            instruction.outValue().uniquePhiUsers().forEach(worklist::addIfNotSeen);
        }
        for (Phi deadTrivialPhi : expectedDeadOrTrivialPhis) {
            for (Value operand : deadTrivialPhi.getOperands()) {
                if ((operand = operand.getAliasedValue(aliasesThroughAssumeAndCheckCasts)).isPhi() && !expectedDeadOrTrivialPhis.contains(operand.asPhi())) {
                    throw new InternalCompilerError("Unexpected non-trivial phi in method eligible for class inlining");
                }
                if (operand.isPhi() || aliases.contains(operand)) continue;
                throw new InternalCompilerError("Unexpected non-trivial phi in method eligible for class inlining");
            }
            deadTrivialPhi.replaceUsers(this.eligibleInstance);
            deadTrivialPhi.removeDeadPhi();
        }
        for (Value alias : aliases) {
            if (alias == this.eligibleInstance) continue;
            assert (alias.definition.isAssume() || alias.definition.isCheckCast());
            alias.replaceUsers(this.eligibleInstance);
            this.removeInstruction(alias.definition);
        }
        assert (this.eligibleInstance.aliasedUsers().stream().noneMatch(Instruction::isAssume));
        assert (this.eligibleInstance.aliasedUsers().stream().noneMatch(Instruction::isCheckCast));
    }

    private void removeMiscUsages(IRCode code, Set<Value> affectedValues) {
        boolean needToRemoveUnreachableBlocks = false;
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (user.isInvokeMethod()) {
                boolean isSideEffectFree;
                InvokeMethod invoke = user.asInvokeMethod();
                if (user.isInvokeDirect() && this.root.isNewInstance() && invoke.getInvokedMethod() == this.dexItemFactory.objectMembers.constructor) {
                    this.removeInstruction(invoke);
                    continue;
                }
                if (user.isInvokeStatic()) {
                    assert (invoke.getInvokedMethod() == this.dexItemFactory.objectsMethods.requireNonNull);
                    this.removeInstruction(invoke);
                    continue;
                }
                DexClassAndMethod singleTarget = invoke.lookupSingleTarget(this.appView, this.method);
                if (singleTarget != null && singleTarget.isLibraryMethod() && (isSideEffectFree = this.appView.getLibraryMethodSideEffectModelCollection().isSideEffectFree(invoke, singleTarget.asLibraryMethod())) && (!invoke.hasOutValue() || !invoke.outValue().hasAnyUsers())) {
                    this.removeInstruction(invoke);
                    continue;
                }
            }
            if (user.isIf()) {
                BasicBlock blockToRemove;
                If ifInsn = user.asIf();
                assert (ifInsn.isZeroTest()) : "Unexpected usage in non-zero-test IF instruction: " + user;
                BasicBlock block = user.getBlock();
                If.Type type = ifInsn.getType();
                assert (type == If.Type.EQ || type == If.Type.NE) : "Unexpected type in zero-test IF instruction: " + user;
                BasicBlock newBlock = type == If.Type.EQ ? ifInsn.fallthroughBlock() : ifInsn.getTrueTarget();
                BasicBlock basicBlock = blockToRemove = type == If.Type.EQ ? ifInsn.getTrueTarget() : ifInsn.fallthroughBlock();
                assert (newBlock != blockToRemove);
                block.replaceSuccessor(blockToRemove, newBlock);
                blockToRemove.removePredecessor(block, null);
                assert (block.exit().isGoto());
                assert (block.exit().asGoto().getTarget() == newBlock);
                needToRemoveUnreachableBlocks = true;
                continue;
            }
            if (user.isInstanceGet() || user.isInstancePut()) continue;
            if (user.isMonitor()) {
                this.removeInstruction(user);
                continue;
            }
            throw new Unreachable("Unexpected usage left in method `" + this.method.toSourceString() + "` after inlining: " + user);
        }
        if (needToRemoveUnreachableBlocks) {
            affectedValues.addAll(code.removeUnreachableBlocks());
        }
    }

    private void removeFieldReads(IRCode code, AssumeRemover assumeRemover) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        if (this.root.isNewInstance()) {
            this.removeFieldReadsFromNewInstance(code, affectedValues, assumeRemover);
        } else {
            assert (this.root.isStaticGet());
            this.removeFieldReadsFromStaticGet(code, affectedValues, assumeRemover);
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }

    private void removeFieldReadsFromNewInstance(IRCode code, Set<Value> affectedValues, AssumeRemover assumeRemover) {
        TreeSet<InstanceGet> uniqueInstanceGetUsersWithDeterministicOrder = new TreeSet<InstanceGet>(Comparator.comparingInt(x -> x.outValue().getNumber()));
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (user.isInstanceGet()) {
                assumeRemover.markAssumeDynamicTypeUsersForRemoval(user.outValue());
                if (user.hasUsedOutValue()) {
                    uniqueInstanceGetUsersWithDeterministicOrder.add(user.asInstanceGet());
                    continue;
                }
                this.removeInstruction(user);
                continue;
            }
            if (user.isInstancePut()) {
                assert (this.root.isNewInstance());
                continue;
            }
            throw new Unreachable("Unexpected usage left in method `" + this.method.toSourceString() + "` after inlining: " + user);
        }
        IdentityHashMap<DexField, FieldValueHelper> fieldHelpers = new IdentityHashMap<DexField, FieldValueHelper>();
        for (InstanceGet user : uniqueInstanceGetUsersWithDeterministicOrder) {
            this.removeFieldReadFromNewInstance(code, user, affectedValues, fieldHelpers);
        }
    }

    private void removeFieldReadFromNewInstance(IRCode code, InstanceGet fieldRead, Set<Value> affectedValues, Map<DexField, FieldValueHelper> fieldHelpers) {
        Value value = fieldRead.outValue();
        if (value != null) {
            FieldValueHelper helper = fieldHelpers.computeIfAbsent(fieldRead.getField(), field -> new FieldValueHelper((DexField)field, code, this.root, this.appView));
            Value newValue = helper.getValueForFieldRead(fieldRead.getBlock(), fieldRead);
            value.replaceUsers(newValue);
            for (FieldValueHelper fieldValueHelper : fieldHelpers.values()) {
                fieldValueHelper.replaceValue(value, newValue);
            }
            assert (!value.hasAnyUsers());
            affectedValues.add(newValue);
            affectedValues.addAll(newValue.affectedValues());
        }
        this.removeInstruction(fieldRead);
    }

    private void removeFieldReadsFromStaticGet(IRCode code, Set<Value> affectedValues, AssumeRemover assumeRemover) {
        Set<BasicBlock> seen = Sets.newIdentityHashSet();
        Set<Instruction> users = this.eligibleInstance.uniqueUsers();
        for (Instruction user : users) {
            BasicBlock block;
            if (!user.hasBlock() || !seen.add(block = user.getBlock())) continue;
            InstructionListIterator instructionIterator = block.listIterator(code);
            while (instructionIterator.hasNext()) {
                Instruction instruction = (Instruction)instructionIterator.next();
                if (!users.contains(instruction)) continue;
                if (instruction.isInstanceGet()) {
                    assumeRemover.markAssumeDynamicTypeUsersForRemoval(instruction.outValue());
                    if (instruction.hasUsedOutValue()) {
                        this.replaceFieldReadFromStaticGet(code, instructionIterator, user.asInstanceGet(), affectedValues);
                        continue;
                    }
                    instructionIterator.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                if (instruction.isInstancePut()) {
                    instructionIterator.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                throw new Unreachable("Unexpected usage left in method `" + this.method.toSourceString() + "` after inlining: " + user);
            }
        }
    }

    private void replaceFieldReadFromStaticGet(IRCode code, InstructionListIterator instructionIterator, InstanceGet fieldRead, Set<Value> affectedValues) {
        DexClass holder;
        DexField fieldReference = fieldRead.getField();
        DexEncodedField field = fieldReference.lookupOnClass(holder = this.appView.definitionFor(fieldReference.getHolderType(), this.method));
        if (field == null) {
            throw this.reportUnknownFieldReadFromSingleton(fieldRead);
        }
        AbstractValue abstractValue = this.objectState.getAbstractFieldValue(field);
        if (!abstractValue.isSingleConstValue()) {
            throw this.reportUnknownFieldReadFromSingleton(fieldRead);
        }
        SingleConstValue singleConstValue = abstractValue.asSingleConstValue();
        if (!singleConstValue.isMaterializableInContext(this.appView, this.method)) {
            throw this.reportUnknownFieldReadFromSingleton(fieldRead);
        }
        Instruction replacement = singleConstValue.createMaterializingInstruction(this.appView, code, fieldRead);
        instructionIterator.replaceCurrentInstruction(replacement, affectedValues);
    }

    private RuntimeException reportUnknownFieldReadFromSingleton(InstanceGet fieldRead) {
        throw this.appView.reporter().fatalError("Unexpected usage left in method `" + this.method.toSourceString() + "` after inlining: " + fieldRead.toString());
    }

    private void removeFieldWrites() {
        for (Instruction user : this.eligibleInstance.uniqueUsers()) {
            if (!user.isInstancePut()) {
                throw new Unreachable("Unexpected usage left in method `" + this.method.toSourceString() + "` after field reads removed: " + user);
            }
            assert (this.root.isNewInstance());
            InstancePut instancePut = user.asInstancePut();
            DexEncodedField field = this.appView.appInfo().resolveFieldOn(this.eligibleClass, instancePut.getField()).getResolvedField();
            if (field == null) {
                throw new Unreachable("Unexpected field write left in method `" + this.method.toSourceString() + "` after field reads removed: " + user);
            }
            this.removeInstruction(user);
        }
    }

    private Inliner.InliningInfo isEligibleConstructorCall(InvokeDirect invoke, ProgramMethod singleTarget) {
        assert (this.dexItemFactory.isConstructor(invoke.getInvokedMethod()));
        assert (this.isEligibleSingleTarget(singleTarget));
        if (!this.receivers.isDefiniteReceiverAlias(invoke.getReceiver())) {
            return null;
        }
        List<Value> inValues = invoke.inValues();
        for (int i = 1; i < inValues.size(); ++i) {
            if (this.receivers.addIllegalReceiverAlias(inValues.get(i))) continue;
            return null;
        }
        DexMethod init = invoke.getInvokedMethod();
        if (init.holder != this.eligibleClass.type) {
            return null;
        }
        InstanceInitializerInfo instanceInitializerInfo = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getInstanceInitializerInfo(invoke);
        if (instanceInitializerInfo.receiverMayEscapeOutsideConstructorChain()) {
            return null;
        }
        if (!AndroidApiLevelUtils.isApiSafeForInlining(this.method, singleTarget, this.appView.options())) {
            return null;
        }
        DexMethod parent = instanceInitializerInfo.getParent();
        while (parent != this.dexItemFactory.objectMembers.constructor) {
            if (parent == null) {
                return null;
            }
            DexProgramClass parentClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionForHolder(parent, this.method));
            if (parentClass == null) {
                return null;
            }
            ProgramMethod encodedParent = parentClass.lookupProgramMethod(parent);
            if (encodedParent == null) {
                return null;
            }
            if (this.methodProcessor.isProcessedConcurrently(encodedParent)) {
                return null;
            }
            DexEncodedMethod encodedParentMethod = (DexEncodedMethod)encodedParent.getDefinition();
            if (!encodedParentMethod.isInliningCandidate(this.method, Inliner.Reason.ALWAYS, (AppInfoWithClassHierarchy)this.appView.appInfo(), (WhyAreYouNotInliningReporter)NopWhyAreYouNotInliningReporter.getInstance())) {
                return null;
            }
            if (!AndroidApiLevelUtils.isApiSafeForInlining(this.method, encodedParent, this.appView.options())) {
                return null;
            }
            parent = encodedParentMethod.getOptimizationInfo().getContextInsensitiveInstanceInitializerInfo().getParent();
        }
        return new Inliner.InliningInfo(singleTarget, this.eligibleClass);
    }

    private boolean scheduleNewUsersForAnalysis(InvokeMethod invoke, ProgramMethod singleTarget, int parameter, Set<Instruction> indirectUsers) {
        OptionalBool returnsParameter;
        ClassInlinerMethodConstraint classInlinerMethodConstraint = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getClassInlinerMethodConstraint();
        ParameterUsage usage = classInlinerMethodConstraint.getParameterUsage(parameter);
        if (usage.isParameterReturned()) {
            if (((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().returnsArgument()) {
                assert (((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getReturnedArgument() == parameter);
                returnsParameter = OptionalBool.TRUE;
            } else {
                returnsParameter = OptionalBool.UNKNOWN;
            }
        } else {
            returnsParameter = OptionalBool.FALSE;
        }
        if (returnsParameter.isFalse()) {
            return true;
        }
        Value outValue = invoke.outValue();
        if (outValue == null || !outValue.hasAnyUsers()) {
            return true;
        }
        if (outValue.hasPhiUsers() || outValue.hasDebugUsers()) {
            return false;
        }
        if (returnsParameter.isUnknown()) {
            return false;
        }
        assert (returnsParameter.isTrue());
        if (!this.receivers.addReceiverAlias(outValue)) {
            return false;
        }
        indirectUsers.addAll(outValue.uniqueUsers());
        return true;
    }

    private boolean isEligibleIndirectVirtualMethodCall(DexMethod invokedMethod, ProgramMethod singleTarget) {
        if (!this.isEligibleSingleTarget(singleTarget)) {
            return false;
        }
        if (((DexEncodedMethod)singleTarget.getDefinition()).isLibraryMethodOverride().isTrue()) {
            return false;
        }
        if (!this.isEligibleVirtualMethodCall(invokedMethod, singleTarget)) {
            return false;
        }
        ParameterUsage usage = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getClassInlinerMethodConstraint().getParameterUsage(0);
        assert (!usage.isTop());
        if (usage.isBottom()) {
            return true;
        }
        NonEmptyParameterUsage nonEmptyUsage = usage.asNonEmpty();
        return nonEmptyUsage.getMethodCallsWithParameterAsReceiver().isEmpty() && !nonEmptyUsage.isParameterReturned();
    }

    private boolean isEligibleVirtualMethodCall(DexMethod callee, ProgramMethod singleTarget) {
        assert (this.isEligibleSingleTarget(singleTarget));
        MethodResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOnClass(callee, (DexClass)this.eligibleClass);
        if (resolutionResult.isSingleResolution() && !resolutionResult.getSingleTarget().isNonPrivateVirtualMethod()) {
            return false;
        }
        if (!((DexEncodedMethod)singleTarget.getDefinition()).isNonPrivateVirtualMethod()) {
            return false;
        }
        if (this.method.getDefinition() == singleTarget.getDefinition()) {
            return false;
        }
        MethodOptimizationInfo optimizationInfo = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo();
        ClassInlinerMethodConstraint classInlinerMethodConstraint = optimizationInfo.getClassInlinerMethodConstraint();
        int parameter = 0;
        if (this.root.isNewInstance()) {
            return classInlinerMethodConstraint.isEligibleForNewInstanceClassInlining(this.appView, this.eligibleClass, singleTarget, parameter);
        }
        assert (this.root.isStaticGet());
        return classInlinerMethodConstraint.isEligibleForStaticGetClassInlining(this.appView, this.eligibleClass, parameter, this.objectState, this.method);
    }

    private boolean isEligibleDirectMethodCall(InvokeMethod invoke, MethodResolutionResult.SingleResolutionResult resolutionResult, ProgramMethod singleTarget, Supplier<InliningOracle> defaultOracle, Set<Instruction> indirectUsers) {
        Value receiver;
        if (!(invoke.isInvokeDirect() && !invoke.isInvokeConstructor(this.dexItemFactory) || invoke.isInvokeInterface() || invoke.isInvokeStatic() || invoke.isInvokeVirtual())) {
            return false;
        }
        if (invoke.isInvokeMethodWithReceiver() && (receiver = invoke.asInvokeMethodWithReceiver().getReceiver()).getType().isDefinitelyNull()) {
            return false;
        }
        InliningOracle oracle = defaultOracle.get();
        if (!oracle.passesInliningConstraints(invoke, resolutionResult, singleTarget, Inliner.Reason.ALWAYS, NopWhyAreYouNotInliningReporter.getInstance())) {
            return false;
        }
        if (!this.isEligibleParameterUsages(invoke, singleTarget, indirectUsers)) {
            return false;
        }
        this.directMethodCalls.put(invoke, new Inliner.InliningInfo(singleTarget, null));
        this.markSizeOfDirectTargetForInlining(invoke, singleTarget);
        return true;
    }

    private boolean isEligibleLibraryMethodCall(InvokeMethod invoke, LibraryMethod singleTarget) {
        boolean isSideEffectFree = this.appView.getLibraryMethodSideEffectModelCollection().isSideEffectFree(invoke, singleTarget);
        if (isSideEffectFree) {
            return !invoke.hasOutValue() || !invoke.outValue().hasAnyUsers();
        }
        if (singleTarget.getReference() == this.dexItemFactory.objectsMethods.requireNonNull) {
            return !invoke.hasOutValue() || !invoke.outValue().hasAnyUsers();
        }
        return false;
    }

    private boolean isEligibleParameterUsages(InvokeMethod invoke, ProgramMethod singleTarget, Set<Instruction> indirectUsers) {
        for (int parameter = 0; parameter < invoke.arguments().size(); ++parameter) {
            Value argument = invoke.getArgument(parameter);
            if (this.receivers.isReceiverAlias(argument)) {
                if (this.isEligibleParameterUsage(invoke, singleTarget, parameter, indirectUsers)) continue;
                return false;
            }
            int finalParameter = parameter;
            this.receivers.addDeferredAliasValidityCheck(argument, () -> this.isEligibleParameterUsage(invoke, singleTarget, finalParameter, indirectUsers));
        }
        return true;
    }

    private boolean isEligibleParameterUsage(InvokeMethod invoke, ProgramMethod singleTarget, int parameter, Set<Instruction> indirectUsers) {
        ClassInlinerMethodConstraint classInlinerMethodConstraint = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().getClassInlinerMethodConstraint();
        if (this.root.isNewInstance()) {
            if (!classInlinerMethodConstraint.isEligibleForNewInstanceClassInlining(this.appView, this.eligibleClass, singleTarget, parameter)) {
                return false;
            }
        } else {
            assert (this.root.isStaticGet());
            if (!classInlinerMethodConstraint.isEligibleForStaticGetClassInlining(this.appView, this.eligibleClass, parameter, this.objectState, this.method)) {
                return false;
            }
        }
        ParameterUsage usage = classInlinerMethodConstraint.getParameterUsage(parameter);
        if (!this.scheduleNewUsersForAnalysis(invoke, singleTarget, parameter, indirectUsers)) {
            return false;
        }
        if (!usage.isBottom()) {
            NonEmptyParameterUsage nonEmptyUsage = usage.asNonEmpty();
            for (DexMethod invokedMethod : nonEmptyUsage.getMethodCallsWithParameterAsReceiver()) {
                MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOn((DexClass)this.eligibleClass, invokedMethod).asSingleResolution();
                if (resolutionResult == null || !resolutionResult.getResolvedHolder().isProgramClass()) {
                    return false;
                }
                ProgramMethod indirectSingleTarget = resolutionResult.getResolutionPair().asProgramMethod();
                if (!this.isEligibleIndirectVirtualMethodCall(invokedMethod, indirectSingleTarget)) {
                    return false;
                }
                this.markSizeOfIndirectTargetForInlining(indirectSingleTarget);
            }
        }
        return true;
    }

    private boolean exemptFromInstructionLimit(ProgramMethod inlinee) {
        KotlinClassLevelInfo kotlinInfo = inlinee.getHolder().getKotlinInfo();
        return kotlinInfo.isSyntheticClass() && kotlinInfo.asSyntheticClass().isLambda();
    }

    private void markSizeOfIndirectTargetForInlining(ProgramMethod inlinee) {
        assert (!this.methodProcessor.isProcessedConcurrently(inlinee));
        if (!this.exemptFromInstructionLimit(inlinee)) {
            this.indirectInlinees.add(inlinee);
        }
        this.indirectMethodCallsOnInstance.add(inlinee);
    }

    private void markSizeOfDirectTargetForInlining(InvokeMethod invoke, ProgramMethod inlinee) {
        assert (invoke != null);
        assert (!this.methodProcessor.isProcessedConcurrently(inlinee));
        if (!this.exemptFromInstructionLimit(inlinee)) {
            this.directInlinees.put(invoke, inlinee);
        }
    }

    private boolean isEligibleSingleTarget(ProgramMethod singleTarget) {
        if (singleTarget == null) {
            return false;
        }
        if (this.methodProcessor.isProcessedConcurrently(singleTarget)) {
            return false;
        }
        if (AccessControl.isMemberAccessible(singleTarget, (DexClass)singleTarget.getHolder(), this.method, this.appView).isPossiblyFalse()) {
            return false;
        }
        if (!this.appView.getKeepInfo(singleTarget).isClassInliningAllowed(this.appView.options())) {
            return false;
        }
        return ((DexEncodedMethod)singleTarget.getDefinition()).isInliningCandidate(this.method, Inliner.Reason.ALWAYS, (AppInfoWithClassHierarchy)this.appView.appInfo(), (WhyAreYouNotInliningReporter)NopWhyAreYouNotInliningReporter.getInstance());
    }

    private void removeInstruction(Instruction instruction) {
        instruction.inValues().forEach(v -> v.removeUser(instruction));
        instruction.getBlock().removeInstruction(instruction);
    }

    DexProgramClass getEligibleClass() {
        return this.eligibleClass;
    }

    Map<InvokeMethod, ProgramMethod> getDirectInlinees() {
        return this.directInlinees;
    }

    List<ProgramMethod> getIndirectInlinees() {
        return this.indirectInlinees;
    }

    ClassInlinerReceiverSet getReceivers() {
        return this.receivers;
    }

    ClassInliner.EligibilityStatus isInstanceEligible() {
        this.eligibleInstance = this.root.outValue();
        if (this.eligibleInstance == null) {
            return ClassInliner.EligibilityStatus.NOT_ELIGIBLE;
        }
        if (this.root.isNewInstance()) {
            this.eligibleClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(this.root.asNewInstance().clazz));
            if (this.eligibleClass == null) {
                return ClassInliner.EligibilityStatus.NOT_ELIGIBLE;
            }
            if (this.method.getHolder() == this.eligibleClass) {
                return ClassInliner.EligibilityStatus.NOT_ELIGIBLE;
            }
            if (this.eligibleClass.classInitializationMayHaveSideEffectsInContext(this.appView, this.method)) {
                return ClassInliner.EligibilityStatus.NOT_ELIGIBLE;
            }
            return ClassInliner.EligibilityStatus.ELIGIBLE;
        }
        assert (this.root.isStaticGet());
        StaticGet staticGet = this.root.asStaticGet();
        FieldResolutionResult.SingleProgramFieldResolutionResult fieldResolutionResult = this.appView.appInfo().resolveField(staticGet.getField()).asSingleProgramFieldResolutionResult();
        if (fieldResolutionResult == null) {
            return ClassInliner.EligibilityStatus.NOT_ELIGIBLE;
        }
        if (this.method.getHolder() == fieldResolutionResult.getResolvedHolder()) {
            return ClassInliner.EligibilityStatus.NOT_ELIGIBLE;
        }
        if (staticGet.instructionMayHaveSideEffects(this.appView, this.method)) {
            return ClassInliner.EligibilityStatus.NOT_ELIGIBLE;
        }
        DexEncodedField field = fieldResolutionResult.getResolvedField();
        FieldOptimizationInfo optimizationInfo = field.getOptimizationInfo();
        DynamicType dynamicType = optimizationInfo.getDynamicType();
        if (!dynamicType.isExactClassType() || !dynamicType.getNullability().isDefinitelyNotNull()) {
            return ClassInliner.EligibilityStatus.NOT_ELIGIBLE;
        }
        this.eligibleClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(dynamicType.getExactClassType().getClassType()));
        if (this.eligibleClass == null) {
            return ClassInliner.EligibilityStatus.NOT_ELIGIBLE;
        }
        AbstractValue abstractValue = optimizationInfo.getAbstractValue();
        this.objectState = abstractValue.isSingleFieldValue() ? abstractValue.asSingleFieldValue().getObjectState() : ObjectState.empty();
        return ClassInliner.EligibilityStatus.ELIGIBLE;
    }

    ClassInliner.EligibilityStatus isClassAndUsageEligible() {
        return this.isClassEligible.apply(this.eligibleClass);
    }

    InstructionOrPhi areInstanceUsersEligible(Supplier<InliningOracle> defaultOracle) {
        if (this.eligibleInstance.hasPhiUsers()) {
            return this.eligibleInstance.firstPhiUser();
        }
        Set<Instruction> currentUsers = this.eligibleInstance.uniqueUsers();
        while (!currentUsers.isEmpty()) {
            Set<Instruction> indirectUsers = Sets.newIdentityHashSet();
            for (Instruction user : currentUsers) {
                DexEncodedField field;
                if (user.isAssume() || user.isCheckCast()) {
                    Value alias;
                    if (user.isCheckCast()) {
                        boolean isCheckCastUnsafe;
                        CheckCast checkCast = user.asCheckCast();
                        boolean bl = isCheckCastUnsafe = !checkCast.getType().isClassType() || !this.appView.appInfo().isSubtype(this.eligibleClass.type, checkCast.getType());
                        if (isCheckCastUnsafe) {
                            return user;
                        }
                    }
                    if (this.receivers.isReceiverAlias(alias = user.outValue())) continue;
                    if (alias.hasPhiUsers()) {
                        return alias.firstPhiUser();
                    }
                    if (!this.receivers.addReceiverAlias(alias)) {
                        return user;
                    }
                    indirectUsers.addAll(alias.uniqueUsers());
                    continue;
                }
                if (user.isInstanceGet()) {
                    field = this.appView.appInfo().resolveField(user.asFieldInstruction().getField()).getResolvedField();
                    if (field == null || field.isStatic()) {
                        return user;
                    }
                    if (!this.root.isStaticGet() || this.objectState.hasMaterializableFieldValueThatMatches(this.appView, field, this.method, AbstractValue::isSingleConstValue)) continue;
                    return user;
                }
                if (user.isInstancePut()) {
                    if (this.root.isStaticGet()) {
                        return user;
                    }
                    if (!this.receivers.addIllegalReceiverAlias(user.asInstancePut().value())) {
                        return user;
                    }
                    field = this.appView.appInfo().resolveField(user.asFieldInstruction().getField()).getResolvedField();
                    if (field != null && !field.isStatic()) continue;
                    return user;
                }
                if (user.isInvokeMethod()) {
                    InvokeMethod invoke = user.asInvokeMethod();
                    MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().resolveMethod(invoke.getInvokedMethod(), invoke.getInterfaceBit()).asSingleResolution();
                    if (resolutionResult == null || resolutionResult.isAccessibleFrom((ProgramDefinition)this.method, this.appView).isPossiblyFalse()) {
                        return user;
                    }
                    DexClassAndMethod singleTarget = invoke.lookupSingleTarget(this.appView, this.method);
                    if (singleTarget == null) {
                        return user;
                    }
                    if (singleTarget.isLibraryMethod() && this.isEligibleLibraryMethodCall(invoke, singleTarget.asLibraryMethod())) continue;
                    ProgramMethod singleProgramTarget = singleTarget.asProgramMethod();
                    if (!this.isEligibleSingleTarget(singleProgramTarget)) {
                        return user;
                    }
                    assert (AccessControl.isClassAccessible(singleProgramTarget.getHolder(), this.method, this.appView).isTrue());
                    if (user.isInvokeConstructor(this.dexItemFactory)) {
                        Inliner.InliningInfo inliningInfo;
                        boolean isCorrespondingConstructorCall;
                        InvokeDirect invokeDirect = user.asInvokeDirect();
                        boolean bl = isCorrespondingConstructorCall = this.root.isNewInstance() && this.root.outValue() == invokeDirect.getReceiver();
                        if (isCorrespondingConstructorCall && (inliningInfo = this.isEligibleConstructorCall(invokeDirect, singleProgramTarget)) != null) {
                            this.directMethodCalls.put(invoke, inliningInfo);
                            continue;
                        }
                        return user;
                    }
                    if (this.isEligibleDirectMethodCall(invoke, resolutionResult, singleProgramTarget, defaultOracle, indirectUsers)) continue;
                    return user;
                }
                if (user.isIf()) {
                    If ifInsn = user.asIf();
                    If.Type type = ifInsn.getType();
                    if (ifInsn.isZeroTest() && (type == If.Type.EQ || type == If.Type.NE)) continue;
                }
                return user;
            }
            currentUsers = indirectUsers;
        }
        return null;
    }

    boolean processInlining(IRCode code, Set<Value> affectedValues, AssumeRemover assumeRemover, InliningIRProvider inliningIRProvider) throws IllegalClassInlinerStateException {
        assert (this.eligibleInstance == this.eligibleInstance.getAliasedValue());
        boolean anyInlinedMethods = this.forceInlineDirectMethodInvocations(code, inliningIRProvider);
        anyInlinedMethods |= this.forceInlineIndirectMethodInvocations(code, inliningIRProvider);
        this.rebindIndirectEligibleInstanceUsersFromPhis();
        this.removeMiscUsages(code, affectedValues);
        this.removeFieldReads(code, assumeRemover);
        this.removeFieldWrites();
        this.removeInstruction(this.root);
        return anyInlinedMethods;
    }

    static class IllegalClassInlinerStateException
    extends Exception {
        IllegalClassInlinerStateException() {
            assert (false);
        }
    }
}

