/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner.analysis;

import com.android.tools.r8.com.google.common.collect.Multiset;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsage;
import com.android.tools.r8.utils.BooleanUtils;
import java.util.Objects;
import java.util.Set;

public class NonEmptyParameterUsage
extends ParameterUsage {
    private Set<DexType> castsWithParameter;
    private Set<DexField> fieldsReadFromParameter;
    private Multiset<DexMethod> methodCallsWithParameterAsReceiver;
    private boolean isParameterMutated;
    private boolean isParameterReturned;
    private boolean isParameterUsedAsLock;

    NonEmptyParameterUsage(Set<DexType> castsWithParameter, Set<DexField> fieldsReadFromParameter, Multiset<DexMethod> methodCallsWithParameterAsReceiver, boolean isParameterMutated, boolean isParameterReturned, boolean isParameterUsedAsLock) {
        assert (!castsWithParameter.isEmpty() || !fieldsReadFromParameter.isEmpty() || !methodCallsWithParameterAsReceiver.isEmpty() || isParameterMutated || isParameterReturned || isParameterUsedAsLock);
        this.castsWithParameter = castsWithParameter;
        this.fieldsReadFromParameter = fieldsReadFromParameter;
        this.methodCallsWithParameterAsReceiver = methodCallsWithParameterAsReceiver;
        this.isParameterMutated = isParameterMutated;
        this.isParameterReturned = isParameterReturned;
        this.isParameterUsedAsLock = isParameterUsedAsLock;
    }

    @Override
    ParameterUsage addCastWithParameter(DexType castType) {
        throw new Unreachable();
    }

    @Override
    ParameterUsage addFieldReadFromParameter(DexField field) {
        throw new Unreachable();
    }

    @Override
    ParameterUsage addMethodCallWithParameterAsReceiver(InvokeMethodWithReceiver invoke) {
        throw new Unreachable();
    }

    @Override
    public NonEmptyParameterUsage asNonEmpty() {
        return this;
    }

    @Override
    ParameterUsage externalize() {
        throw new Unreachable();
    }

    public boolean hasFieldsReadFromParameter() {
        return !this.getFieldsReadFromParameter().isEmpty();
    }

    public Set<DexType> getCastsWithParameter() {
        return this.castsWithParameter;
    }

    public Set<DexField> getFieldsReadFromParameter() {
        return this.fieldsReadFromParameter;
    }

    public Multiset<DexMethod> getMethodCallsWithParameterAsReceiver() {
        return this.methodCallsWithParameterAsReceiver;
    }

    @Override
    public boolean isParameterMutated() {
        return this.isParameterMutated;
    }

    @Override
    public boolean isParameterReturned() {
        return this.isParameterReturned;
    }

    @Override
    public boolean isParameterUsedAsLock() {
        return this.isParameterUsedAsLock;
    }

    @Override
    ParameterUsage setParameterMutated() {
        throw new Unreachable();
    }

    @Override
    ParameterUsage setParameterReturned() {
        throw new Unreachable();
    }

    @Override
    ParameterUsage setParameterUsedAsLock() {
        throw new Unreachable();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        NonEmptyParameterUsage knownParameterUsage = (NonEmptyParameterUsage)obj;
        return this.isParameterMutated == knownParameterUsage.isParameterMutated && this.isParameterReturned == knownParameterUsage.isParameterReturned && this.isParameterUsedAsLock == knownParameterUsage.isParameterUsedAsLock && this.castsWithParameter.equals(knownParameterUsage.castsWithParameter) && this.fieldsReadFromParameter.equals(knownParameterUsage.fieldsReadFromParameter) && this.methodCallsWithParameterAsReceiver.equals(knownParameterUsage.methodCallsWithParameterAsReceiver);
    }

    public int hashCode() {
        int hash = 31 * (31 * (31 + this.castsWithParameter.hashCode()) + this.fieldsReadFromParameter.hashCode()) + this.methodCallsWithParameterAsReceiver.hashCode();
        assert (hash == Objects.hash(this.castsWithParameter, this.fieldsReadFromParameter, this.methodCallsWithParameterAsReceiver));
        hash = hash << 1 | BooleanUtils.intValue(this.isParameterMutated);
        hash = hash << 1 | BooleanUtils.intValue(this.isParameterReturned);
        hash = hash << 1 | BooleanUtils.intValue(this.isParameterUsedAsLock);
        return hash;
    }
}

