/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner.analysis;

import com.android.tools.r8.ir.code.AssumeAndCheckCastAliasedValueConfiguration;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.classinliner.analysis.AnalysisContext;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsage;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsagePerContext;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsages;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectIterator;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.Int2ObjectMapUtils;
import com.android.tools.r8.utils.IntObjConsumer;
import com.android.tools.r8.utils.IntObjPredicate;
import com.android.tools.r8.utils.IntObjToObjFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class NonEmptyParameterUsages
extends ParameterUsages {
    private static final AssumeAndCheckCastAliasedValueConfiguration aliasedValueConfiguration = AssumeAndCheckCastAliasedValueConfiguration.getInstance();
    private final Int2ObjectMap<ParameterUsagePerContext> backing;

    private NonEmptyParameterUsages(Int2ObjectMap<ParameterUsagePerContext> backing) {
        assert (!backing.isEmpty()) : "Should use bottom() instead";
        this.backing = backing;
    }

    public static ParameterUsages create(Int2ObjectMap<ParameterUsagePerContext> backing) {
        return backing.isEmpty() ? NonEmptyParameterUsages.bottom() : new NonEmptyParameterUsages(backing);
    }

    public boolean allMatch(IntObjPredicate<ParameterUsagePerContext> predicate) {
        for (Int2ObjectMap.Entry entry : this.backing.int2ObjectEntrySet()) {
            if (predicate.test(entry.getIntKey(), (ParameterUsagePerContext)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public NonEmptyParameterUsages asNonEmpty() {
        return this;
    }

    @Override
    ParameterUsages externalize() {
        ParameterUsages rebuilt = this.rebuildParameters((parameter, usagePerContext) -> usagePerContext.externalize());
        boolean allBottom = true;
        boolean allTop = true;
        for (ParameterUsagePerContext usagePerContext2 : ((NonEmptyParameterUsages)rebuilt).backing.values()) {
            if (!usagePerContext2.isBottom()) {
                allBottom = false;
            }
            if (usagePerContext2.isTop()) continue;
            allTop = false;
        }
        if (allBottom) {
            return NonEmptyParameterUsages.bottom();
        }
        if (allTop) {
            return NonEmptyParameterUsages.top();
        }
        return rebuilt;
    }

    @Override
    ParameterUsages put(int parameter, ParameterUsagePerContext parameterUsagePerContext) {
        Int2ObjectOpenHashMap<ParameterUsagePerContext> newBacking = new Int2ObjectOpenHashMap<ParameterUsagePerContext>(this.backing);
        newBacking.put(parameter, parameterUsagePerContext);
        return NonEmptyParameterUsages.create(newBacking);
    }

    public void forEach(IntObjConsumer<ParameterUsagePerContext> consumer) {
        Int2ObjectMapUtils.forEach(this.backing, consumer);
    }

    @Override
    public ParameterUsagePerContext get(int parameter) {
        return this.backing.getOrDefault(parameter, ParameterUsagePerContext.top());
    }

    NonEmptyParameterUsages abandonClassInliningInCurrentContexts(Value value) {
        return this.rebuildParameter(value, (context, usage) -> ParameterUsage.top());
    }

    NonEmptyParameterUsages abandonClassInliningInCurrentContexts(Collection<Value> values2) {
        if (values2.isEmpty()) {
            return this;
        }
        int[] parametersToRebuild = new int[values2.size()];
        Iterator<Value> iterator2 = values2.iterator();
        for (int i = 0; i < values2.size(); ++i) {
            parametersToRebuild[i] = iterator2.next().getDefinition().asArgument().getIndex();
        }
        return this.rebuildParameters((currentParameter, usagePerContext) -> ArrayUtils.containsInt(parametersToRebuild, currentParameter) ? usagePerContext.rebuild((context, usage) -> ParameterUsage.top()) : usagePerContext);
    }

    NonEmptyParameterUsages abandonClassInliningInCurrentContexts(Iterable<Value> values2, Predicate<Value> predicate) {
        ArrayList<Value> filtered = new ArrayList<Value>();
        for (Value value : values2) {
            Value root = value.getAliasedValue(aliasedValueConfiguration);
            if (!predicate.test(root)) continue;
            filtered.add(root);
        }
        return this.abandonClassInliningInCurrentContexts(filtered);
    }

    NonEmptyParameterUsages rebuildParameter(Value value, BiFunction<AnalysisContext, ParameterUsage, ParameterUsage> transformation) {
        Value valueRoot = value.getAliasedValue(aliasedValueConfiguration);
        assert (valueRoot.isArgument());
        int parameter = valueRoot.getDefinition().asArgument().getIndex();
        return this.rebuildParameters((currentParameter, usagePerContext) -> currentParameter == parameter ? usagePerContext.rebuild(transformation) : usagePerContext);
    }

    @Override
    NonEmptyParameterUsages rebuildParameters(IntObjToObjFunction<ParameterUsagePerContext, ParameterUsagePerContext> transformation) {
        Int2ObjectOpenHashMap<ParameterUsagePerContext> rebuiltBacking = null;
        for (Int2ObjectMap.Entry entry : this.backing.int2ObjectEntrySet()) {
            int parameter = entry.getIntKey();
            ParameterUsagePerContext usagePerContext = (ParameterUsagePerContext)entry.getValue();
            ParameterUsagePerContext newUsagePerContext = transformation.apply(parameter, (ParameterUsagePerContext)entry.getValue());
            if (newUsagePerContext != usagePerContext) {
                if (rebuiltBacking == null) {
                    Int2ObjectMap.Entry previousEntry;
                    int previousParameter;
                    rebuiltBacking = new Int2ObjectOpenHashMap<ParameterUsagePerContext>();
                    ObjectIterator<Int2ObjectMap.Entry<ParameterUsagePerContext>> objectIterator = this.backing.int2ObjectEntrySet().iterator();
                    while (objectIterator.hasNext() && (previousParameter = (previousEntry = (Int2ObjectMap.Entry)objectIterator.next()).getIntKey()) != parameter) {
                        rebuiltBacking.put(previousParameter, (ParameterUsagePerContext)previousEntry.getValue());
                    }
                }
                rebuiltBacking.put(parameter, newUsagePerContext);
                continue;
            }
            if (rebuiltBacking == null) continue;
            rebuiltBacking.put(parameter, newUsagePerContext);
        }
        return rebuiltBacking != null ? new NonEmptyParameterUsages(rebuiltBacking) : this;
    }

    @Override
    public NonEmptyParameterUsages join(NonEmptyParameterUsages otherAnalysisState) {
        if (this.isBottom()) {
            return otherAnalysisState;
        }
        if (otherAnalysisState.isBottom()) {
            return this;
        }
        Int2ObjectOpenHashMap<ParameterUsagePerContext> newBacking = new Int2ObjectOpenHashMap<ParameterUsagePerContext>(this.backing);
        otherAnalysisState.forEach((parameter, parameterUsagePerContext) -> newBacking.put(parameter, parameterUsagePerContext.join(Int2ObjectMapUtils.getOrDefault(newBacking, parameter, ParameterUsagePerContext.bottom()))));
        return new NonEmptyParameterUsages(newBacking);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        NonEmptyParameterUsages analysisState = (NonEmptyParameterUsages)other;
        return this.backing.equals(analysisState.backing);
    }

    @Override
    public int hashCode() {
        return this.backing.hashCode();
    }
}

