/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.utils.collections.ImmutableInt2ReferenceSortedMap;
import java.util.function.BiConsumer;

public abstract class EnumInstanceFieldData {
    public abstract boolean isUnknown();

    public boolean isKnown() {
        return !this.isUnknown();
    }

    public EnumInstanceFieldKnownData asEnumFieldKnownData() {
        return null;
    }

    public static class EnumInstanceFieldMappingData
    extends EnumInstanceFieldKnownData {
        private final ImmutableInt2ReferenceSortedMap<AbstractValue> mapping;

        public EnumInstanceFieldMappingData(ImmutableInt2ReferenceSortedMap<AbstractValue> mapping) {
            this.mapping = mapping;
        }

        @Override
        public boolean isOrdinal() {
            return false;
        }

        @Override
        public boolean isMapping() {
            return true;
        }

        @Override
        public EnumInstanceFieldMappingData asEnumFieldMappingData() {
            return this;
        }

        public AbstractValue getData(int unboxedEnumValue) {
            return this.mapping.get(unboxedEnumValue);
        }

        public void forEach(BiConsumer<? super Integer, ? super AbstractValue> consumer) {
            this.mapping.forEach(consumer);
        }
    }

    public static class EnumInstanceFieldOrdinalData
    extends EnumInstanceFieldKnownData {
        @Override
        public boolean isOrdinal() {
            return true;
        }

        @Override
        public boolean isMapping() {
            return false;
        }
    }

    public static abstract class EnumInstanceFieldKnownData
    extends EnumInstanceFieldData {
        @Override
        public boolean isUnknown() {
            return false;
        }

        public abstract boolean isOrdinal();

        public abstract boolean isMapping();

        @Override
        public EnumInstanceFieldKnownData asEnumFieldKnownData() {
            return this;
        }

        public EnumInstanceFieldMappingData asEnumFieldMappingData() {
            return null;
        }
    }

    public static class EnumInstanceFieldUnknownData
    extends EnumInstanceFieldData {
        private static final EnumInstanceFieldUnknownData INSTANCE = new EnumInstanceFieldUnknownData();

        public static EnumInstanceFieldUnknownData getInstance() {
            return INSTANCE;
        }

        private EnumInstanceFieldUnknownData() {
        }

        @Override
        public boolean isUnknown() {
            return true;
        }
    }
}

