/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxerImpl;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingCandidateInfoCollection;
import com.android.tools.r8.ir.optimize.enums.eligibility.Reason;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.utils.InternalOptions;

class EnumUnboxingCandidateAnalysis {
    private static final int MAX_INSTANCE_FIELDS_FOR_UNBOXING = 7;
    private final AppView<AppInfoWithLiveness> appView;
    private final EnumUnboxerImpl enumUnboxer;
    private final DexItemFactory factory;
    private EnumUnboxingCandidateInfoCollection enumToUnboxCandidates = new EnumUnboxingCandidateInfoCollection();

    EnumUnboxingCandidateAnalysis(AppView<AppInfoWithLiveness> appView, EnumUnboxerImpl enumUnboxer) {
        this.appView = appView;
        this.enumUnboxer = enumUnboxer;
        this.factory = appView.dexItemFactory();
    }

    private boolean isEnumUnboxingCandidate(DexProgramClass clazz) {
        if (!clazz.isEnum()) {
            return false;
        }
        boolean result = true;
        if (clazz.superType != this.factory.enumType || !clazz.isEffectivelyFinal(this.appView)) {
            if (!this.enumUnboxer.reportFailure(clazz, Reason.SUBTYPES)) {
                return false;
            }
            result = false;
        }
        if (clazz.instanceFields().size() > 7) {
            if (!this.enumUnboxer.reportFailure(clazz, Reason.MANY_INSTANCE_FIELDS)) {
                return false;
            }
            result = false;
        }
        return result;
    }

    private void removeEnumsInAnnotations() {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            if (!clazz.isAnnotation()) continue;
            assert (clazz.interfaces.contains(this.appView.dexItemFactory().annotationType));
            this.removeEnumsInAnnotation(clazz);
        }
    }

    private void removeEnumsInAnnotation(DexProgramClass clazz) {
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            assert (method.getParameters().isEmpty() || this.appView.options().testing.allowInjectedAnnotationMethods);
            DexType valueType = method.returnType().toBaseType(this.appView.dexItemFactory());
            if (!this.enumToUnboxCandidates.isCandidate(valueType) || this.enumUnboxer.reportFailure(valueType, Reason.ANNOTATION)) continue;
            this.enumToUnboxCandidates.removeCandidate(valueType);
        }
    }

    private void removePinnedCandidates() {
        KeepInfoCollection keepInfo = this.appView.appInfo().getKeepInfo();
        InternalOptions options = this.appView.options();
        keepInfo.forEachPinnedType(this::removePinnedCandidate, options);
        keepInfo.forEachPinnedField(field -> this.removePinnedIfNotHolder((DexMember<?, ?>)field, field.type), options);
        keepInfo.forEachPinnedMethod(method -> {
            DexProto proto = method.proto;
            this.removePinnedIfNotHolder((DexMember<?, ?>)method, proto.returnType);
            for (DexType parameterType : proto.parameters.values) {
                this.removePinnedIfNotHolder((DexMember<?, ?>)method, parameterType);
            }
        }, options);
    }

    private void removePinnedIfNotHolder(DexMember<?, ?> member, DexType type) {
        DexType baseType = type.toBaseType(this.factory);
        if (baseType != member.holder) {
            this.removePinnedCandidate(baseType);
        }
    }

    private void removePinnedCandidate(DexType type) {
        if (this.enumToUnboxCandidates.isCandidate(type)) {
            this.enumUnboxer.reportFailure(type, Reason.PINNED);
            this.enumToUnboxCandidates.removeCandidate(type);
        }
    }

    EnumUnboxingCandidateInfoCollection findCandidates(GraphLens graphLensForPrimaryOptimizationPass) {
        if (this.enumUnboxer.getOrdinalField() == null || this.enumUnboxer.getOrdinalField().isProgramField()) {
            return this.enumToUnboxCandidates;
        }
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            if (!this.isEnumUnboxingCandidate(clazz)) continue;
            this.enumToUnboxCandidates.addCandidate(this.appView, clazz, graphLensForPrimaryOptimizationPass);
        }
        this.removeEnumsInAnnotations();
        this.removePinnedCandidates();
        if (this.appView.options().protoShrinking().isProtoShrinkingEnabled()) {
            this.enumToUnboxCandidates.removeCandidate(this.appView.protoShrinker().references.methodToInvokeType);
        }
        return this.enumToUnboxCandidates;
    }
}

