/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.NestedGraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.graph.proto.RewrittenTypeInfo;
import com.android.tools.r8.ir.analysis.value.AbstractValueFactory;
import com.android.tools.r8.ir.analysis.value.SingleFieldValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.conversion.ExtraUnusedNullParameter;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.collections.BidirectionalOneToManyRepresentativeHashMap;
import com.android.tools.r8.utils.collections.BidirectionalOneToManyRepresentativeMap;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneHashMap;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalOneToManyRepresentativeMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalOneToOneMap;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class EnumUnboxingLens
extends NestedGraphLens {
    private final AbstractValueFactory abstractValueFactory;
    private final Map<DexMethod, RewrittenPrototypeDescription> prototypeChangesPerMethod;
    private final EnumDataMap unboxedEnums;

    EnumUnboxingLens(AppView<?> appView, BidirectionalOneToOneMap<DexField, DexField> fieldMap, BidirectionalOneToManyRepresentativeMap<DexMethod, DexMethod> methodMap, Map<DexType, DexType> typeMap, Map<DexMethod, RewrittenPrototypeDescription> prototypeChangesPerMethod) {
        super(appView, fieldMap, methodMap::getRepresentativeValue, typeMap, methodMap);
        assert (!appView.unboxedEnums().isEmpty());
        this.abstractValueFactory = appView.abstractValueFactory();
        this.prototypeChangesPerMethod = prototypeChangesPerMethod;
        this.unboxedEnums = appView.unboxedEnums();
    }

    private SingleValue rewriteSingleValue(SingleValue singleValue) {
        SingleFieldValue singleFieldValue;
        if (singleValue.isSingleFieldValue() && this.unboxedEnums.hasUnboxedValueFor((singleFieldValue = singleValue.asSingleFieldValue()).getField())) {
            return this.abstractValueFactory.createSingleNumberValue(this.unboxedEnums.getUnboxedValue(singleFieldValue.getField()));
        }
        return singleValue;
    }

    public static Builder enumUnboxingLensBuilder(AppView<AppInfoWithLiveness> appView) {
        return new Builder(appView);
    }

    @Override
    public boolean hasCustomCodeRewritings() {
        return true;
    }

    @Override
    public boolean isEnumUnboxerLens() {
        return true;
    }

    @Override
    protected RewrittenPrototypeDescription internalDescribePrototypeChanges(RewrittenPrototypeDescription prototypeChanges, DexMethod method) {
        SingleValue singleValue;
        SingleValue rewrittenSingleValue;
        RewrittenTypeInfo rewrittenReturnInfo;
        if (prototypeChanges.hasRewrittenReturnInfo() && (rewrittenReturnInfo = prototypeChanges.getRewrittenReturnInfo()).hasSingleValue() && (rewrittenSingleValue = this.rewriteSingleValue(singleValue = rewrittenReturnInfo.getSingleValue())) != singleValue) {
            prototypeChanges = prototypeChanges.withRewrittenReturnInfo(RewrittenTypeInfo.builder().setCastType(rewrittenReturnInfo.getCastType()).setOldType(rewrittenReturnInfo.getOldType()).setNewType(rewrittenReturnInfo.getNewType()).setSingleValue(rewrittenSingleValue).build());
        }
        RewrittenPrototypeDescription enumUnboxingPrototypeChanges = this.prototypeChangesPerMethod.getOrDefault(method, RewrittenPrototypeDescription.none());
        return prototypeChanges.combine(enumUnboxingPrototypeChanges);
    }

    @Override
    protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, Invoke.Type type) {
        if (this.typeMap.containsKey(originalMethod.getHolderType())) {
            assert (newMethod != originalMethod);
            return Invoke.Type.STATIC;
        }
        return type;
    }

    static class Builder {
        private final DexItemFactory dexItemFactory;
        private final Map<DexType, DexType> typeMap = new IdentityHashMap<DexType, DexType>();
        private final MutableBidirectionalOneToOneMap<DexField, DexField> newFieldSignatures = new BidirectionalOneToOneHashMap<DexField, DexField>();
        private final MutableBidirectionalOneToManyRepresentativeMap<DexMethod, DexMethod> newMethodSignatures = new BidirectionalOneToManyRepresentativeHashMap<DexMethod, DexMethod>();
        private Map<DexMethod, RewrittenPrototypeDescription> prototypeChangesPerMethod = new IdentityHashMap<DexMethod, RewrittenPrototypeDescription>();

        Builder(AppView<AppInfoWithLiveness> appView) {
            this.dexItemFactory = appView.dexItemFactory();
        }

        public Builder mapUnboxedEnums(Set<DexType> enumsToUnbox) {
            for (DexType enumToUnbox : enumsToUnbox) {
                this.typeMap.put(enumToUnbox, this.dexItemFactory.intType);
            }
            return this;
        }

        public void move(DexField from, DexField to) {
            if (from == to) {
                return;
            }
            this.newFieldSignatures.put(from, to);
        }

        public void move(DexMethod from, DexMethod to, boolean fromStatic, boolean toStatic) {
            this.move(from, to, fromStatic, toStatic, Collections.emptyList());
        }

        public RewrittenPrototypeDescription move(DexMethod from, DexMethod to, boolean fromStatic, boolean toStatic, List<ExtraUnusedNullParameter> extraUnusedNullParameters) {
            assert (from != to);
            this.newMethodSignatures.put(from, to);
            int offsetDiff = 0;
            int toOffset = BooleanUtils.intValue(!toStatic);
            ArgumentInfoCollection.Builder builder = ArgumentInfoCollection.builder().setArgumentInfosSize(from.getNumberOfArguments(fromStatic));
            if (fromStatic != toStatic) {
                assert (toStatic);
                offsetDiff = 1;
                builder.addArgumentInfo(0, RewrittenTypeInfo.builder().setOldType(from.getHolderType()).setNewType(to.getParameter(0)).build()).setIsConvertedToStaticMethod();
            }
            for (int i = 0; i < from.getParameters().size(); ++i) {
                DexType toType;
                DexType fromType = from.getParameter(i);
                if (fromType == (toType = to.getParameter(i + offsetDiff))) continue;
                builder.addArgumentInfo(i + offsetDiff + toOffset, RewrittenTypeInfo.builder().setOldType(fromType).setNewType(toType).build());
            }
            RewrittenTypeInfo returnInfo = from.getReturnType() == to.getReturnType() ? null : RewrittenTypeInfo.builder().setOldType(from.getReturnType()).setNewType(to.getReturnType()).build();
            RewrittenPrototypeDescription prototypeChanges = RewrittenPrototypeDescription.createForRewrittenTypes(returnInfo, builder.build()).withExtraParameters(extraUnusedNullParameters);
            this.prototypeChangesPerMethod.put(to, prototypeChanges);
            return prototypeChanges;
        }

        void recordCheckNotZeroMethod(ProgramMethod checkNotNullMethod, ProgramMethod checkNotZeroMethod) {
            DexMethod originalCheckNotNullMethodSignature = this.newMethodSignatures.getKeyOrDefault((DexMethod)checkNotNullMethod.getReference(), (DexMethod)checkNotNullMethod.getReference());
            this.newMethodSignatures.put(originalCheckNotNullMethodSignature, (DexMethod)checkNotNullMethod.getReference());
            this.newMethodSignatures.put(originalCheckNotNullMethodSignature, (DexMethod)checkNotZeroMethod.getReference());
            this.newMethodSignatures.setRepresentative(originalCheckNotNullMethodSignature, (DexMethod)checkNotNullMethod.getReference());
        }

        public EnumUnboxingLens build(AppView<?> appView) {
            assert (!this.typeMap.isEmpty());
            return new EnumUnboxingLens(appView, this.newFieldSignatures, this.newMethodSignatures, this.typeMap, ImmutableMap.copyOf(this.prototypeChangesPerMethod));
        }
    }
}

