/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfo;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.graph.proto.RewrittenTypeInfo;
import com.android.tools.r8.ir.analysis.type.ArrayTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.ArrayAccess;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NewUnboxedEnumInstance;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.ir.optimize.enums.EnumInstanceFieldData;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxerImpl;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingLens;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingUtilityClasses;
import com.android.tools.r8.ir.optimize.enums.LocalEnumUnboxingUtilityClass;
import com.android.tools.r8.ir.optimize.enums.SharedEnumUnboxingUtilityClass;
import com.android.tools.r8.ir.optimize.enums.classification.CheckNotNullEnumUnboxerMethodClassification;
import com.android.tools.r8.ir.optimize.enums.classification.EnumUnboxerMethodClassification;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class EnumUnboxingRewriter {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<DexMethod, DexMethod> checkNotNullToCheckNotZeroMapping;
    private final DexItemFactory factory;
    private final InternalOptions options;
    private final EnumDataMap unboxedEnumsData;
    private final EnumUnboxingLens enumUnboxingLens;
    private final EnumUnboxingUtilityClasses utilityClasses;

    EnumUnboxingRewriter(AppView<AppInfoWithLiveness> appView, Map<DexMethod, DexMethod> checkNotNullToCheckNotZeroMapping, EnumUnboxingLens enumUnboxingLens, EnumDataMap unboxedEnumsInstanceFieldData, EnumUnboxingUtilityClasses utilityClasses) {
        this.appView = appView;
        this.checkNotNullToCheckNotZeroMapping = checkNotNullToCheckNotZeroMapping;
        this.factory = appView.dexItemFactory();
        this.options = appView.options();
        this.enumUnboxingLens = enumUnboxingLens;
        this.unboxedEnumsData = unboxedEnumsInstanceFieldData;
        this.utilityClasses = utilityClasses;
    }

    private LocalEnumUnboxingUtilityClass getLocalUtilityClass(DexType enumType) {
        return this.utilityClasses.getLocalUtilityClass(enumType);
    }

    private SharedEnumUnboxingUtilityClass getSharedUtilityClass() {
        return this.utilityClasses.getSharedUtilityClass();
    }

    private Map<Instruction, DexType> createInitialConvertedEnums(IRCode code, RewrittenPrototypeDescription prototypeChanges) {
        IdentityHashMap<Instruction, DexType> convertedEnums = new IdentityHashMap<Instruction, DexType>();
        InstructionIterator iterator2 = code.entryBlock().iterator();
        int originalNumberOfArguments = code.getNumberOfArguments() + prototypeChanges.getArgumentInfoCollection().numberOfRemovedArguments();
        for (int argumentIndex = 0; argumentIndex < originalNumberOfArguments; ++argumentIndex) {
            RewrittenTypeInfo rewrittenTypeInfo;
            DexType enumType;
            ArgumentInfo argumentInfo = prototypeChanges.getArgumentInfoCollection().getArgumentInfo(argumentIndex);
            if (argumentInfo.isRemovedArgumentInfo()) continue;
            Instruction next = (Instruction)iterator2.next();
            assert (next.isArgument());
            if (!argumentInfo.isRewrittenTypeInfo() || (enumType = this.getEnumTypeOrNull((rewrittenTypeInfo = argumentInfo.asRewrittenTypeInfo()).getOldType().toBaseType(this.factory))) == null) continue;
            convertedEnums.put(next, enumType);
        }
        return convertedEnums;
    }

    private void rewriteInvokeStatic(InvokeStatic invoke, IRCode code, ProgramMethod context, Map<Instruction, DexType> convertedEnums, InstructionListIterator instructionIterator, Set<Phi> affectedPhis, MethodProcessor methodProcessor) {
        DexClassAndMethod singleTarget = invoke.lookupSingleTarget(this.appView, context);
        if (singleTarget == null) {
            return;
        }
        DexMethod invokedMethod = (DexMethod)singleTarget.getReference();
        if (invokedMethod.getHolderType() == this.factory.enumType) {
            if (invokedMethod == this.factory.enumMembers.valueOf) {
                if (!invoke.getFirstArgument().isConstClass()) {
                    return;
                }
                DexType enumType = invoke.getFirstArgument().getConstInstruction().asConstClass().getValue();
                if (!this.unboxedEnumsData.isUnboxedEnum(enumType)) {
                    return;
                }
                ProgramMethod valueOfMethod = this.getLocalUtilityClass(enumType).ensureValueOfMethod(this.appView);
                Value outValue = invoke.outValue();
                Value rewrittenOutValue = null;
                if (outValue != null) {
                    rewrittenOutValue = code.createValue(TypeElement.getInt());
                    affectedPhis.addAll(outValue.uniquePhiUsers());
                }
                InvokeStatic replacement = new InvokeStatic((DexMethod)valueOfMethod.getReference(), rewrittenOutValue, Collections.singletonList(invoke.inValues().get(1)));
                instructionIterator.replaceCurrentInstruction(replacement);
                convertedEnums.put(replacement, enumType);
            }
            return;
        }
        if (invokedMethod.getHolderType() == this.factory.objectsType) {
            if (invokedMethod == this.factory.objectsMethods.requireNonNull) {
                assert (invoke.arguments().size() == 1);
                Value argument = invoke.getFirstArgument();
                DexType enumType = this.getEnumTypeOrNull(argument, convertedEnums);
                if (enumType != null) {
                    this.rewriteNullCheck(instructionIterator, invoke);
                }
            } else if (invokedMethod == this.factory.objectsMethods.requireNonNullWithMessage) {
                assert (invoke.arguments().size() == 2);
                Value argument = invoke.getFirstArgument();
                DexType enumType = this.getEnumTypeOrNull(argument, convertedEnums);
                if (enumType != null) {
                    this.replaceEnumInvoke(instructionIterator, invoke, this.getSharedUtilityClass().ensureCheckNotZeroWithMessageMethod(this.appView));
                }
            }
            return;
        }
        if (invokedMethod.getHolderType() == this.factory.stringType) {
            if (invokedMethod == this.factory.stringMembers.valueOf) {
                assert (invoke.arguments().size() == 1);
                Value argument = invoke.getFirstArgument();
                DexType enumType = this.getEnumTypeOrNull(argument, convertedEnums);
                if (enumType != null) {
                    ProgramMethod stringValueOfMethod = this.getLocalUtilityClass(enumType).ensureStringValueOfMethod(this.appView);
                    instructionIterator.replaceCurrentInstruction(new InvokeStatic((DexMethod)stringValueOfMethod.getReference(), invoke.outValue(), invoke.arguments()));
                }
            }
            return;
        }
        if (invokedMethod.getHolderType() == this.factory.javaLangSystemType) {
            if (invokedMethod != this.factory.javaLangSystemMethods.arraycopy && invokedMethod == this.factory.javaLangSystemMethods.identityHashCode) {
                assert (invoke.arguments().size() == 1);
                Value argument = invoke.getFirstArgument();
                DexType enumType = this.getEnumTypeOrNull(argument, convertedEnums);
                if (enumType != null) {
                    invoke.outValue().replaceUsers(argument);
                    instructionIterator.removeOrReplaceByDebugLocalRead();
                }
            }
            return;
        }
        if (singleTarget.isProgramMethod() && this.checkNotNullToCheckNotZeroMapping.containsKey(singleTarget.getReference())) {
            DexMethod checkNotZeroMethodReference = this.checkNotNullToCheckNotZeroMapping.get(singleTarget.getReference());
            ProgramMethod checkNotZeroMethod = this.appView.appInfo().resolveMethodOnClass(checkNotZeroMethodReference).getResolvedProgramMethod();
            if (checkNotZeroMethod != null) {
                EnumUnboxerMethodClassification classification = checkNotZeroMethod.getOptimizationInfo().getEnumUnboxerMethodClassification();
                if (classification.isCheckNotNullClassification()) {
                    CheckNotNullEnumUnboxerMethodClassification checkNotNullClassification = classification.asCheckNotNullClassification();
                    Value argument = invoke.getArgument(checkNotNullClassification.getArgumentIndex());
                    DexType enumType = this.getEnumTypeOrNull(argument, convertedEnums);
                    if (enumType != null) {
                        InvokeStatic replacement = ((InvokeStatic.Builder)((InvokeStatic.Builder)((InvokeStatic.Builder)InvokeStatic.builder().setMethod(checkNotZeroMethod)).setArguments(invoke.arguments())).setPosition(invoke.getPosition())).build();
                        instructionIterator.replaceCurrentInstruction(replacement);
                        convertedEnums.put(replacement, enumType);
                    }
                } else assert (false);
            } else assert (false);
        }
    }

    private void removeRedundantValuesArrayCloning(InvokeStatic invoke, Set<Instruction> instructionsToRemove, Set<BasicBlock> seenBlocks) {
        for (Instruction user : invoke.outValue().aliasedUsers()) {
            BasicBlock cloneBlock;
            InvokeVirtual cloneCandidate;
            if (!user.isInvokeVirtual() || !(cloneCandidate = user.asInvokeVirtual()).getInvokedMethod().match(this.appView.dexItemFactory().objectMembers.clone)) continue;
            if (cloneCandidate.hasOutValue()) {
                cloneCandidate.outValue().replaceUsers(invoke.outValue());
            }
            if ((cloneBlock = cloneCandidate.getBlock()) == invoke.getBlock() || !seenBlocks.contains(cloneBlock)) {
                instructionsToRemove.add(cloneCandidate);
                continue;
            }
            cloneBlock.removeInstruction(cloneCandidate);
        }
    }

    private void rewriteNameMethod(InstructionListIterator iterator2, InvokeMethodWithReceiver invoke, DexType enumType, MethodProcessor methodProcessor) {
        ProgramMethod toStringMethod = this.getLocalUtilityClass(enumType).ensureGetInstanceFieldMethod(this.appView, this.factory.enumMembers.nameField);
        iterator2.replaceCurrentInstruction(new InvokeStatic((DexMethod)toStringMethod.getReference(), invoke.outValue(), invoke.arguments()));
    }

    private Value fixNullsInBlockPhis(IRCode code, BasicBlock block, Value zeroConstValue) {
        for (Phi phi : block.getPhis()) {
            if (this.getEnumTypeOrNull(phi.getType()) == null) continue;
            for (int i = 0; i < phi.getOperands().size(); ++i) {
                Value operand = phi.getOperand(i);
                if (!operand.getType().isNullType()) continue;
                if (zeroConstValue == null) {
                    zeroConstValue = this.insertConstZero(code);
                }
                phi.replaceOperandAt(i, zeroConstValue);
            }
        }
        return zeroConstValue;
    }

    private Value insertConstZero(IRCode code) {
        InstructionListIterator iterator2 = code.entryBlock().listIterator(code);
        while (iterator2.hasNext() && iterator2.peekNext().isArgument()) {
            iterator2.next();
        }
        return iterator2.insertConstIntInstruction(code, this.options, 0);
    }

    private ProgramMethod ensureInstanceFieldMethod(DexField field, MethodProcessor methodProcessor) {
        EnumInstanceFieldData.EnumInstanceFieldKnownData enumFieldKnownData = this.unboxedEnumsData.getInstanceFieldData(field.holder, field);
        if (enumFieldKnownData.isOrdinal()) {
            return this.getSharedUtilityClass().ensureOrdinalMethod(this.appView);
        }
        return this.getLocalUtilityClass(field.getHolderType()).ensureGetInstanceFieldMethod(this.appView, field);
    }

    private void replaceEnumInvoke(InstructionListIterator iterator2, InvokeMethod invoke, ProgramMethod method) {
        InvokeStatic replacement = new InvokeStatic((DexMethod)method.getReference(), invoke.hasUnusedOutValue() ? null : invoke.outValue(), invoke.arguments());
        assert (!replacement.hasOutValue() || !replacement.getInvokedMethod().getReturnType().isVoidType());
        iterator2.replaceCurrentInstruction(replacement);
    }

    private boolean validateArrayAccess(ArrayAccess arrayAccess) {
        ArrayTypeElement arrayType = arrayAccess.array().getType().asArrayType();
        if (arrayType == null) {
            assert (arrayAccess.array().getType().isNullType());
            return true;
        }
        assert (arrayAccess.getMemberType() != MemberType.OBJECT || arrayType.getNesting() > 1 || arrayType.getBaseType().isReferenceType());
        return true;
    }

    private DexType getEnumTypeOrNull(Value receiver, Map<Instruction, DexType> convertedEnums) {
        TypeElement type = receiver.getType();
        if (type.isInt() || type.isArrayType() && type.asArrayType().getBaseType().isInt()) {
            return receiver.isPhi() ? null : convertedEnums.get(receiver.getDefinition());
        }
        return this.getEnumTypeOrNull(type);
    }

    private DexType getEnumTypeOrNull(TypeElement type) {
        if (!type.isClassType()) {
            return null;
        }
        return this.getEnumTypeOrNull(type.asClassType().getClassType());
    }

    private DexType getEnumTypeOrNull(DexType type) {
        return this.unboxedEnumsData.isUnboxedEnum(type) ? type : null;
    }

    private DexType getEnumTypeOrNull(ArrayAccess arrayAccess, Map<Instruction, DexType> convertedEnums) {
        ArrayTypeElement arrayType = arrayAccess.array().getType().asArrayType();
        if (arrayType == null) {
            assert (arrayAccess.array().getType().isNullType());
            return null;
        }
        if (arrayType.getNesting() != 1) {
            return null;
        }
        TypeElement baseType = arrayType.getBaseType();
        if (baseType.isClassType()) {
            DexType classType = baseType.asClassType().getClassType();
            return this.unboxedEnumsData.isUnboxedEnum(classType) ? classType : null;
        }
        return this.getEnumTypeOrNull(arrayAccess.array(), convertedEnums);
    }

    Set<Phi> rewriteCode(IRCode code, MethodProcessor methodProcessor, RewrittenPrototypeDescription prototypeChanges) {
        if (this.unboxedEnumsData.isEmpty()) {
            return Sets.newIdentityHashSet();
        }
        assert (code.isConsistentSSABeforeTypesAreCorrect(this.appView));
        ProgramMethod context = code.context();
        Map<Instruction, DexType> convertedEnums = this.createInitialConvertedEnums(code, prototypeChanges);
        Set<Phi> affectedPhis = Sets.newIdentityHashSet();
        BasicBlockIterator blocks = code.listIterator();
        Set<BasicBlock> seenBlocks = Sets.newIdentityHashSet();
        Set<Instruction> instructionsToRemove = Sets.newIdentityHashSet();
        Value zeroConstValue = null;
        while (blocks.hasNext()) {
            BasicBlock block = (BasicBlock)blocks.next();
            seenBlocks.add(block);
            zeroConstValue = this.fixNullsInBlockPhis(code, block, zeroConstValue);
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                If ifInstruction;
                Instruction instruction = (Instruction)iterator2.next();
                if (instructionsToRemove.contains(instruction)) {
                    iterator2.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                if (instruction.isInitClass()) {
                    InitClass initClass = instruction.asInitClass();
                    DexType enumType = this.getEnumTypeOrNull(initClass.getClassValue());
                    if (enumType == null) continue;
                    iterator2.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                if (instruction.isIf() && !(ifInstruction = instruction.asIf()).isZeroTest()) {
                    for (int operandIndex = 0; operandIndex < 2; ++operandIndex) {
                        int otherOperandIndex;
                        Value otherOperand;
                        Value operand = ifInstruction.getOperand(operandIndex);
                        DexType enumType = this.getEnumTypeOrNull(operand, convertedEnums);
                        if (enumType == null || !(otherOperand = ifInstruction.getOperand(otherOperandIndex = 1 - operandIndex)).getType().isNullType()) continue;
                        iterator2.previous();
                        ifInstruction.replaceValue(otherOperandIndex, iterator2.insertConstIntInstruction(code, this.options, 0));
                        iterator2.next();
                        break;
                    }
                }
                if (instruction.isInvokeMethodWithReceiver()) {
                    Value enumArg;
                    DexType enumArgType;
                    InvokeMethodWithReceiver invoke = instruction.asInvokeMethodWithReceiver();
                    DexType enumType = this.getEnumTypeOrNull(invoke.getReceiver(), convertedEnums);
                    DexMethod invokedMethod = invoke.getInvokedMethod();
                    if (enumType != null) {
                        if (invokedMethod == this.factory.enumMembers.ordinalMethod || invokedMethod.match(this.factory.enumMembers.hashCode)) {
                            this.replaceEnumInvoke(iterator2, invoke, this.getSharedUtilityClass().ensureOrdinalMethod(this.appView));
                            continue;
                        }
                        if (invokedMethod.match(this.factory.enumMembers.equals)) {
                            this.replaceEnumInvoke(iterator2, invoke, this.getSharedUtilityClass().ensureEqualsMethod(this.appView));
                            continue;
                        }
                        if (invokedMethod == this.factory.enumMembers.compareTo || invokedMethod == this.factory.enumMembers.compareToWithObject) {
                            this.replaceEnumInvoke(iterator2, invoke, this.getSharedUtilityClass().ensureCompareToMethod(this.appView));
                            continue;
                        }
                        if (invokedMethod == this.factory.enumMembers.nameMethod) {
                            this.rewriteNameMethod(iterator2, invoke, enumType, methodProcessor);
                            continue;
                        }
                        if (invokedMethod.match(this.factory.enumMembers.toString)) {
                            DexMethod lookupMethod = this.enumUnboxingLens.lookupMethod(invokedMethod);
                            if (invoke.isInvokeSuper() || lookupMethod == invokedMethod) {
                                this.rewriteNameMethod(iterator2, invoke, enumType, methodProcessor);
                                continue;
                            }
                        } else if (invokedMethod == this.factory.objectMembers.getClass) {
                            this.rewriteNullCheck(iterator2, invoke);
                            continue;
                        }
                    } else if ((invokedMethod == this.factory.stringBuilderMethods.appendObject || invokedMethod == this.factory.stringBufferMethods.appendObject) && (enumArgType = this.getEnumTypeOrNull(enumArg = invoke.getArgument(1), convertedEnums)) != null) {
                        ProgramMethod stringValueOfMethod = this.getLocalUtilityClass(enumArgType).ensureStringValueOfMethod(this.appView);
                        InvokeStatic toStringInvoke = ((InvokeStatic.Builder)((InvokeStatic.Builder)((InvokeStatic.Builder)((InvokeStatic.Builder)InvokeStatic.builder().setMethod(stringValueOfMethod)).setSingleArgument(enumArg)).setFreshOutValue(this.appView, code)).setPosition(invoke)).build();
                        DexMethod newAppendMethod = invokedMethod == this.factory.stringBuilderMethods.appendObject ? this.factory.stringBuilderMethods.appendString : this.factory.stringBufferMethods.appendString;
                        ImmutableList<Value> arguments = ImmutableList.of(invoke.getReceiver(), toStringInvoke.outValue());
                        InvokeVirtual invokeAppendString = new InvokeVirtual(newAppendMethod, invoke.clearOutValue(), arguments);
                        invokeAppendString.setPosition(invoke.getPosition());
                        iterator2.replaceCurrentInstruction(toStringInvoke);
                        if (block.hasCatchHandlers()) {
                            iterator2.splitCopyCatchHandlers(code, blocks, this.appView.options()).listIterator(code).add(invokeAppendString);
                            continue;
                        }
                        iterator2.add(invokeAppendString);
                        continue;
                    }
                } else if (instruction.isInvokeStatic()) {
                    this.rewriteInvokeStatic(instruction.asInvokeStatic(), code, context, convertedEnums, iterator2, affectedPhis, methodProcessor);
                }
                if (instruction.isStaticGet()) {
                    StaticGet staticGet = instruction.asStaticGet();
                    DexField field = staticGet.getField();
                    DexType holder = field.holder;
                    if (!this.unboxedEnumsData.isUnboxedEnum(holder)) continue;
                    if (staticGet.hasUnusedOutValue()) {
                        iterator2.removeOrReplaceByDebugLocalRead();
                        continue;
                    }
                    affectedPhis.addAll(staticGet.outValue().uniquePhiUsers());
                    if (this.unboxedEnumsData.matchesValuesField(field)) {
                        iterator2.previous();
                        Value sizeValue = iterator2.insertConstIntInstruction(code, this.options, this.unboxedEnumsData.getValuesSize(holder));
                        iterator2.next();
                        InvokeStatic invoke = ((InvokeStatic.Builder)((InvokeStatic.Builder)((InvokeStatic.Builder)InvokeStatic.builder().setMethod(this.getSharedUtilityClass().getValuesMethod())).setFreshOutValue(this.appView, code)).setSingleArgument(sizeValue)).build();
                        iterator2.replaceCurrentInstruction(invoke);
                        convertedEnums.put(invoke, holder);
                        this.removeRedundantValuesArrayCloning(invoke, instructionsToRemove, seenBlocks);
                    } else if (this.unboxedEnumsData.hasUnboxedValueFor(field)) {
                        ConstNumber intConstant = code.createIntConstant(this.unboxedEnumsData.getUnboxedValue(field));
                        iterator2.replaceCurrentInstruction(intConstant);
                        convertedEnums.put(intConstant, holder);
                    }
                }
                if (instruction.isInstanceGet()) {
                    InstanceGet instanceGet = instruction.asInstanceGet();
                    DexType holder = instanceGet.getField().holder;
                    if (this.unboxedEnumsData.isUnboxedEnum(holder)) {
                        ProgramMethod fieldMethod = this.ensureInstanceFieldMethod(instanceGet.getField(), methodProcessor);
                        Value rewrittenOutValue = code.createValue(TypeElement.fromDexType(fieldMethod.getReturnType(), Nullability.maybeNull(), this.appView));
                        InvokeStatic invoke = new InvokeStatic((DexMethod)fieldMethod.getReference(), rewrittenOutValue, ImmutableList.of(instanceGet.object()));
                        iterator2.replaceCurrentInstruction(invoke);
                        if (this.unboxedEnumsData.isUnboxedEnum(instanceGet.getField().type)) {
                            convertedEnums.put(invoke, instanceGet.getField().type);
                        }
                    }
                }
                if (instruction.isArrayAccess()) {
                    ArrayAccess arrayAccess = instruction.asArrayAccess();
                    DexType enumType = this.getEnumTypeOrNull(arrayAccess, convertedEnums);
                    if (enumType != null) {
                        if (arrayAccess.hasOutValue()) {
                            affectedPhis.addAll(arrayAccess.outValue().uniquePhiUsers());
                        }
                        arrayAccess = arrayAccess.withMemberType(MemberType.INT);
                        iterator2.replaceCurrentInstruction(arrayAccess);
                        convertedEnums.put(arrayAccess, enumType);
                    }
                    assert (this.validateArrayAccess(arrayAccess));
                }
                if (!instruction.isNewUnboxedEnumInstance()) continue;
                NewUnboxedEnumInstance newUnboxedEnumInstance = instruction.asNewUnboxedEnumInstance();
                assert (this.unboxedEnumsData.isUnboxedEnum(newUnboxedEnumInstance.getType()));
                iterator2.replaceCurrentInstruction(code.createIntConstant(EnumUnboxerImpl.ordinalToUnboxedInt(newUnboxedEnumInstance.getOrdinal())));
            }
        }
        assert (code.isConsistentSSABeforeTypesAreCorrect(this.appView));
        return affectedPhis;
    }

    public void rewriteNullCheck(InstructionListIterator iterator2, InvokeMethod invoke) {
        assert (!invoke.hasOutValue() || !invoke.outValue().hasAnyUsers());
        this.replaceEnumInvoke(iterator2, invoke, this.getSharedUtilityClass().ensureCheckNotZeroMethod(this.appView));
    }
}

