/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.OneTimeMethodProcessor;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingUtilityClass;
import com.android.tools.r8.ir.optimize.enums.LocalEnumUnboxingUtilityClass;
import com.android.tools.r8.ir.optimize.enums.SharedEnumUnboxingUtilityClass;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.FieldAccessInfoCollectionModifier;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class EnumUnboxingUtilityClasses {
    private final ImmutableMap<DexType, LocalEnumUnboxingUtilityClass> localUtilityClasses;
    private final SharedEnumUnboxingUtilityClass sharedUtilityClass;

    private EnumUnboxingUtilityClasses(SharedEnumUnboxingUtilityClass sharedUtilityClass, ImmutableMap<DexType, LocalEnumUnboxingUtilityClass> localUtilityClasses) {
        this.sharedUtilityClass = sharedUtilityClass;
        this.localUtilityClasses = localUtilityClasses;
    }

    public static Builder builder(AppView<AppInfoWithLiveness> appView) {
        return new Builder(appView);
    }

    public void forEach(Consumer<? super EnumUnboxingUtilityClass> consumer) {
        this.localUtilityClasses.values().forEach(consumer);
        consumer.accept(this.getSharedUtilityClass());
    }

    public LocalEnumUnboxingUtilityClass getLocalUtilityClass(DexProgramClass enumClass) {
        return this.getLocalUtilityClass(enumClass.getType());
    }

    public LocalEnumUnboxingUtilityClass getLocalUtilityClass(DexType enumType) {
        LocalEnumUnboxingUtilityClass localEnumUnboxingUtilityClass = this.localUtilityClasses.get(enumType);
        assert (localEnumUnboxingUtilityClass != null);
        return localEnumUnboxingUtilityClass;
    }

    public SharedEnumUnboxingUtilityClass getSharedUtilityClass() {
        return this.sharedUtilityClass;
    }

    public static class Builder {
        private final AppView<AppInfoWithLiveness> appView;
        private ImmutableMap<DexType, LocalEnumUnboxingUtilityClass> localUtilityClasses;
        private SharedEnumUnboxingUtilityClass sharedUtilityClass;
        private final FieldAccessInfoCollectionModifier.Builder fieldAccessInfoCollectionModifierBuilder = FieldAccessInfoCollectionModifier.builder();

        public Builder(AppView<AppInfoWithLiveness> appView) {
            this.appView = appView;
        }

        private ImmutableMap<DexType, LocalEnumUnboxingUtilityClass> createLocalUtilityClasses(Set<DexProgramClass> enumsToUnbox, EnumDataMap dataMap) {
            ImmutableMap.Builder<DexType, LocalEnumUnboxingUtilityClass> localUtilityClasses = ImmutableMap.builder();
            for (DexProgramClass enumToUnbox : enumsToUnbox) {
                EnumDataMap.EnumData data2 = dataMap.get(enumToUnbox);
                localUtilityClasses.put(enumToUnbox.getType(), LocalEnumUnboxingUtilityClass.builder(this.appView, enumToUnbox, data2).build());
            }
            return localUtilityClasses.build();
        }

        static DexType getUtilityClassType(DexProgramClass context, String suffix, DexItemFactory dexItemFactory) {
            return dexItemFactory.createType(DescriptorUtils.getDescriptorFromClassBinaryName(DescriptorUtils.getBinaryNameFromDescriptor(context.getType().toDescriptorString()) + suffix));
        }

        public Builder synthesizeEnumUnboxingUtilityClasses(Set<DexProgramClass> enumsToUnbox, EnumDataMap enumDataMap) {
            SharedEnumUnboxingUtilityClass sharedUtilityClass = SharedEnumUnboxingUtilityClass.builder(this.appView, enumDataMap, enumsToUnbox, this.fieldAccessInfoCollectionModifierBuilder).build();
            ImmutableMap<DexType, LocalEnumUnboxingUtilityClass> localUtilityClasses = this.createLocalUtilityClasses(enumsToUnbox, enumDataMap);
            this.localUtilityClasses = localUtilityClasses;
            this.sharedUtilityClass = sharedUtilityClass;
            return this;
        }

        public EnumUnboxingUtilityClasses build(IRConverter converter, ExecutorService executorService) throws ExecutionException {
            EnumUnboxingUtilityClasses utilityClasses = new EnumUnboxingUtilityClasses(this.sharedUtilityClass, this.localUtilityClasses);
            this.fieldAccessInfoCollectionModifierBuilder.build().modify(this.appView);
            OneTimeMethodProcessor.Builder methodProcessorBuilder = OneTimeMethodProcessor.builder(this.appView.createProcessorContext());
            utilityClasses.forEach(utilityClass -> {
                utilityClass.ensureMethods(this.appView);
                utilityClass.getDefinition().forEachProgramMethod(methodProcessorBuilder::add);
            });
            OneTimeMethodProcessor methodProcessor = methodProcessorBuilder.build();
            methodProcessor.forEachWaveWithExtension((method, methodProcessingContext) -> converter.processDesugaredMethod(method, OptimizationFeedbackSimple.getInstance(), methodProcessor, methodProcessingContext), executorService);
            return utilityClasses;
        }
    }
}

