/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleNumberValue;
import com.android.tools.r8.ir.analysis.value.SingleStringValue;
import com.android.tools.r8.ir.code.ArrayGet;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.IRMetadata;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.IntSwitch;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ArrayUtils;
import java.util.Arrays;
import java.util.Set;

public class EnumValueOptimizer {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory factory;

    public EnumValueOptimizer(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
    }

    private Int2IntArrayMap computeOrdinalToTargetMap(IRCode code, IntSwitch switchInsn, EnumSwitchInfo info) {
        Int2IntArrayMap ordinalToTargetMap = new Int2IntArrayMap(switchInsn.numberOfKeys());
        for (int i = 0; i < switchInsn.numberOfKeys(); ++i) {
            assert (switchInsn.targetBlockIndices()[i] != switchInsn.getFallthroughBlockIndex());
            DexField field = (DexField)info.indexMap.get(switchInsn.getKey(i));
            DexEncodedField enumInstanceField = this.appView.appInfo().resolveField(field, code.context()).getResolvedField();
            if (enumInstanceField == null) continue;
            AbstractValue abstractValue = enumInstanceField.getOptimizationInfo().getAbstractValue();
            SingleNumberValue ordinalValue = this.getOrdinalValue(code, abstractValue, true);
            if (ordinalValue == null && this.appView.options().protoShrinking().enableRemoveProtoEnumSwitchMap()) {
                ordinalValue = this.appView.protoShrinker().protoEnumSwitchMapRemover.getOrdinal(this.appView.programDefinitionFor(info.enumClass, code.context()), enumInstanceField, this.appView.appInfo().resolveField(this.factory.enumMembers.ordinalField, code.context()).getResolvedField());
            }
            if (ordinalValue == null) {
                return null;
            }
            ordinalToTargetMap.put(ordinalValue.asSingleNumberValue().getIntValue(), switchInsn.targetBlockIndices()[i]);
        }
        return ordinalToTargetMap;
    }

    private SingleStringValue getNameValue(IRCode code, AbstractValue abstractValue, boolean neverNull) {
        AbstractValue ordinalValue = this.getEnumFieldValue(code, abstractValue, this.factory.enumMembers.nameField, neverNull);
        return ordinalValue == null ? null : ordinalValue.asSingleStringValue();
    }

    private SingleNumberValue getOrdinalValue(IRCode code, AbstractValue abstractValue, boolean neverNull) {
        AbstractValue ordinalValue = this.getEnumFieldValue(code, abstractValue, this.factory.enumMembers.ordinalField, neverNull);
        return ordinalValue == null ? null : ordinalValue.asSingleNumberValue();
    }

    private AbstractValue getEnumFieldValue(IRCode code, AbstractValue abstractValue, DexField field, boolean neverNull) {
        if (neverNull && abstractValue.isNullOrAbstractValue()) {
            abstractValue = abstractValue.asNullOrAbstractValue().getNonNullValue();
        }
        if (!abstractValue.isSingleFieldValue()) {
            return null;
        }
        DexEncodedField encodedField = this.appView.appInfo().resolveField(field, code.context()).getResolvedField();
        if (encodedField == null) {
            return null;
        }
        return abstractValue.asSingleFieldValue().getObjectState().getAbstractFieldValue(encodedField);
    }

    private EnumSwitchInfo analyzeSwitchOverEnum(IntSwitch switchInsn) {
        Instruction input = switchInsn.inValues().get((int)0).definition;
        if (input == null || !input.isArrayGet()) {
            return null;
        }
        ArrayGet arrayGet = input.asArrayGet();
        Instruction index = arrayGet.index().definition;
        if (index == null || !index.isInvokeVirtual()) {
            return null;
        }
        InvokeVirtual ordinalInvoke = index.asInvokeVirtual();
        DexMethod ordinalMethod = ordinalInvoke.getInvokedMethod();
        DexClass enumClass = this.appView.definitionFor(ordinalMethod.holder);
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        if (enumClass == null || !enumClass.accessFlags.isEnum() && enumClass.type != dexItemFactory.enumType || ordinalMethod.name != dexItemFactory.ordinalMethodName || ordinalMethod.proto.returnType != dexItemFactory.intType || !ordinalMethod.proto.parameters.isEmpty()) {
            return null;
        }
        Instruction array = arrayGet.array().definition;
        if (array == null || !array.isStaticGet()) {
            return null;
        }
        StaticGet staticGet = array.asStaticGet();
        Int2ReferenceMap<DexField> indexMap = this.appView.appInfo().getSwitchMap(staticGet.getField());
        if (indexMap == null || indexMap.isEmpty()) {
            return null;
        }
        for (int key : switchInsn.getKeys()) {
            if (indexMap.containsKey(key)) continue;
            return null;
        }
        DexType enumType = ((DexField)indexMap.values().iterator().next()).holder;
        return new EnumSwitchInfo(enumType, ordinalInvoke, arrayGet, staticGet, indexMap);
    }

    public void rewriteConstantEnumMethodCalls(IRCode code) {
        IRMetadata metadata = code.metadata();
        if (!(metadata.mayHaveInvokeMethodWithReceiver() || metadata.mayHaveInvokeStatic() && metadata.mayHaveArrayLength())) {
            return;
        }
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        InstructionListIterator iterator2 = code.instructionListIterator();
        while (iterator2.hasNext()) {
            DexField field;
            DexEncodedField definition;
            StaticGet staticGet;
            InvokeMethodWithReceiver methodWithReceiver;
            Value receiver;
            Instruction current = (Instruction)iterator2.next();
            if (!current.isInvokeMethodWithReceiver() || !(receiver = (methodWithReceiver = current.asInvokeMethodWithReceiver()).getReceiver().getAliasedValue()).getType().isClassType() || !this.appView.appInfo().isSubtype(receiver.getType().asClassType().getClassType(), this.factory.enumType)) continue;
            DexMethod invokedMethod = methodWithReceiver.getInvokedMethod();
            boolean isOrdinalInvoke = invokedMethod.match(this.factory.enumMembers.ordinalMethod);
            boolean isNameInvoke = invokedMethod.match(this.factory.enumMembers.nameMethod);
            boolean isToStringInvoke = invokedMethod.match(this.factory.enumMembers.toString);
            if (!isOrdinalInvoke && !isNameInvoke && !isToStringInvoke || receiver.isPhi() || (staticGet = receiver.getDefinition().asStaticGet()) == null || (definition = (field = staticGet.getField()).lookupOnClass(this.appView.definitionForHolder(field))) == null) continue;
            FieldOptimizationInfo optimizationInfo = definition.getOptimizationInfo();
            AbstractValue abstractValue = optimizationInfo.getAbstractValue();
            if (methodWithReceiver.hasUnusedOutValue()) {
                if (!methodWithReceiver.getReceiver().getType().isDefinitelyNotNull() || isToStringInvoke) continue;
                assert (isNameInvoke || isOrdinalInvoke);
                iterator2.removeOrReplaceByDebugLocalRead();
                continue;
            }
            Value outValue = methodWithReceiver.outValue();
            if (isOrdinalInvoke) {
                SingleNumberValue ordinalValue = this.getOrdinalValue(code, abstractValue, methodWithReceiver.getReceiver().isNeverNull());
                if (ordinalValue == null) continue;
                iterator2.replaceCurrentInstruction(new ConstNumber(outValue, ordinalValue.getValue()));
                continue;
            }
            SingleStringValue nameValue = this.getNameValue(code, abstractValue, methodWithReceiver.getReceiver().isNeverNull());
            if (nameValue == null) continue;
            if (isNameInvoke) {
                Value newValue = code.createValue(TypeElement.stringClassType(this.appView, Nullability.definitelyNotNull()));
                iterator2.replaceCurrentInstruction(new ConstString(newValue, nameValue.getDexString()));
                newValue.addAffectedValuesTo(affectedValues);
                continue;
            }
            assert (isToStringInvoke);
            DexClass enumClazz = this.appView.appInfo().definitionFor(field.type);
            if (!enumClazz.isFinal()) continue;
            assert (abstractValue.isSingleFieldValue());
            ClassTypeElement enumFieldType = optimizationInfo.getDynamicType().getExactClassType();
            if (enumFieldType == null) {
                assert (false) : "Expected to have an exact dynamic type for enum instance";
                continue;
            }
            DexEncodedMethod singleTarget = this.appView.appInfo().resolveMethodOnClass(this.factory.objectMembers.toString, enumFieldType.getClassType()).getSingleTarget();
            if (singleTarget != null && singleTarget.getReference() != this.factory.enumMembers.toString) continue;
            Value newValue = code.createValue(TypeElement.stringClassType(this.appView, Nullability.definitelyNotNull()));
            iterator2.replaceCurrentInstruction(new ConstString(newValue, nameValue.getDexString()));
            newValue.addAffectedValuesTo(affectedValues);
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA(this.appView));
    }

    public void removeSwitchMaps(IRCode code) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        boolean mayHaveIntroducedUnreachableBlocks = false;
        for (BasicBlock block : code.blocks) {
            Instruction staticGet;
            Int2IntArrayMap ordinalToTargetMap;
            EnumSwitchInfo info;
            IntSwitch switchInsn = block.exit().asIntSwitch();
            if (switchInsn == null || (info = this.analyzeSwitchOverEnum(switchInsn)) == null || (ordinalToTargetMap = this.computeOrdinalToTargetMap(code, switchInsn, info)) == null) continue;
            int fallthroughBlockIndex = switchInsn.getFallthroughBlockIndex();
            if (ordinalToTargetMap.size() < switchInsn.numberOfKeys()) {
                int numberOfNormalSuccessors = switchInsn.numberOfKeys() + 1;
                int numberOfExceptionalSuccessors = block.numberOfExceptionalSuccessors();
                IntOpenHashSet ordinalToTargetValues = new IntOpenHashSet(ordinalToTargetMap.values());
                int[] deadBlockIndices = ArrayUtils.fromPredicate(index -> {
                    int adjustedIndex = index + numberOfExceptionalSuccessors;
                    return !ordinalToTargetValues.contains(adjustedIndex) && adjustedIndex != switchInsn.getFallthroughBlockIndex();
                }, numberOfNormalSuccessors);
                IntArrayList successorIndicesToRemove = new IntArrayList(numberOfNormalSuccessors);
                for (int i = 0; i < numberOfNormalSuccessors; ++i) {
                    if (deadBlockIndices[i] != 1) continue;
                    BasicBlock successor = block.getSuccessors().get(i + numberOfExceptionalSuccessors);
                    successor.removePredecessor(block, affectedValues);
                    successorIndicesToRemove.add(i);
                }
                block.removeSuccessorsByIndex(successorIndicesToRemove);
                mayHaveIntroducedUnreachableBlocks = true;
                ArrayUtils.sumOfPredecessorsInclusive(deadBlockIndices);
                for (Int2IntMap.Entry entry : ordinalToTargetMap.int2IntEntrySet()) {
                    ordinalToTargetMap.put(entry.getIntKey(), entry.getIntValue() - deadBlockIndices[entry.getIntValue()]);
                }
                fallthroughBlockIndex -= deadBlockIndices[fallthroughBlockIndex];
            }
            int[] keys2 = ordinalToTargetMap.keySet().toIntArray();
            Arrays.sort(keys2);
            int[] targets = new int[keys2.length];
            for (int i = 0; i < keys2.length; ++i) {
                targets[i] = ordinalToTargetMap.get(keys2[i]);
            }
            IntSwitch newSwitch = new IntSwitch(info.ordinalInvoke.outValue(), keys2, targets, fallthroughBlockIndex);
            switchInsn.replace(newSwitch, code);
            Instruction arrayGet = info.arrayGet;
            if (!arrayGet.outValue().hasUsers()) {
                arrayGet.inValues().forEach(v -> v.removeUser(arrayGet));
                arrayGet.getBlock().removeInstruction(arrayGet);
            }
            if ((staticGet = info.staticGet).outValue().hasUsers()) continue;
            assert (staticGet.inValues().isEmpty());
            staticGet.getBlock().removeInstruction(staticGet);
        }
        if (mayHaveIntroducedUnreachableBlocks) {
            affectedValues.addAll(code.removeUnreachableBlocks());
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }

    private static final class EnumSwitchInfo {
        final DexType enumClass;
        final Instruction ordinalInvoke;
        final Instruction arrayGet;
        public final Instruction staticGet;
        final Int2ReferenceMap<DexField> indexMap;

        private EnumSwitchInfo(DexType enumClass, Instruction ordinalInvoke, Instruction arrayGet, Instruction staticGet, Int2ReferenceMap<DexField> indexMap) {
            this.enumClass = enumClass;
            this.ordinalInvoke = ordinalInvoke;
            this.arrayGet = arrayGet;
            this.staticGet = staticGet;
            this.indexMap = indexMap;
        }
    }
}

