/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.cf.code.CfArrayStore;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfNewArray;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStaticFieldRead;
import com.android.tools.r8.cf.code.CfStaticFieldWrite;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingCfMethods;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingUtilityClass;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.FieldAccessInfoCollectionModifier;
import com.android.tools.r8.synthesis.SyntheticMethodBuilder;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.utils.ConsumerUtils;
import java.util.ArrayList;
import java.util.Set;

public class SharedEnumUnboxingUtilityClass
extends EnumUnboxingUtilityClass {
    private final DexProgramClass sharedUtilityClass;
    private final ProgramMethod valuesMethod;

    public SharedEnumUnboxingUtilityClass(DexProgramClass sharedUtilityClass, DexProgramClass synthesizingContext, ProgramMethod valuesMethod) {
        super(synthesizingContext);
        this.sharedUtilityClass = sharedUtilityClass;
        this.valuesMethod = valuesMethod;
    }

    public static Builder builder(AppView<AppInfoWithLiveness> appView, EnumDataMap enumDataMap, Set<DexProgramClass> enumsToUnbox, FieldAccessInfoCollectionModifier.Builder fieldAccessInfoCollectionModifierBuilder) {
        return new Builder(appView, enumDataMap, enumsToUnbox, fieldAccessInfoCollectionModifierBuilder);
    }

    private ProgramMethod internalEnsureMethod(AppView<AppInfoWithLiveness> appView, DexString methodName, DexProto methodProto, SyntheticMethodBuilder.SyntheticCodeGenerator codeGenerator) {
        return appView.getSyntheticItems().ensureFixedClassMethod(methodName, methodProto, kinds -> kinds.ENUM_UNBOXING_SHARED_UTILITY_CLASS, this.getSynthesizingContext(), appView, ConsumerUtils.emptyConsumer(), methodBuilder -> methodBuilder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setApiLevelForDefinition(appView.computedMinApiLevel()).setApiLevelForCode(appView.computedMinApiLevel()).setCode(codeGenerator).setClassFileVersion(CfVersion.V1_6));
    }

    @Override
    public void ensureMethods(AppView<AppInfoWithLiveness> appView) {
        this.ensureCheckNotZeroMethod(appView);
        this.ensureCheckNotZeroWithMessageMethod(appView);
        this.ensureCompareToMethod(appView);
        this.ensureEqualsMethod(appView);
        this.ensureOrdinalMethod(appView);
    }

    public ProgramMethod ensureCheckNotZeroMethod(AppView<AppInfoWithLiveness> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return this.internalEnsureMethod(appView, dexItemFactory.createString("checkNotZero"), dexItemFactory.createProto(dexItemFactory.voidType, dexItemFactory.intType), method -> EnumUnboxingCfMethods.EnumUnboxingMethods_zeroCheck(appView.options(), method));
    }

    public ProgramMethod ensureCheckNotZeroWithMessageMethod(AppView<AppInfoWithLiveness> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return this.internalEnsureMethod(appView, dexItemFactory.createString("checkNotZero"), dexItemFactory.createProto(dexItemFactory.voidType, dexItemFactory.intType, dexItemFactory.stringType), method -> EnumUnboxingCfMethods.EnumUnboxingMethods_zeroCheckMessage(appView.options(), method));
    }

    public ProgramMethod ensureCompareToMethod(AppView<AppInfoWithLiveness> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return this.internalEnsureMethod(appView, dexItemFactory.enumMembers.compareTo.getName(), dexItemFactory.createProto(dexItemFactory.intType, dexItemFactory.intType, dexItemFactory.intType), method -> EnumUnboxingCfMethods.EnumUnboxingMethods_compareTo(appView.options(), method));
    }

    public ProgramMethod ensureEqualsMethod(AppView<AppInfoWithLiveness> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return this.internalEnsureMethod(appView, dexItemFactory.enumMembers.equals.getName(), dexItemFactory.createProto(dexItemFactory.booleanType, dexItemFactory.intType, dexItemFactory.intType), method -> EnumUnboxingCfMethods.EnumUnboxingMethods_equals(appView.options(), method));
    }

    public ProgramMethod ensureOrdinalMethod(AppView<AppInfoWithLiveness> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return this.internalEnsureMethod(appView, dexItemFactory.enumMembers.ordinalMethod.getName(), dexItemFactory.createProto(dexItemFactory.intType, dexItemFactory.intType), method -> EnumUnboxingCfMethods.EnumUnboxingMethods_ordinal(appView.options(), method));
    }

    @Override
    public DexProgramClass getDefinition() {
        return this.sharedUtilityClass;
    }

    public ProgramMethod getValuesMethod() {
        return this.valuesMethod;
    }

    public DexType getType() {
        return this.sharedUtilityClass.getType();
    }

    public static class Builder {
        private final AppView<AppInfoWithLiveness> appView;
        private final DexItemFactory dexItemFactory;
        private final EnumDataMap enumDataMap;
        private final FieldAccessInfoCollectionModifier.Builder fieldAccessInfoCollectionModifierBuilder;
        private final DexProgramClass synthesizingContext;
        private DexEncodedMethod valuesMethod;

        private Builder(AppView<AppInfoWithLiveness> appView, EnumDataMap enumDataMap, Set<DexProgramClass> enumsToUnbox, FieldAccessInfoCollectionModifier.Builder fieldAccessInfoCollectionModifierBuilder) {
            DexProgramClass synthesizingContext = Builder.findDeterministicContextType(enumsToUnbox);
            this.appView = appView;
            this.dexItemFactory = appView.dexItemFactory();
            this.enumDataMap = enumDataMap;
            this.fieldAccessInfoCollectionModifierBuilder = fieldAccessInfoCollectionModifierBuilder;
            this.synthesizingContext = synthesizingContext;
        }

        private DexProgramClass createClass() {
            DexProgramClass clazz = this.appView.getSyntheticItems().createFixedClass(kinds -> kinds.ENUM_UNBOXING_SHARED_UTILITY_CLASS, this.synthesizingContext, this.appView, classBuilder -> {
                DexType sharedUtilityClassType = classBuilder.getType();
                DexEncodedField valuesField = this.createValuesField(sharedUtilityClassType);
                ((SyntheticProgramClassBuilder)((SyntheticProgramClassBuilder)classBuilder.setDirectMethods(ImmutableList.of(this.createClassInitializer(sharedUtilityClassType, valuesField), this.createValuesMethod(sharedUtilityClassType, valuesField)))).setStaticFields(ImmutableList.of(valuesField))).setUseSortedMethodBacking(true);
            });
            assert (clazz.getAccessFlags().equals(ClassAccessFlags.createPublicFinalSynthetic()));
            return clazz;
        }

        private DexEncodedField createValuesField(DexType sharedUtilityClassType) {
            DexEncodedField valuesField = DexEncodedField.syntheticBuilder().setField(this.dexItemFactory.createField(sharedUtilityClassType, this.dexItemFactory.intArrayType, "$VALUES")).setAccessFlags(FieldAccessFlags.createPublicStaticFinalSynthetic()).setApiLevel(this.appView.computedMinApiLevel()).build();
            this.fieldAccessInfoCollectionModifierBuilder.recordFieldReadInUnknownContext((DexField)valuesField.getReference()).recordFieldWriteInUnknownContext((DexField)valuesField.getReference());
            return valuesField;
        }

        private DexEncodedMethod createClassInitializer(DexType sharedUtilityClassType, DexEncodedField valuesField) {
            return DexEncodedMethod.syntheticBuilder().setMethod(this.dexItemFactory.createClassInitializer(sharedUtilityClassType)).setAccessFlags(MethodAccessFlags.createForClassInitializer()).setCode(this.createClassInitializerCode(sharedUtilityClassType, valuesField)).setClassFileVersion(CfVersion.V1_6).setApiLevelForDefinition(this.appView.computedMinApiLevel()).setApiLevelForCode(this.appView.computedMinApiLevel()).build();
        }

        private CfCode createClassInitializerCode(DexType sharedUtilityClassType, DexEncodedField valuesField) {
            int maxValuesArraySize = this.enumDataMap.getMaxValuesSize();
            int numberOfInstructions = 4 + maxValuesArraySize * 4;
            ArrayList<CfInstruction> instructions = new ArrayList<CfInstruction>(numberOfInstructions);
            instructions.add(new CfConstNumber(maxValuesArraySize, ValueType.INT));
            instructions.add(new CfNewArray(this.dexItemFactory.intArrayType));
            for (int i = 0; i < maxValuesArraySize; ++i) {
                instructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Dup));
                instructions.add(new CfConstNumber(i, ValueType.INT));
                instructions.add(new CfConstNumber(i + 1, ValueType.INT));
                instructions.add(new CfArrayStore(MemberType.INT));
            }
            instructions.add(new CfStaticFieldWrite((DexField)valuesField.getReference()));
            instructions.add(new CfReturnVoid());
            int maxStack = 4;
            int maxLocals = 0;
            return new CfCode(sharedUtilityClassType, maxStack, maxLocals, instructions);
        }

        private DexEncodedMethod createValuesMethod(DexType sharedUtilityClassType, DexEncodedField valuesField) {
            DexEncodedMethod valuesMethod;
            this.valuesMethod = valuesMethod = DexEncodedMethod.syntheticBuilder().setMethod(this.dexItemFactory.createMethod(sharedUtilityClassType, this.dexItemFactory.createProto(this.dexItemFactory.intArrayType, this.dexItemFactory.intType), "values")).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(this.createValuesMethodCode(sharedUtilityClassType, valuesField)).setClassFileVersion(CfVersion.V1_6).setApiLevelForDefinition(this.appView.computedMinApiLevel()).setApiLevelForCode(this.appView.computedMinApiLevel()).build();
            return valuesMethod;
        }

        private CfCode createValuesMethodCode(DexType sharedUtilityClassType, DexEncodedField valuesField) {
            int maxStack = 5;
            int maxLocals = 2;
            int argumentLocalSlot = 0;
            int resultLocalSlot = 1;
            return new CfCode(sharedUtilityClassType, maxStack, maxLocals, ImmutableList.of(new CfLoad(ValueType.INT, argumentLocalSlot), new CfNewArray(this.dexItemFactory.intArrayType), new CfStore(ValueType.OBJECT, resultLocalSlot), new CfStaticFieldRead((DexField)valuesField.getReference()), new CfConstNumber(0L, ValueType.INT), new CfLoad(ValueType.OBJECT, resultLocalSlot), new CfConstNumber(0L, ValueType.INT), new CfLoad(ValueType.INT, argumentLocalSlot), new CfInvoke(184, this.dexItemFactory.javaLangSystemMethods.arraycopy, false), new CfLoad(ValueType.OBJECT, resultLocalSlot), new CfReturn(ValueType.OBJECT)));
        }

        private static DexProgramClass findDeterministicContextType(Set<DexProgramClass> contexts) {
            DexProgramClass deterministicContext = null;
            for (DexProgramClass context : contexts) {
                if (deterministicContext == null) {
                    deterministicContext = context;
                    continue;
                }
                if (context.type.compareTo(deterministicContext.type) >= 0) continue;
                deterministicContext = context;
            }
            return deterministicContext;
        }

        SharedEnumUnboxingUtilityClass build() {
            DexProgramClass clazz = this.createClass();
            SharedEnumUnboxingUtilityClass sharedUtilityClass = new SharedEnumUnboxingUtilityClass(clazz, this.synthesizingContext, new ProgramMethod(clazz, this.valuesMethod));
            return sharedUtilityClass;
        }
    }
}

