/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums.classification;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.enums.classification.CheckNotNullEnumUnboxerMethodClassification;
import com.android.tools.r8.ir.optimize.enums.classification.EnumUnboxerMethodClassification;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

public class EnumUnboxerMethodClassificationAnalysis {
    public static EnumUnboxerMethodClassification analyze(AppView<AppInfoWithLiveness> appView, ProgramMethod method, IRCode code, MethodProcessor methodProcessor) {
        if (!appView.options().enableEnumUnboxing) {
            return EnumUnboxerMethodClassification.unknown();
        }
        if (!method.getAccessFlags().isStatic() || method.getParameters().isEmpty()) {
            return EnumUnboxerMethodClassification.unknown();
        }
        EnumUnboxerMethodClassification currentClassification = method.getOptimizationInfo().getEnumUnboxerMethodClassification();
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        InstructionIterator entryIterator = code.entryBlock().iterator();
        for (int index = 0; index < method.getParameters().size(); ++index) {
            Argument argument = ((Instruction)entryIterator.next()).asArgument();
            DexType parameter = method.getParameter(index);
            if (!appView.hasUnboxedEnums() ? parameter != dexItemFactory.objectType : parameter != dexItemFactory.intType || !currentClassification.isCheckNotNullClassification() || currentClassification.asCheckNotNullClassification().getArgumentIndex() != index) continue;
            if (!EnumUnboxerMethodClassificationAnalysis.onlyHasCheckNotNullUsers(argument, methodProcessor)) continue;
            return new CheckNotNullEnumUnboxerMethodClassification(index);
        }
        return EnumUnboxerMethodClassification.unknown();
    }

    private static boolean onlyHasCheckNotNullUsers(Argument argument, MethodProcessor methodProcessor) {
        Value value = argument.outValue();
        if (value.hasDebugUsers() || value.hasPhiUsers()) {
            return false;
        }
        Set<Instruction> users = value.aliasedUsers();
        boolean seenIf = false;
        block5: for (Instruction user : users) {
            switch (user.opcode()) {
                case 9: {
                    if (!user.outValue().hasDebugUsers() && !user.outValue().hasPhiUsers()) continue block5;
                    return false;
                }
                case 25: {
                    If ifUser = user.asIf();
                    if (!ifUser.isZeroTest() || ifUser.getType() != If.Type.EQ && ifUser.getType() != If.Type.NE) {
                        return false;
                    }
                    seenIf = true;
                    continue block5;
                }
                case 56: {
                    continue block5;
                }
            }
            return false;
        }
        return !methodProcessor.isPrimaryMethodProcessor() || seenIf;
    }
}

