/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.info;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.ir.analysis.inlining.NeverSimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.optimize.classinliner.constraint.ClassInlinerMethodConstraint;
import com.android.tools.r8.ir.optimize.enums.classification.EnumUnboxerMethodClassification;
import com.android.tools.r8.ir.optimize.info.CallSiteOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.DefaultMethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfoFixer;
import com.android.tools.r8.ir.optimize.info.MutableOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.bridge.BridgeInfo;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfoCollection;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.BitSetUtils;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.OptionalBool;
import java.util.BitSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class MutableMethodOptimizationInfo
extends MethodOptimizationInfo
implements MutableOptimizationInfo {
    private static final int CANNOT_BE_KEPT_FLAG = 1;
    private static final int CLASS_INITIALIZER_MAY_BE_POSTPONED_FLAG = 2;
    private static final int HAS_BEEN_INLINED_INTO_SINGLE_CALL_SITE_FLAG = 4;
    private static final int MAY_HAVE_SIDE_EFFECT_FLAG = 8;
    private static final int RETURN_VALUE_ONLY_DEPENDS_ON_ARGUMENTS_FLAG = 16;
    private static final int NEVER_RETURNS_NORMALLY_FLAG = 32;
    private static final int INITIALIZER_ENABLING_JAVA_ASSERTIONS_FLAG = 128;
    private static final int RETURN_VALUE_HAS_BEEN_PROPAGATED_FLAG = 256;
    private static final int DEFAULT_FLAGS;
    private CallSiteOptimizationInfo argumentInfos = CallSiteOptimizationInfo.top();
    private Set<DexType> initializedClassesOnNormalExit = DefaultMethodOptimizationInfo.UNKNOWN_INITIALIZED_CLASSES_ON_NORMAL_EXIT;
    private int returnedArgument = DefaultMethodOptimizationInfo.UNKNOWN_RETURNED_ARGUMENT;
    private AbstractValue abstractReturnValue = DefaultMethodOptimizationInfo.UNKNOWN_ABSTRACT_RETURN_VALUE;
    private ClassInlinerMethodConstraint classInlinerConstraint = ClassInlinerMethodConstraint.alwaysFalse();
    private EnumUnboxerMethodClassification enumUnboxerMethodClassification = EnumUnboxerMethodClassification.unknown();
    private DynamicType dynamicType = DynamicType.unknown();
    private MethodOptimizationInfo.InlinePreference inlining = MethodOptimizationInfo.InlinePreference.Default;
    private OptionalBool isReturnValueUsed = OptionalBool.unknown();
    private BridgeInfo bridgeInfo = null;
    private InstanceInitializerInfoCollection instanceInitializerInfoCollection = InstanceInitializerInfoCollection.empty();
    private BitSet nonNullParamOrThrow = DefaultMethodOptimizationInfo.NO_NULL_PARAMETER_OR_THROW_FACTS;
    private BitSet nonNullParamOnNormalExits = DefaultMethodOptimizationInfo.NO_NULL_PARAMETER_ON_NORMAL_EXITS_FACTS;
    private SimpleInliningConstraint simpleInliningConstraint = NeverSimpleInliningConstraint.getInstance();
    private BitSet unusedArguments = null;
    private int flags = DEFAULT_FLAGS;

    MutableMethodOptimizationInfo() {
    }

    private MutableMethodOptimizationInfo(MutableMethodOptimizationInfo template) {
        this.argumentInfos = template.argumentInfos;
        this.flags = template.flags;
        this.initializedClassesOnNormalExit = template.initializedClassesOnNormalExit;
        this.returnedArgument = template.returnedArgument;
        this.abstractReturnValue = template.abstractReturnValue;
        this.dynamicType = template.dynamicType;
        this.inlining = template.inlining;
        this.simpleInliningConstraint = template.simpleInliningConstraint;
        this.bridgeInfo = template.bridgeInfo;
        this.instanceInitializerInfoCollection = template.instanceInitializerInfoCollection;
        this.nonNullParamOrThrow = template.nonNullParamOrThrow;
        this.nonNullParamOnNormalExits = template.nonNullParamOnNormalExits;
        this.classInlinerConstraint = template.classInlinerConstraint;
        this.enumUnboxerMethodClassification = template.enumUnboxerMethodClassification;
    }

    private void setFlag(int flag, boolean value) {
        if (value) {
            this.setFlag(flag);
        } else {
            this.clearFlag(flag);
        }
    }

    private void setFlag(int flag) {
        this.flags |= flag;
    }

    private void clearFlag(int flag) {
        this.flags &= ~flag;
    }

    private boolean isFlagSet(int flag) {
        return (this.flags & flag) != 0;
    }

    private boolean verifyDynamicType(AppView<?> appView, DynamicType newDynamicType, DexEncodedMethod method) {
        if (appView.enableWholeProgramOptimizations()) {
            TypeElement staticReturnType = method.getReturnType().toTypeElement(appView);
            TypeElement previousDynamicUpperBoundType = this.dynamicType.getDynamicUpperBoundType(staticReturnType);
            TypeElement newDynamicUpperBoundType = newDynamicType.getDynamicUpperBoundType(staticReturnType);
            assert (newDynamicUpperBoundType.lessThanOrEqualUpToNullability(previousDynamicUpperBoundType, appView)) : "upper bound type changed from " + previousDynamicUpperBoundType + " to " + newDynamicUpperBoundType;
        }
        return true;
    }

    static {
        int defaultFlags = 0;
        DefaultMethodOptimizationInfo defaultOptInfo = DefaultMethodOptimizationInfo.DEFAULT_INSTANCE;
        defaultFlags |= BooleanUtils.intValue(((MethodOptimizationInfo)defaultOptInfo).cannotBeKept()) * 1;
        defaultFlags |= BooleanUtils.intValue(((MethodOptimizationInfo)defaultOptInfo).classInitializerMayBePostponed()) * 2;
        defaultFlags |= BooleanUtils.intValue(((MethodOptimizationInfo)defaultOptInfo).hasBeenInlinedIntoSingleCallSite()) * 4;
        defaultFlags |= BooleanUtils.intValue(((MethodOptimizationInfo)defaultOptInfo).mayHaveSideEffects()) * 8;
        defaultFlags |= BooleanUtils.intValue(((MethodOptimizationInfo)defaultOptInfo).returnValueOnlyDependsOnArguments()) * 16;
        defaultFlags |= BooleanUtils.intValue(((MethodOptimizationInfo)defaultOptInfo).neverReturnsNormally()) * 32;
        defaultFlags |= BooleanUtils.intValue(((MethodOptimizationInfo)defaultOptInfo).isInitializerEnablingJavaVmAssertions()) * 128;
        DEFAULT_FLAGS = defaultFlags |= BooleanUtils.intValue(((MethodOptimizationInfo)defaultOptInfo).returnValueHasBeenPropagated()) * 256;
    }

    public MutableMethodOptimizationInfo fixup(AppView<AppInfoWithLiveness> appView, MethodOptimizationInfoFixer fixer) {
        return this.fixupArgumentInfos(fixer).fixupBridgeInfo(fixer).fixupClassInlinerMethodConstraint(appView, fixer).fixupEnumUnboxerMethodClassification(fixer).fixupInstanceInitializerInfo(appView, fixer).fixupNonNullParamOnNormalExits(fixer).fixupNonNullParamOrThrow(fixer).fixupReturnedArgumentIndex(fixer).fixupSimpleInliningConstraint(appView, fixer).fixupUnusedArguments(fixer);
    }

    public MutableMethodOptimizationInfo fixupClassTypeReferences(AppView<AppInfoWithLiveness> appView, GraphLens lens) {
        return this.fixupClassTypeReferences(appView, lens, Collections.emptySet());
    }

    public MutableMethodOptimizationInfo fixupClassTypeReferences(AppView<AppInfoWithLiveness> appView, GraphLens lens, Set<DexType> prunedTypes) {
        this.dynamicType = this.dynamicType.rewrittenWithLens(appView, lens, prunedTypes);
        return this;
    }

    public MutableMethodOptimizationInfo fixupAbstractReturnValue(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        this.abstractReturnValue = this.abstractReturnValue.rewrittenWithLens(appView, lens, codeLens);
        return this;
    }

    public MutableMethodOptimizationInfo fixupInstanceInitializerInfo(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens, PrunedItems prunedItems) {
        this.instanceInitializerInfoCollection = this.instanceInitializerInfoCollection.rewrittenWithLens(appView, lens, codeLens, prunedItems);
        return this;
    }

    @Override
    public boolean cannotBeKept() {
        return this.isFlagSet(1);
    }

    public void markCannotBeKept() {
        this.setFlag(1);
    }

    @Override
    public boolean classInitializerMayBePostponed() {
        return this.isFlagSet(2);
    }

    void markClassInitializerMayBePostponed() {
        this.setFlag(2);
    }

    void unsetClassInitializerMayBePostponed() {
        this.clearFlag(2);
    }

    @Override
    public CallSiteOptimizationInfo getArgumentInfos() {
        return this.argumentInfos;
    }

    public MutableMethodOptimizationInfo fixupArgumentInfos(MethodOptimizationInfoFixer fixer) {
        if (this.argumentInfos.isConcreteCallSiteOptimizationInfo()) {
            this.argumentInfos = fixer.fixupCallSiteOptimizationInfo(this.argumentInfos.asConcreteCallSiteOptimizationInfo());
        }
        return this;
    }

    void setArgumentInfos(CallSiteOptimizationInfo argumentInfos) {
        this.argumentInfos = argumentInfos;
    }

    @Override
    public ClassInlinerMethodConstraint getClassInlinerMethodConstraint() {
        return this.classInlinerConstraint;
    }

    public MutableMethodOptimizationInfo fixupClassInlinerMethodConstraint(AppView<AppInfoWithLiveness> appView, MethodOptimizationInfoFixer fixer) {
        this.classInlinerConstraint = fixer.fixupClassInlinerMethodConstraint(appView, this.classInlinerConstraint);
        return this;
    }

    void setClassInlinerMethodConstraint(ClassInlinerMethodConstraint classInlinerConstraint) {
        this.classInlinerConstraint = classInlinerConstraint;
    }

    void unsetClassInlinerMethodConstraint() {
        this.classInlinerConstraint = ClassInlinerMethodConstraint.alwaysFalse();
    }

    @Override
    public EnumUnboxerMethodClassification getEnumUnboxerMethodClassification() {
        return this.enumUnboxerMethodClassification;
    }

    public MutableMethodOptimizationInfo setEnumUnboxerMethodClassification(EnumUnboxerMethodClassification enumUnboxerMethodClassification) {
        assert (!this.enumUnboxerMethodClassification.isCheckNotNullClassification() || enumUnboxerMethodClassification.isCheckNotNullClassification());
        this.enumUnboxerMethodClassification = enumUnboxerMethodClassification;
        return this;
    }

    public void unsetEnumUnboxerMethodClassification() {
        this.enumUnboxerMethodClassification = EnumUnboxerMethodClassification.unknown();
    }

    public MutableMethodOptimizationInfo fixupEnumUnboxerMethodClassification(MethodOptimizationInfoFixer fixer) {
        this.enumUnboxerMethodClassification = fixer.fixupEnumUnboxerMethodClassification(this.enumUnboxerMethodClassification);
        return this;
    }

    @Override
    public DynamicType getDynamicType() {
        return this.dynamicType;
    }

    @Override
    public Set<DexType> getInitializedClassesOnNormalExit() {
        return this.initializedClassesOnNormalExit;
    }

    @Override
    public InstanceInitializerInfo getContextInsensitiveInstanceInitializerInfo() {
        return this.instanceInitializerInfoCollection.getContextInsensitive();
    }

    @Override
    public InstanceInitializerInfo getInstanceInitializerInfo(InvokeDirect invoke) {
        return this.instanceInitializerInfoCollection.get(invoke);
    }

    public MutableMethodOptimizationInfo fixupInstanceInitializerInfo(AppView<AppInfoWithLiveness> appView, MethodOptimizationInfoFixer fixer) {
        this.instanceInitializerInfoCollection = fixer.fixupInstanceInitializerInfo(appView, this.instanceInitializerInfoCollection);
        return this;
    }

    @Override
    public BitSet getNonNullParamOrThrow() {
        return this.nonNullParamOrThrow;
    }

    public MutableMethodOptimizationInfo fixupNonNullParamOrThrow(MethodOptimizationInfoFixer fixer) {
        this.nonNullParamOrThrow = fixer.fixupNonNullParamOrThrow(this.nonNullParamOrThrow);
        return this;
    }

    void setNonNullParamOrThrow(BitSet facts) {
        this.nonNullParamOrThrow = facts;
    }

    void unsetNonNullParamOrThrow() {
        this.nonNullParamOrThrow = null;
    }

    @Override
    public BitSet getNonNullParamOnNormalExits() {
        return this.nonNullParamOnNormalExits;
    }

    public MutableMethodOptimizationInfo fixupNonNullParamOnNormalExits(MethodOptimizationInfoFixer fixer) {
        this.nonNullParamOnNormalExits = fixer.fixupNonNullParamOnNormalExits(this.nonNullParamOnNormalExits);
        return this;
    }

    void setNonNullParamOnNormalExits(BitSet facts) {
        this.nonNullParamOnNormalExits = facts;
    }

    void unsetNonNullParamOnNormalExits() {
        this.nonNullParamOnNormalExits = null;
    }

    @Override
    public boolean hasBeenInlinedIntoSingleCallSite() {
        return this.isFlagSet(4);
    }

    void markInlinedIntoSingleCallSite() {
        this.setFlag(4);
    }

    void unsetInlinedIntoSingleCallSite() {
        this.clearFlag(4);
    }

    @Override
    public boolean returnsArgument() {
        return this.returnedArgument != -1;
    }

    @Override
    public int getReturnedArgument() {
        assert (this.returnsArgument());
        return this.returnedArgument;
    }

    @Override
    public boolean neverReturnsNormally() {
        return this.isFlagSet(32);
    }

    @Override
    public BridgeInfo getBridgeInfo() {
        return this.bridgeInfo;
    }

    public MutableMethodOptimizationInfo fixupBridgeInfo(MethodOptimizationInfoFixer fixer) {
        if (this.bridgeInfo != null) {
            assert (this.bridgeInfo.isVirtualBridgeInfo());
            this.bridgeInfo = fixer.fixupBridgeInfo(this.bridgeInfo.asVirtualBridgeInfo());
        }
        return this;
    }

    void setBridgeInfo(BridgeInfo bridgeInfo) {
        this.bridgeInfo = bridgeInfo;
    }

    void unsetBridgeInfo() {
        this.bridgeInfo = null;
    }

    @Override
    public AbstractValue getAbstractReturnValue() {
        return this.abstractReturnValue;
    }

    @Override
    public SimpleInliningConstraint getNopInliningConstraint(InternalOptions options) {
        if (!$assertionsDisabled) {
            Objects.requireNonNull(options);
            if (false) {
                throw new AssertionError();
            }
        }
        return this.getSimpleInliningConstraint();
    }

    @Override
    public SimpleInliningConstraint getSimpleInliningConstraint() {
        return this.simpleInliningConstraint;
    }

    @Override
    public BitSet getUnusedArguments() {
        return this.unusedArguments;
    }

    public MutableMethodOptimizationInfo fixupUnusedArguments(MethodOptimizationInfoFixer fixer) {
        this.fixupUnusedArguments(fixer.fixupUnusedArguments(this.unusedArguments));
        return this;
    }

    public MutableMethodOptimizationInfo fixupUnusedArguments(BitSet unusedArguments) {
        this.unusedArguments = unusedArguments != null && !unusedArguments.isEmpty() ? unusedArguments : null;
        return this;
    }

    void setUnusedArguments(BitSet unusedArguments) {
        assert (!this.hasUnusedArguments() || unusedArguments != null);
        assert (!this.hasUnusedArguments() || BitSetUtils.verifyLessThanOrEqualTo(this.getUnusedArguments(), unusedArguments));
        this.unusedArguments = unusedArguments != null && !unusedArguments.isEmpty() ? unusedArguments : null;
    }

    void unsetUnusedArguments() {
        this.unusedArguments = null;
    }

    @Override
    public boolean isInitializerEnablingJavaVmAssertions() {
        return this.isFlagSet(128);
    }

    @Override
    public boolean isMultiCallerMethod() {
        return this.inlining == MethodOptimizationInfo.InlinePreference.MultiCallerInline;
    }

    @Override
    public OptionalBool isReturnValueUsed() {
        return this.isReturnValueUsed;
    }

    void setIsReturnValueUsed(OptionalBool isReturnValueUsed) {
        this.isReturnValueUsed = isReturnValueUsed;
    }

    @Override
    public boolean forceInline() {
        return this.inlining == MethodOptimizationInfo.InlinePreference.ForceInline;
    }

    @Override
    public boolean mayHaveSideEffects() {
        return this.isFlagSet(8);
    }

    @Override
    public boolean mayHaveSideEffects(InvokeMethod invoke, InternalOptions options) {
        if (!this.mayHaveSideEffects()) {
            return false;
        }
        return !this.getNopInliningConstraint(options).isSatisfied(invoke);
    }

    @Override
    public boolean returnValueOnlyDependsOnArguments() {
        return this.isFlagSet(16);
    }

    void setSimpleInliningConstraint(SimpleInliningConstraint constraint) {
        this.simpleInliningConstraint = constraint;
    }

    void unsetSimpleInliningConstraint() {
        this.simpleInliningConstraint = NeverSimpleInliningConstraint.getInstance();
    }

    public MutableMethodOptimizationInfo fixupSimpleInliningConstraint(AppView<AppInfoWithLiveness> appView, MethodOptimizationInfoFixer fixer) {
        this.simpleInliningConstraint = fixer.fixupSimpleInliningConstraint(appView, this.simpleInliningConstraint, appView.simpleInliningConstraintFactory());
        return this;
    }

    void setInstanceInitializerInfoCollection(InstanceInitializerInfoCollection instanceInitializerInfoCollection) {
        this.instanceInitializerInfoCollection = instanceInitializerInfoCollection;
    }

    void unsetInstanceInitializerInfoCollection() {
        this.instanceInitializerInfoCollection = InstanceInitializerInfoCollection.empty();
    }

    void setInitializerEnablingJavaAssertions() {
        this.setFlag(128);
    }

    void unsetInitializerEnablingJavaVmAssertions() {
        this.clearFlag(128);
    }

    void markInitializesClassesOnNormalExit(Set<DexType> initializedClassesOnNormalExit) {
        this.initializedClassesOnNormalExit = initializedClassesOnNormalExit;
    }

    void unsetInitializedClassesOnNormalExit() {
        this.initializedClassesOnNormalExit = Collections.emptySet();
    }

    void markReturnsArgument(int returnedArgumentIndex) {
        assert (returnedArgumentIndex >= 0);
        assert (this.returnedArgument == -1 || this.returnedArgument == returnedArgumentIndex);
        this.returnedArgument = returnedArgumentIndex;
    }

    void unsetReturnedArgument() {
        this.returnedArgument = -1;
    }

    public MutableMethodOptimizationInfo fixupReturnedArgumentIndex(MethodOptimizationInfoFixer fixer) {
        this.returnedArgument = fixer.fixupReturnedArgumentIndex(this.returnedArgument);
        return this;
    }

    void markMayNotHaveSideEffects() {
        this.clearFlag(8);
    }

    void unsetMayNotHaveSideEffects() {
        this.setFlag(8);
    }

    void markReturnValueOnlyDependsOnArguments() {
        this.setFlag(16);
    }

    void unsetReturnValueOnlyDependsOnArguments() {
        this.clearFlag(16);
    }

    void markNeverReturnsNormally() {
        this.setFlag(32);
    }

    void unsetNeverReturnsNormally() {
        this.clearFlag(32);
    }

    void markReturnsAbstractValue(AbstractValue value) {
        assert (!this.abstractReturnValue.isSingleValue() || this.abstractReturnValue.equals(value)) : "return single value changed from " + this.abstractReturnValue + " to " + value;
        this.abstractReturnValue = value;
    }

    void unsetAbstractReturnValue() {
        this.abstractReturnValue = UnknownValue.getInstance();
    }

    void setDynamicType(AppView<?> appView, DynamicType newDynamicType, DexEncodedMethod method) {
        assert (newDynamicType != null);
        assert (this.verifyDynamicType(appView, newDynamicType, method));
        this.dynamicType = newDynamicType;
    }

    void unsetDynamicType() {
        this.dynamicType = DynamicType.unknown();
    }

    public void markForceInline() {
        assert (this.inlining == MethodOptimizationInfo.InlinePreference.Default || this.inlining == MethodOptimizationInfo.InlinePreference.ForceInline);
        this.inlining = MethodOptimizationInfo.InlinePreference.ForceInline;
    }

    void unsetForceInline() {
        this.inlining = MethodOptimizationInfo.InlinePreference.Default;
    }

    void setMultiCallerMethod() {
        if (this.inlining == MethodOptimizationInfo.InlinePreference.Default) {
            this.inlining = MethodOptimizationInfo.InlinePreference.MultiCallerInline;
        } else assert (this.inlining == MethodOptimizationInfo.InlinePreference.ForceInline);
    }

    public void markAsPropagated() {
        this.setFlag(256);
    }

    @Override
    public boolean returnValueHasBeenPropagated() {
        return this.isFlagSet(256);
    }

    @Override
    public boolean isMutableOptimizationInfo() {
        return true;
    }

    @Override
    public MutableMethodOptimizationInfo toMutableOptimizationInfo() {
        return this;
    }

    @Override
    public MutableMethodOptimizationInfo asMutableMethodOptimizationInfo() {
        return this;
    }

    public MutableMethodOptimizationInfo mutableCopy() {
        return new MutableMethodOptimizationInfo(this);
    }
}

