/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.info;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.classinliner.constraint.ClassInlinerMethodConstraint;
import com.android.tools.r8.ir.optimize.enums.classification.EnumUnboxerMethodClassification;
import com.android.tools.r8.ir.optimize.info.MutableFieldOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MutableMethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.bridge.BridgeInfo;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfoCollection;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.AppInfoWithLivenessModifier;
import com.android.tools.r8.utils.IteratorUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class OptimizationFeedbackDelayed
extends OptimizationFeedback {
    private final AppInfoWithLivenessModifier appInfoWithLivenessModifier = AppInfoWithLiveness.modifier();
    private final Map<DexEncodedField, MutableFieldOptimizationInfo> fieldOptimizationInfos = new IdentityHashMap<DexEncodedField, MutableFieldOptimizationInfo>();
    private final Map<DexEncodedMethod, MutableMethodOptimizationInfo> methodOptimizationInfos = new IdentityHashMap<DexEncodedMethod, MutableMethodOptimizationInfo>();
    private final Map<DexEncodedMethod, Inliner.ConstraintWithTarget> processed = new IdentityHashMap<DexEncodedMethod, Inliner.ConstraintWithTarget>();

    private MutableFieldOptimizationInfo getFieldOptimizationInfoForUpdating(ProgramField field) {
        return this.getFieldOptimizationInfoForUpdating((DexEncodedField)field.getDefinition());
    }

    private synchronized MutableFieldOptimizationInfo getFieldOptimizationInfoForUpdating(DexEncodedField field) {
        MutableFieldOptimizationInfo info = this.fieldOptimizationInfos.get(field);
        if (info != null) {
            return info;
        }
        info = ((MutableFieldOptimizationInfo)field.getOptimizationInfo().toMutableOptimizationInfo()).mutableCopy();
        this.fieldOptimizationInfos.put(field, info);
        return info;
    }

    private synchronized MutableMethodOptimizationInfo getMethodOptimizationInfoForUpdating(DexEncodedMethod method) {
        MutableMethodOptimizationInfo info = this.methodOptimizationInfos.get(method);
        if (info != null) {
            return info;
        }
        info = ((MutableMethodOptimizationInfo)method.getOptimizationInfo().toMutableOptimizationInfo()).mutableCopy();
        this.methodOptimizationInfos.put(method, info);
        return info;
    }

    private MutableMethodOptimizationInfo getMethodOptimizationInfoForUpdating(ProgramMethod method) {
        return this.getMethodOptimizationInfoForUpdating((DexEncodedMethod)method.getDefinition());
    }

    @Override
    public void fixupOptimizationInfos(AppView<?> appView, ExecutorService executorService, OptimizationFeedback.OptimizationInfoFixer fixer) throws ExecutionException {
        this.updateVisibleOptimizationInfo();
        super.fixupOptimizationInfos(appView, executorService, fixer);
    }

    @Override
    public void modifyAppInfoWithLiveness(Consumer<AppInfoWithLivenessModifier> consumer) {
        consumer.accept(this.appInfoWithLivenessModifier);
    }

    public void refineAppInfoWithLiveness(AppInfoWithLiveness appInfo) {
        this.appInfoWithLivenessModifier.modify(appInfo);
    }

    public void updateVisibleOptimizationInfo() {
        IteratorUtils.removeIf(this.methodOptimizationInfos.entrySet().iterator(), entry -> ((DexEncodedMethod)entry.getKey()).isObsolete());
        IteratorUtils.removeIf(this.processed.entrySet().iterator(), entry -> ((DexEncodedMethod)entry.getKey()).isObsolete());
        this.fieldOptimizationInfos.forEach(DexEncodedField::setOptimizationInfo);
        this.fieldOptimizationInfos.clear();
        this.methodOptimizationInfos.forEach(DexEncodedMethod::setOptimizationInfo);
        this.methodOptimizationInfos.clear();
        this.processed.forEach(DexEncodedMethod::markProcessed);
        this.processed.clear();
    }

    public boolean noUpdatesLeft() {
        assert (this.appInfoWithLivenessModifier.isEmpty());
        assert (this.fieldOptimizationInfos.isEmpty()) : StringUtils.join(", ", this.fieldOptimizationInfos.keySet());
        assert (this.methodOptimizationInfos.isEmpty()) : StringUtils.join(", ", this.methodOptimizationInfos.keySet());
        assert (this.processed.isEmpty()) : StringUtils.join(", ", this.processed.keySet());
        return true;
    }

    @Override
    public void markFieldCannotBeKept(DexEncodedField field) {
        this.getFieldOptimizationInfoForUpdating(field).cannotBeKept();
    }

    @Override
    public void markFieldAsDead(DexEncodedField field) {
        this.getFieldOptimizationInfoForUpdating(field).markAsDead();
    }

    @Override
    public void markFieldAsPropagated(DexEncodedField field) {
        this.getFieldOptimizationInfoForUpdating(field).markAsPropagated();
    }

    @Override
    public void markFieldHasDynamicType(DexEncodedField field, DynamicType dynamicType) {
        this.getFieldOptimizationInfoForUpdating(field).setDynamicType(dynamicType);
    }

    @Override
    public void markFieldBitsRead(DexEncodedField field, int bitsRead) {
        this.getFieldOptimizationInfoForUpdating(field).joinReadBits(bitsRead);
    }

    @Override
    public void recordFieldHasAbstractValue(DexEncodedField field, AppView<AppInfoWithLiveness> appView, AbstractValue abstractValue) {
        assert (appView.appInfo().getFieldAccessInfoCollection().contains((DexField)field.getReference()));
        assert (!appView.appInfo().getFieldAccessInfoCollection().get((DexField)field.getReference()).hasReflectiveAccess());
        if (appView.appInfo().mayPropagateValueFor(appView, (DexField)field.getReference())) {
            this.getFieldOptimizationInfoForUpdating(field).setAbstractValue(abstractValue);
        }
    }

    @Override
    public void markForceInline(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markForceInline();
    }

    @Override
    public synchronized void markInlinedIntoSingleCallSite(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markInlinedIntoSingleCallSite();
    }

    @Override
    public void markMethodCannotBeKept(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).cannotBeKept();
    }

    @Override
    public synchronized void methodInitializesClassesOnNormalExit(DexEncodedMethod method, Set<DexType> initializedClasses) {
        this.getMethodOptimizationInfoForUpdating(method).markInitializesClassesOnNormalExit(initializedClasses);
    }

    @Override
    public synchronized void methodReturnsArgument(DexEncodedMethod method, int argument) {
        this.getMethodOptimizationInfoForUpdating(method).markReturnsArgument(argument);
    }

    @Override
    public synchronized void methodReturnsAbstractValue(DexEncodedMethod method, AppView<AppInfoWithLiveness> appView, AbstractValue value) {
        if (appView.appInfo().mayPropagateValueFor(appView, (DexMethod)method.getReference())) {
            this.getMethodOptimizationInfoForUpdating(method).markReturnsAbstractValue(value);
        }
    }

    @Override
    public synchronized void setDynamicReturnType(DexEncodedMethod method, AppView<?> appView, DynamicType dynamicType) {
        this.getMethodOptimizationInfoForUpdating(method).setDynamicType(appView, dynamicType, method);
    }

    @Override
    public synchronized void methodNeverReturnsNormally(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markNeverReturnsNormally();
    }

    @Override
    public synchronized void methodMayNotHaveSideEffects(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markMayNotHaveSideEffects();
    }

    @Override
    public synchronized void methodReturnValueOnlyDependsOnArguments(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markReturnValueOnlyDependsOnArguments();
    }

    @Override
    public synchronized void markAsPropagated(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markAsPropagated();
    }

    @Override
    public synchronized void markProcessed(DexEncodedMethod method, Inliner.ConstraintWithTarget state) {
        this.processed.put(method, state);
    }

    @Override
    public synchronized void setBridgeInfo(DexEncodedMethod method, BridgeInfo bridgeInfo) {
        this.getMethodOptimizationInfoForUpdating(method).setBridgeInfo(bridgeInfo);
    }

    @Override
    public synchronized void setClassInlinerMethodConstraint(ProgramMethod method, ClassInlinerMethodConstraint classInlinerConstraint) {
        this.getMethodOptimizationInfoForUpdating(method).setClassInlinerMethodConstraint(classInlinerConstraint);
    }

    @Override
    public synchronized void setEnumUnboxerMethodClassification(ProgramMethod method, EnumUnboxerMethodClassification enumUnboxerMethodClassification) {
        this.getMethodOptimizationInfoForUpdating(method).setEnumUnboxerMethodClassification(enumUnboxerMethodClassification);
    }

    @Override
    public synchronized void setInstanceInitializerInfoCollection(DexEncodedMethod method, InstanceInitializerInfoCollection instanceInitializerInfoCollection) {
        this.getMethodOptimizationInfoForUpdating(method).setInstanceInitializerInfoCollection(instanceInitializerInfoCollection);
    }

    @Override
    public synchronized void setInitializerEnablingJavaVmAssertions(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).setInitializerEnablingJavaAssertions();
    }

    @Override
    public synchronized void setNonNullParamOrThrow(DexEncodedMethod method, BitSet facts) {
        this.getMethodOptimizationInfoForUpdating(method).setNonNullParamOrThrow(facts);
    }

    @Override
    public synchronized void setNonNullParamOnNormalExits(DexEncodedMethod method, BitSet facts) {
        this.getMethodOptimizationInfoForUpdating(method).setNonNullParamOnNormalExits(facts);
    }

    @Override
    public synchronized void setSimpleInliningConstraint(ProgramMethod method, SimpleInliningConstraint constraint) {
        this.getMethodOptimizationInfoForUpdating(method).setSimpleInliningConstraint(constraint);
    }

    @Override
    public synchronized void classInitializerMayBePostponed(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).markClassInitializerMayBePostponed();
    }

    @Override
    public synchronized void setUnusedArguments(ProgramMethod method, BitSet unusedArguments) {
        this.getMethodOptimizationInfoForUpdating(method).setUnusedArguments(unusedArguments);
    }

    @Override
    public synchronized void unsetAbstractReturnValue(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetAbstractReturnValue();
    }

    @Override
    public synchronized void unsetBridgeInfo(DexEncodedMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetBridgeInfo();
    }

    @Override
    public synchronized void unsetClassInitializerMayBePostponed(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetClassInitializerMayBePostponed();
    }

    @Override
    public synchronized void unsetClassInlinerMethodConstraint(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetClassInlinerMethodConstraint();
    }

    @Override
    public synchronized void unsetDynamicReturnType(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetDynamicType();
    }

    @Override
    public synchronized void unsetEnumUnboxerMethodClassification(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetEnumUnboxerMethodClassification();
    }

    @Override
    public synchronized void unsetForceInline(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetForceInline();
    }

    @Override
    public synchronized void unsetInitializedClassesOnNormalExit(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetInitializedClassesOnNormalExit();
    }

    @Override
    public synchronized void unsetInitializerEnablingJavaVmAssertions(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetInitializerEnablingJavaVmAssertions();
    }

    @Override
    public synchronized void unsetInlinedIntoSingleCallSite(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetInlinedIntoSingleCallSite();
    }

    @Override
    public synchronized void unsetInstanceInitializerInfoCollection(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetInstanceInitializerInfoCollection();
    }

    @Override
    public synchronized void unsetMayNotHaveSideEffects(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetMayNotHaveSideEffects();
    }

    @Override
    public synchronized void unsetNeverReturnsNormally(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetNeverReturnsNormally();
    }

    @Override
    public synchronized void unsetNonNullParamOnNormalExits(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetNonNullParamOnNormalExits();
    }

    @Override
    public synchronized void unsetNonNullParamOrThrow(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetNonNullParamOrThrow();
    }

    @Override
    public synchronized void unsetReturnedArgument(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetReturnedArgument();
    }

    @Override
    public synchronized void unsetReturnValueOnlyDependsOnArguments(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetReturnValueOnlyDependsOnArguments();
    }

    @Override
    public synchronized void unsetSimpleInliningConstraint(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetSimpleInliningConstraint();
    }

    @Override
    public synchronized void unsetUnusedArguments(ProgramMethod method) {
        this.getMethodOptimizationInfoForUpdating(method).unsetUnusedArguments();
    }
}

