/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.info.field;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.ir.optimize.info.field.UnknownInstanceFieldInitializationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Objects;

public class InstanceFieldTypeInitializationInfo
implements InstanceFieldInitializationInfo {
    private final ClassTypeElement dynamicLowerBoundType;
    private final TypeElement dynamicUpperBoundType;

    InstanceFieldTypeInitializationInfo(ClassTypeElement dynamicLowerBoundType, TypeElement dynamicUpperBoundType) {
        this.dynamicLowerBoundType = dynamicLowerBoundType;
        this.dynamicUpperBoundType = dynamicUpperBoundType;
    }

    public ClassTypeElement getDynamicLowerBoundType() {
        return this.dynamicLowerBoundType;
    }

    public TypeElement getDynamicUpperBoundType() {
        return this.dynamicUpperBoundType;
    }

    @Override
    public boolean isTypeInitializationInfo() {
        return true;
    }

    @Override
    public InstanceFieldTypeInitializationInfo asTypeInitializationInfo() {
        return this;
    }

    @Override
    public InstanceFieldInitializationInfo fixupAfterParametersChanged(ArgumentInfoCollection argumentInfoCollection) {
        return this;
    }

    @Override
    public InstanceFieldInitializationInfo rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        EnumDataMap enumDataMap = appView.unboxedEnums();
        if (this.dynamicLowerBoundType != null && enumDataMap.isUnboxedEnum(this.dynamicLowerBoundType.getClassType())) {
            return UnknownInstanceFieldInitializationInfo.getInstance();
        }
        if (this.dynamicUpperBoundType.isClassType() && enumDataMap.isUnboxedEnum(this.dynamicUpperBoundType.asClassType().getClassType())) {
            return UnknownInstanceFieldInitializationInfo.getInstance();
        }
        return new InstanceFieldTypeInitializationInfo(this.dynamicLowerBoundType != null ? this.dynamicLowerBoundType.rewrittenWithLens(appView, lens, codeLens).asClassType() : null, this.dynamicUpperBoundType.rewrittenWithLens(appView, lens, codeLens));
    }

    public int hashCode() {
        return Objects.hash(this.dynamicLowerBoundType, this.dynamicUpperBoundType);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        InstanceFieldTypeInitializationInfo info = (InstanceFieldTypeInitializationInfo)other;
        return Objects.equals(this.dynamicLowerBoundType, info.dynamicLowerBoundType) && Objects.equals(this.dynamicUpperBoundType, info.dynamicUpperBoundType);
    }

    public String toString() {
        return "InstanceFieldTypeInitializationInfo";
    }
}

