/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.info.initializer;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.optimize.info.initializer.AlwaysTrueInstanceInitializerInfoContext;
import com.android.tools.r8.ir.optimize.info.initializer.DefaultInstanceInitializerInfo;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfoCollection;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfoContext;
import com.android.tools.r8.ir.optimize.info.initializer.NonTrivialInstanceInitializerInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Map;

public class ContextSensitiveInstanceInitializerInfoCollection
extends InstanceInitializerInfoCollection {
    private final ImmutableMap<InstanceInitializerInfoContext, NonTrivialInstanceInitializerInfo> infos;

    protected ContextSensitiveInstanceInitializerInfoCollection(ImmutableMap<InstanceInitializerInfoContext, NonTrivialInstanceInitializerInfo> infos) {
        assert (!infos.isEmpty());
        this.infos = infos;
    }

    @Override
    public InstanceInitializerInfo getContextInsensitive() {
        NonTrivialInstanceInitializerInfo result = this.infos.get(AlwaysTrueInstanceInitializerInfoContext.getInstance());
        return result != null ? result : DefaultInstanceInitializerInfo.getInstance();
    }

    @Override
    public InstanceInitializerInfo get(InvokeDirect invoke) {
        assert (this.infos.keySet().stream().filter(context -> context.isSatisfiedBy(invoke)).count() <= 1L);
        for (Map.Entry entry : this.infos.entrySet()) {
            if (!((InstanceInitializerInfoContext)entry.getKey()).isSatisfiedBy(invoke)) continue;
            return (InstanceInitializerInfo)entry.getValue();
        }
        return DefaultInstanceInitializerInfo.getInstance();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public InstanceInitializerInfoCollection fixupAfterParametersChanged(AppView<AppInfoWithLiveness> appView, ArgumentInfoCollection argumentInfoCollection) {
        InstanceInitializerInfoCollection.Builder builder = ContextSensitiveInstanceInitializerInfoCollection.builder();
        this.infos.forEach((context, info) -> builder.put((InstanceInitializerInfoContext)context, info.fixupAfterParametersChanged((AppView)appView, argumentInfoCollection)));
        return builder.build();
    }

    @Override
    public InstanceInitializerInfoCollection rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens, PrunedItems prunedItems) {
        InstanceInitializerInfoCollection.Builder builder = ContextSensitiveInstanceInitializerInfoCollection.builder();
        this.infos.forEach((context, info) -> builder.put((InstanceInitializerInfoContext)context, info.rewrittenWithLens((AppView)appView, lens, codeLens, prunedItems)));
        return builder.build();
    }
}

