/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.info.initializer;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.optimize.info.initializer.ContextInsensitiveInstanceInitializerInfoCollection;
import com.android.tools.r8.ir.optimize.info.initializer.ContextSensitiveInstanceInitializerInfoCollection;
import com.android.tools.r8.ir.optimize.info.initializer.EmptyInstanceInitializerInfoCollection;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfoContext;
import com.android.tools.r8.ir.optimize.info.initializer.NonTrivialInstanceInitializerInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MapUtils;

public abstract class InstanceInitializerInfoCollection {
    public static Builder builder() {
        return new Builder();
    }

    public static InstanceInitializerInfoCollection empty() {
        return EmptyInstanceInitializerInfoCollection.getInstance();
    }

    public static InstanceInitializerInfoCollection of(InstanceInitializerInfo info) {
        if (info != null && info.isNonTrivialInstanceInitializerInfo()) {
            return new ContextInsensitiveInstanceInitializerInfoCollection(info.asNonTrivialInstanceInitializerInfo());
        }
        return InstanceInitializerInfoCollection.empty();
    }

    public abstract InstanceInitializerInfo getContextInsensitive();

    public abstract InstanceInitializerInfo get(InvokeDirect var1);

    public abstract boolean isEmpty();

    public abstract InstanceInitializerInfoCollection fixupAfterParametersChanged(AppView<AppInfoWithLiveness> var1, ArgumentInfoCollection var2);

    public abstract InstanceInitializerInfoCollection rewrittenWithLens(AppView<AppInfoWithLiveness> var1, GraphLens var2, GraphLens var3, PrunedItems var4);

    public static class Builder {
        private final ImmutableMap.Builder<InstanceInitializerInfoContext, NonTrivialInstanceInitializerInfo> infosBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder put(InstanceInitializerInfoContext context, InstanceInitializerInfo info) {
            if (info.isNonTrivialInstanceInitializerInfo()) {
                this.infosBuilder.put(context, info.asNonTrivialInstanceInitializerInfo());
            }
            return this;
        }

        public InstanceInitializerInfoCollection build() {
            ImmutableMap<InstanceInitializerInfoContext, NonTrivialInstanceInitializerInfo> infos = this.infosBuilder.build();
            if (infos.isEmpty()) {
                return InstanceInitializerInfoCollection.empty();
            }
            if (infos.size() == 1 && MapUtils.firstKey(infos).isAlwaysTrue()) {
                return new ContextInsensitiveInstanceInitializerInfoCollection(MapUtils.firstValue(infos));
            }
            return new ContextSensitiveInstanceInitializerInfoCollection(infos);
        }
    }
}

