/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.info.initializer;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.AbstractFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.ConcreteMutableFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.EmptyFieldSet;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.UnknownFieldSet;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoCollection;
import com.android.tools.r8.ir.optimize.info.initializer.DefaultInstanceInitializerInfo;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public final class NonTrivialInstanceInitializerInfo
extends InstanceInitializerInfo {
    private static final int INSTANCE_FIELD_INITIALIZATION_INDEPENDENT_OF_ENVIRONMENT = 1;
    private static final int NO_OTHER_SIDE_EFFECTS_THAN_INSTANCE_FIELD_ASSIGNMENTS = 2;
    private static final int RECEIVER_NEVER_ESCAPE_OUTSIDE_CONSTRUCTOR_CHAIN = 4;
    private final int data;
    private final InstanceFieldInitializationInfoCollection fieldInitializationInfos;
    private final AbstractFieldSet readSet;
    private final DexMethod parent;

    private NonTrivialInstanceInitializerInfo(int data2, InstanceFieldInitializationInfoCollection fieldInitializationInfos, AbstractFieldSet readSet, DexMethod parent) {
        assert (NonTrivialInstanceInitializerInfo.verifyNoUnknownBits(data2));
        this.data = data2;
        this.fieldInitializationInfos = fieldInitializationInfos;
        this.readSet = readSet;
        this.parent = parent;
    }

    private static boolean verifyNoUnknownBits(int data2) {
        int knownBits = 7;
        assert ((data2 & ~knownBits) == 0);
        return true;
    }

    public static Builder builder(InstanceFieldInitializationInfoCollection instanceFieldInitializationInfos) {
        return new Builder(instanceFieldInitializationInfos);
    }

    @Override
    public boolean isNonTrivialInstanceInitializerInfo() {
        return true;
    }

    @Override
    public NonTrivialInstanceInitializerInfo asNonTrivialInstanceInitializerInfo() {
        return this;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public DexMethod getParent() {
        return this.parent;
    }

    @Override
    public InstanceFieldInitializationInfoCollection fieldInitializationInfos() {
        return this.fieldInitializationInfos;
    }

    @Override
    public AbstractFieldSet readSet() {
        return this.readSet;
    }

    @Override
    public boolean instanceFieldInitializationMayDependOnEnvironment() {
        return (this.data & 1) == 0;
    }

    @Override
    public boolean mayHaveOtherSideEffectsThanInstanceFieldAssignments() {
        return (this.data & 2) == 0;
    }

    @Override
    public boolean receiverNeverEscapesOutsideConstructorChain() {
        return (this.data & 4) != 0;
    }

    @Override
    public NonTrivialInstanceInitializerInfo fixupAfterParametersChanged(AppView<AppInfoWithLiveness> appView, ArgumentInfoCollection argumentInfoCollection) {
        return new NonTrivialInstanceInitializerInfo(this.data, this.fieldInitializationInfos.fixupAfterParametersChanged(argumentInfoCollection), this.readSet.fixupReadSetAfterParametersChanged(appView, argumentInfoCollection), this.parent);
    }

    @Override
    public NonTrivialInstanceInitializerInfo rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens, PrunedItems prunedItems) {
        return new NonTrivialInstanceInitializerInfo(this.data, this.fieldInitializationInfos.rewrittenWithLens(appView, lens, codeLens), this.readSet.rewrittenWithLens(appView, lens, codeLens, prunedItems), lens.getRenamedMethodSignature(this.parent, codeLens));
    }

    public String toString() {
        return "NonTrivialInstanceInitializerInfo(" + this.fieldInitializationInfos + ")";
    }

    public static class Builder {
        private final InstanceFieldInitializationInfoCollection instanceFieldInitializationInfos;
        private int data = 7;
        private AbstractFieldSet readSet = EmptyFieldSet.getInstance();
        private DexMethod parent;

        public Builder(InstanceFieldInitializationInfoCollection instanceFieldInitializationInfos) {
            this.instanceFieldInitializationInfos = instanceFieldInitializationInfos;
        }

        private boolean isTrivial() {
            return this.instanceFieldInitializationInfos.isEmpty() && this.data == 0 && this.readSet.isTop() && this.parent == null;
        }

        public Builder markFieldAsRead(DexEncodedField field) {
            if (this.readSet.isKnownFieldSet()) {
                if (this.readSet.isBottom()) {
                    this.readSet = new ConcreteMutableFieldSet(field);
                } else {
                    this.readSet.asConcreteFieldSet().add(field);
                }
            }
            assert (this.readSet.contains(field));
            return this;
        }

        public Builder markFieldsAsRead(AbstractFieldSet otherReadSet) {
            if (this.readSet.isTop() || otherReadSet.isBottom()) {
                return this;
            }
            if (otherReadSet.isTop()) {
                return this.markAllFieldsAsRead();
            }
            ConcreteMutableFieldSet otherConcreteReadSet = otherReadSet.asConcreteFieldSet();
            if (this.readSet.isBottom()) {
                this.readSet = new ConcreteMutableFieldSet().addAll(otherConcreteReadSet);
            } else {
                this.readSet.asConcreteFieldSet().addAll(otherConcreteReadSet);
            }
            return this;
        }

        public Builder markAllFieldsAsRead() {
            this.readSet = UnknownFieldSet.getInstance();
            return this;
        }

        public Builder merge(InstanceInitializerInfo instanceInitializerInfo) {
            this.markFieldsAsRead(instanceInitializerInfo.readSet());
            if (instanceInitializerInfo.instanceFieldInitializationMayDependOnEnvironment()) {
                this.setInstanceFieldInitializationMayDependOnEnvironment();
            }
            if (instanceInitializerInfo.mayHaveOtherSideEffectsThanInstanceFieldAssignments()) {
                this.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
            }
            if (instanceInitializerInfo.receiverMayEscapeOutsideConstructorChain()) {
                this.setReceiverMayEscapeOutsideConstructorChain();
            }
            return this;
        }

        public Builder setInstanceFieldInitializationMayDependOnEnvironment() {
            this.data &= 0xFFFFFFFE;
            return this;
        }

        public boolean mayHaveOtherSideEffectsThanInstanceFieldAssignments() {
            return (this.data & 0xFFFFFFFD) == 0;
        }

        public Builder setMayHaveOtherSideEffectsThanInstanceFieldAssignments() {
            this.data &= 0xFFFFFFFD;
            return this;
        }

        public Builder setReceiverMayEscapeOutsideConstructorChain() {
            this.data &= 0xFFFFFFFB;
            return this;
        }

        public boolean hasParent() {
            return this.parent != null;
        }

        public DexMethod getParent() {
            return this.parent;
        }

        public Builder setParent(DexMethod parent) {
            assert (!this.hasParent() || this.getParent() == parent);
            this.parent = parent;
            return this;
        }

        public InstanceInitializerInfo build() {
            return this.isTrivial() ? DefaultInstanceInitializerInfo.getInstance() : new NonTrivialInstanceInitializerInfo(this.data, this.instanceFieldInitializationInfos, this.readSet, this.parent);
        }
    }
}

