/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.inliner;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.conversion.callgraph.CallSiteInformation;
import com.android.tools.r8.ir.optimize.DefaultInliningOracle;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.inliner.InliningReasonStrategy;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;

public class DefaultInliningReasonStrategy
implements InliningReasonStrategy {
    private final AppView<AppInfoWithLiveness> appView;
    private final CallSiteInformation callSiteInformation;
    private final InternalOptions.InlinerOptions options;

    public DefaultInliningReasonStrategy(AppView<AppInfoWithLiveness> appView, CallSiteInformation callSiteInformation) {
        this.appView = appView;
        this.callSiteInformation = callSiteInformation;
        this.options = appView.options().inlinerOptions();
    }

    private boolean isSingleCallerInliningTarget(ProgramMethod method) {
        if (!this.callSiteInformation.hasSingleCallSite(method)) {
            return false;
        }
        if (this.appView.appInfo().isNeverInlineDueToSingleCallerMethod(method)) {
            return false;
        }
        return this.appView.testing().validInliningReasons == null || this.appView.testing().validInliningReasons.contains((Object)Inliner.Reason.SINGLE_CALLER);
    }

    private boolean isMultiCallerInlineCandidate(InvokeMethod invoke, ProgramMethod singleTarget, DefaultInliningOracle oracle, MethodProcessor methodProcessor) {
        if (oracle.satisfiesRequirementsForSimpleInlining(invoke, singleTarget)) {
            return false;
        }
        if (methodProcessor.isPrimaryMethodProcessor()) {
            return this.callSiteInformation.isMultiCallerInlineCandidate(singleTarget);
        }
        if (methodProcessor.isPostMethodProcessor()) {
            return singleTarget.getOptimizationInfo().isMultiCallerMethod();
        }
        return false;
    }

    @Override
    public Inliner.Reason computeInliningReason(InvokeMethod invoke, ProgramMethod target, ProgramMethod context, DefaultInliningOracle oracle, MethodProcessor methodProcessor) {
        DexEncodedMethod targetMethod = (DexEncodedMethod)target.getDefinition();
        DexMethod targetReference = (DexMethod)target.getReference();
        if (targetMethod.getOptimizationInfo().forceInline()) {
            assert (this.appView.getKeepInfo(target).isInliningAllowed(this.appView.options()));
            return Inliner.Reason.FORCE;
        }
        if (this.appView.appInfo().hasLiveness() && this.appView.withLiveness().appInfo().isAlwaysInlineMethod(targetReference)) {
            return Inliner.Reason.ALWAYS;
        }
        if (this.options.disableInliningOfLibraryMethodOverrides && targetMethod.isLibraryMethodOverride().isTrue()) {
            return Inliner.Reason.SIMPLE;
        }
        if (this.isSingleCallerInliningTarget(target)) {
            return Inliner.Reason.SINGLE_CALLER;
        }
        if (this.isMultiCallerInlineCandidate(invoke, target, oracle, methodProcessor)) {
            return methodProcessor.isPrimaryMethodProcessor() ? Inliner.Reason.MULTI_CALLER_CANDIDATE : Inliner.Reason.ALWAYS;
        }
        return Inliner.Reason.SIMPLE;
    }
}

