/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.inliner;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.NumberGenerator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.origin.Origin;
import java.util.IdentityHashMap;
import java.util.Map;

public class InliningIRProvider {
    private final AppView<?> appView;
    private final ProgramMethod context;
    private final NumberGenerator valueNumberGenerator;
    private final MethodProcessor methodProcessor;
    private final Map<InvokeMethod, IRCode> cache = new IdentityHashMap<InvokeMethod, IRCode>();

    private InliningIRProvider() {
        this.appView = null;
        this.context = null;
        this.valueNumberGenerator = null;
        this.methodProcessor = null;
    }

    public InliningIRProvider(AppView<?> appView, ProgramMethod context, IRCode code, MethodProcessor methodProcessor) {
        this.appView = appView;
        this.context = context;
        this.valueNumberGenerator = code.valueNumberGenerator;
        this.methodProcessor = methodProcessor;
    }

    public static InliningIRProvider getThrowingInstance() {
        return new InliningIRProvider(){

            @Override
            public IRCode getInliningIR(InvokeMethod invoke, ProgramMethod method) {
                throw new Unreachable();
            }

            @Override
            public IRCode getAndCacheInliningIR(InvokeMethod invoke, ProgramMethod method) {
                throw new Unreachable();
            }

            @Override
            public void cacheInliningIR(InvokeMethod invoke, IRCode code) {
                throw new Unreachable();
            }

            @Override
            public MethodProcessor getMethodProcessor() {
                throw new Unreachable();
            }

            @Override
            public boolean verifyIRCacheIsEmpty() {
                throw new Unreachable();
            }

            @Override
            public boolean shouldApplyCodeRewritings(ProgramMethod method) {
                throw new Unreachable();
            }
        };
    }

    public IRCode getInliningIR(InvokeMethod invoke, ProgramMethod method) {
        IRCode cached = this.cache.remove(invoke);
        if (cached != null) {
            return cached;
        }
        Origin origin = method.getOrigin();
        return method.buildInliningIR(this.context, this.appView, this.valueNumberGenerator, Position.getPositionForInlining(this.appView, invoke, this.context), origin, this.methodProcessor);
    }

    public IRCode getAndCacheInliningIR(InvokeMethod invoke, ProgramMethod method) {
        IRCode inliningIR = this.getInliningIR(invoke, method);
        this.cacheInliningIR(invoke, inliningIR);
        return inliningIR;
    }

    public void cacheInliningIR(InvokeMethod invoke, IRCode code) {
        IRCode existing = this.cache.put(invoke, code);
        assert (existing == null);
    }

    public MethodProcessor getMethodProcessor() {
        return this.methodProcessor;
    }

    public boolean verifyIRCacheIsEmpty() {
        assert (this.cache.isEmpty());
        return true;
    }

    public boolean shouldApplyCodeRewritings(ProgramMethod method) {
        return this.methodProcessor.shouldApplyCodeRewritings(method);
    }
}

