/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.inliner;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.utils.StringUtils;
import java.io.PrintStream;
import java.util.Set;

class WhyAreYouNotInliningReporterImpl
extends WhyAreYouNotInliningReporter {
    private final ProgramMethod callee;
    private final ProgramMethod context;
    private final PrintStream output;
    private boolean reasonHasBeenReported = false;

    WhyAreYouNotInliningReporterImpl(ProgramMethod callee, ProgramMethod context, PrintStream output) {
        this.callee = callee;
        this.context = context;
        this.output = output;
    }

    private void print(String reason) {
        this.output.print("Method `");
        this.output.print(this.callee.toSourceString());
        this.output.print("` was not inlined into `");
        this.output.print(this.context.toSourceString());
        if (reason != null) {
            this.output.print("`: ");
            this.output.println(reason);
        } else {
            this.output.println("`.");
        }
        this.reasonHasBeenReported = true;
    }

    private void printWithExceededThreshold(String reason, String description, int value, int threshold) {
        this.print(reason + " (" + description + ": " + value + ", threshold: " + threshold + ").");
    }

    @Override
    public void reportCallerNotSameClass() {
        this.print("inlinee can only be inlined into methods in the same class.");
    }

    @Override
    public void reportCallerNotSameNest() {
        this.print("inlinee can only be inlined into methods in the same class (and its nest members).");
    }

    @Override
    public void reportCallerNotSamePackage() {
        this.print("inlinee can only be inlined into methods in the same package (declared package private or accesses package private type or member).");
    }

    @Override
    public void reportCallerNotSubtype() {
        this.print("inlinee can only be inlined into methods in the same package and methods in subtypes of the inlinee's enclosing class(declared protected or accesses protected type or member).");
    }

    @Override
    public void reportCallerHasUnknownApiLevel() {
        this.print("computed API level for caller is unknown");
    }

    @Override
    public void reportClasspathMethod() {
        this.print("inlinee is on the classpath.");
    }

    @Override
    public void reportInaccessible() {
        this.print("inlinee is not accessible from the caller context.");
    }

    @Override
    public void reportIncorrectArity(int numberOfArguments, int arity) {
        this.print("number of arguments (" + numberOfArguments + ") does not match arity of method (" + arity + ").");
    }

    @Override
    public void reportInlineeDoesNotHaveCode() {
        this.print("inlinee does not have code.");
    }

    @Override
    public void reportInlineeNotInliningCandidate() {
        this.print("unsupported instruction in inlinee.");
    }

    @Override
    public void reportInlineeNotProcessed() {
        this.print("inlinee not processed yet.");
    }

    @Override
    public void reportInlineeNotSimple() {
        this.print("not inlining due to code size heuristic (inlinee may have multiple callers and is not considered trivial).");
    }

    @Override
    public void reportInlineeHigherApiCall(ComputedApiLevel callerApiLevel, ComputedApiLevel inlineeApiLevel) {
        assert (callerApiLevel.isKnownApiLevel());
        if (inlineeApiLevel.isUnknownApiLevel()) {
            this.print("computed API level for inlinee is unknown");
        } else {
            assert (inlineeApiLevel.isKnownApiLevel());
            this.print("computed API level for inlinee (" + inlineeApiLevel.asKnownApiLevel().getApiLevel() + ") is higher than caller's (" + callerApiLevel.asKnownApiLevel().getApiLevel() + ")");
        }
    }

    @Override
    public void reportInlineeRefersToClassesNotInMainDex() {
        this.print("inlining could increase the main dex size (caller is in main dex and inlinee refers to classes not in main dex).");
    }

    @Override
    public void reportInliningAcrossFeatureSplit() {
        this.print("cannot inline across feature splits.");
    }

    @Override
    public void reportInstructionBudgetIsExceeded() {
        this.print("caller's instruction budget is exceeded.");
    }

    @Override
    public void reportInvalidDoubleInliningCandidate() {
        this.print("inlinee is invoked more than once and could not be inlined into all call sites.");
    }

    @Override
    public void reportInvalidInliningReason(Inliner.Reason reason, Set<Inliner.Reason> validInliningReasons) {
        this.print("not a valid inlining reason (was: " + (Object)((Object)reason) + ", allowed: one of " + StringUtils.join(", ", validInliningReasons) + ").");
    }

    @Override
    public void reportLibraryMethod() {
        this.print("inlinee is a library method.");
    }

    @Override
    public void reportMarkedAsNeverInline() {
        this.print("method is marked by a -neverinline rule.");
    }

    @Override
    public void reportMustTriggerClassInitialization() {
        this.print("cannot guarantee that the enclosing class of the inlinee is guaranteed to be class initialized before the first side-effecting instruction in the inlinee.");
    }

    @Override
    public void reportNoInliningIntoConstructorsWhenGeneratingClassFiles() {
        this.print("inlining into constructors not supported when generating class files.");
    }

    @Override
    public void reportPinned() {
        this.print("method is kept by a Proguard configuration rule.");
    }

    @Override
    public void reportPotentialExplosionInExceptionalControlFlowResolutionBlocks(int estimatedNumberOfControlFlowResolutionBlocks, int threshold) {
        this.printWithExceededThreshold("could lead to an explosion in the number of moves due to the exceptional control flow", "estimated number of control flow resolution blocks", estimatedNumberOfControlFlowResolutionBlocks, threshold);
    }

    @Override
    public void reportProcessedConcurrently() {
        this.print("could lead to nondeterministic output since the inlinee is being optimized concurrently.");
    }

    @Override
    public void reportReceiverDefinitelyNull() {
        this.print("the receiver is always null at the call site.");
    }

    @Override
    public void reportReceiverMaybeNull() {
        this.print("the receiver may be null at the call site.");
    }

    @Override
    public void reportRecursiveMethod() {
        this.print("recursive calls are not inlined.");
    }

    @Override
    public void reportUnknownTarget() {
        this.print("could not find a single target.");
    }

    @Override
    public void reportUnsafeConstructorInliningDueToFinalFieldAssignment(InstancePut instancePut) {
        this.print("final field `" + instancePut.getField() + "` must be initialized in a constructor of `" + this.callee.getHolderType().toSourceString() + "`.");
    }

    @Override
    public void reportUnsafeConstructorInliningDueToIndirectConstructorCall(InvokeDirect invoke) {
        this.print("must invoke a constructor from the class being instantiated (would invoke `" + invoke.getInvokedMethod().toSourceString() + "`).");
    }

    @Override
    public void reportUnsafeConstructorInliningDueToUninitializedObjectUse(Instruction user) {
        this.print("would lead to use of uninitialized object (user: `" + user.toString() + "`).");
    }

    @Override
    public void reportWillExceedInstructionBudget(int numberOfInstructions, int threshold) {
        this.printWithExceededThreshold("would exceed the caller's instruction budget", "number of instructions in inlinee", numberOfInstructions, threshold);
    }

    @Override
    public void reportWillExceedMaxInliningDepth(int actualInliningDepth, int threshold) {
        this.printWithExceededThreshold("would exceed the maximum inlining depth", "current inlining depth", actualInliningDepth, threshold);
    }

    @Override
    public void reportWillExceedMonitorEnterValuesBudget(int numberOfMonitorEnterValuesAfterInlining, int threshold) {
        this.printWithExceededThreshold("could negatively impact register allocation due to the number of monitor instructions", "estimated number of locks after inlining", numberOfMonitorEnterValuesAfterInlining, threshold);
    }

    @Override
    public boolean unsetReasonHasBeenReportedFlag() {
        assert (this.reasonHasBeenReported);
        this.reasonHasBeenReported = false;
        return true;
    }
}

