/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.library.StatelessLibraryMethodModelCollection;
import java.util.Set;

public class BooleanMethodOptimizer
extends StatelessLibraryMethodModelCollection {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;

    BooleanMethodOptimizer(AppView<?> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
    }

    private void optimizeBooleanValue(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke) {
        Instruction definition;
        Value argument = invoke.arguments().get(0).getAliasedValue();
        if (!argument.isPhi() && (definition = argument.definition).isStaticGet()) {
            StaticGet staticGet = definition.asStaticGet();
            DexField field = staticGet.getField();
            if (field == this.dexItemFactory.booleanMembers.TRUE) {
                instructionIterator.replaceCurrentInstructionWithConstInt(code, 1);
            } else if (field == this.dexItemFactory.booleanMembers.FALSE) {
                instructionIterator.replaceCurrentInstructionWithConstInt(code, 0);
            }
        }
    }

    private void optimizeParseBoolean(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke) {
        ConstString constString;
        Instruction definition;
        Value argument = invoke.arguments().get(0).getAliasedValue();
        if (!argument.isPhi() && (definition = argument.definition).isConstString() && !(constString = definition.asConstString()).instructionInstanceCanThrow()) {
            String value = constString.getValue().toString().toLowerCase();
            if (value.equals("true")) {
                instructionIterator.replaceCurrentInstructionWithConstInt(code, 1);
            } else if (value.equals("false")) {
                instructionIterator.replaceCurrentInstructionWithConstInt(code, 0);
            }
        }
    }

    private void optimizeValueOf(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke, Set<Value> affectedValues) {
        Value argument = invoke.arguments().get(0);
        AbstractValue abstractValue = argument.getAbstractValue(this.appView, code.context());
        if (abstractValue.isSingleNumberValue()) {
            instructionIterator.replaceCurrentInstructionWithStaticGet(this.appView, code, abstractValue.asSingleNumberValue().getBooleanValue() ? this.dexItemFactory.booleanMembers.TRUE : this.dexItemFactory.booleanMembers.FALSE, affectedValues);
        }
    }

    @Override
    public DexType getType() {
        return this.dexItemFactory.boxedBooleanType;
    }

    @Override
    public void optimize(IRCode code, BasicBlockIterator blockIterator, InstructionListIterator instructionIterator, InvokeMethod invoke, DexClassAndMethod singleTarget, Set<Value> affectedValues, Set<BasicBlock> blocksToRemove) {
        if (singleTarget.getReference() == this.dexItemFactory.booleanMembers.booleanValue) {
            this.optimizeBooleanValue(code, instructionIterator, invoke);
        } else if (singleTarget.getReference() == this.dexItemFactory.booleanMembers.parseBoolean) {
            this.optimizeParseBoolean(code, instructionIterator, invoke);
        } else if (singleTarget.getReference() == this.dexItemFactory.booleanMembers.valueOf) {
            this.optimizeValueOf(code, instructionIterator, invoke, affectedValues);
        }
    }
}

