/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.library.StatelessLibraryMethodModelCollection;
import java.util.Set;

public class ByteMethodOptimizer
extends StatelessLibraryMethodModelCollection {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;

    ByteMethodOptimizer(AppView<?> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
    }

    private void optimizeByteValue(InstructionListIterator instructionIterator, InvokeMethod byteValueInvoke) {
        Instruction definition;
        Value argument = byteValueInvoke.getFirstArgument().getAliasedValue();
        if (!argument.isPhi() && (definition = argument.getDefinition()).isInvokeStatic() && definition.asInvokeStatic().getInvokedMethod() == this.dexItemFactory.byteMembers.valueOf) {
            byteValueInvoke.outValue().replaceUsers(definition.asInvokeStatic().getFirstArgument());
            instructionIterator.removeOrReplaceByDebugLocalRead();
        }
    }

    @Override
    public DexType getType() {
        return this.dexItemFactory.boxedByteType;
    }

    @Override
    public void optimize(IRCode code, BasicBlockIterator blockIterator, InstructionListIterator instructionIterator, InvokeMethod invoke, DexClassAndMethod singleTarget, Set<Value> affectedValues, Set<BasicBlock> blocksToRemove) {
        if (singleTarget.getReference() == this.dexItemFactory.byteMembers.byteValue) {
            this.optimizeByteValue(instructionIterator, invoke);
        }
    }
}

