/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.library.StatelessLibraryMethodModelCollection;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

public class EnumMethodOptimizer
extends StatelessLibraryMethodModelCollection {
    private final AppView<?> appView;

    EnumMethodOptimizer(AppView<?> appView) {
        this.appView = appView;
    }

    private void insertAssumeDynamicType(AppView<AppInfoWithLiveness> appView, IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke) {
        if (invoke.getBlock().hasCatchHandlers()) {
            return;
        }
        DexType enumType = invoke.inValues().get(0).getConstInstruction().asConstClass().getValue();
        DexProgramClass enumClass = appView.definitionForProgramType(enumType);
        if (enumClass == null || !enumClass.isEnum() || enumClass.superType != appView.dexItemFactory().enumType) {
            return;
        }
        Value outValue = invoke.outValue();
        if (outValue == null) {
            return;
        }
        Value specializedOutValue = code.createValue(outValue.getType(), outValue.getLocalInfo());
        outValue.replaceUsers(specializedOutValue);
        DynamicTypeWithUpperBound dynamicType = enumType.toDynamicType(appView, Nullability.definitelyNotNull());
        Assume assumeInstruction = Assume.createAssumeDynamicTypeInstruction(dynamicType, specializedOutValue, outValue, invoke, appView);
        assumeInstruction.setPosition(appView.options().debug ? invoke.getPosition() : Position.none());
        instructionIterator.add(assumeInstruction);
    }

    @Override
    public DexType getType() {
        return this.appView.dexItemFactory().enumType;
    }

    @Override
    public void optimize(IRCode code, BasicBlockIterator blockIterator, InstructionListIterator instructionIterator, InvokeMethod invoke, DexClassAndMethod singleTarget, Set<Value> affectedValues, Set<BasicBlock> blocksToRemove) {
        if (this.appView.hasLiveness() && singleTarget.getReference() == this.appView.dexItemFactory().enumMembers.valueOf && invoke.inValues().get(0).isConstClass()) {
            this.insertAssumeDynamicType(this.appView.withLiveness(), code, instructionIterator, invoke);
        }
    }
}

