/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CodeOptimization;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.library.BooleanMethodOptimizer;
import com.android.tools.r8.ir.optimize.library.ByteMethodOptimizer;
import com.android.tools.r8.ir.optimize.library.EnumMethodOptimizer;
import com.android.tools.r8.ir.optimize.library.LibraryMethodModelCollection;
import com.android.tools.r8.ir.optimize.library.LibraryOptimizationInfoInitializer;
import com.android.tools.r8.ir.optimize.library.LogMethodOptimizer;
import com.android.tools.r8.ir.optimize.library.ObjectMethodOptimizer;
import com.android.tools.r8.ir.optimize.library.ObjectsMethodOptimizer;
import com.android.tools.r8.ir.optimize.library.StringBuilderMethodOptimizer;
import com.android.tools.r8.ir.optimize.library.StringMethodOptimizer;
import com.android.tools.r8.utils.Timing;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class LibraryMemberOptimizer
implements CodeOptimization {
    private final AppView<?> appView;
    private final Set<DexField> finalLibraryFields = Sets.newIdentityHashSet();
    private final Set<DexType> modeledLibraryTypes = Sets.newIdentityHashSet();
    private final Map<DexType, LibraryMethodModelCollection<?>> libraryMethodModelCollections = new IdentityHashMap();

    public LibraryMemberOptimizer(AppView<?> appView, Timing timing) {
        this.appView = appView;
        timing.begin("Register optimizers");
        this.register(new BooleanMethodOptimizer(appView));
        this.register(new ByteMethodOptimizer(appView));
        this.register(new ObjectMethodOptimizer(appView));
        this.register(new ObjectsMethodOptimizer(appView));
        this.register(new StringBuilderMethodOptimizer(appView));
        this.register(new StringMethodOptimizer(appView));
        if (appView.enableWholeProgramOptimizations()) {
            this.register(new EnumMethodOptimizer(appView));
        }
        if (LogMethodOptimizer.isEnabled(appView)) {
            this.register(new LogMethodOptimizer(appView));
        }
        timing.end();
        timing.time("Initialize final fields", this::initializeFinalLibraryFields);
        if (appView.enableWholeProgramOptimizations()) {
            timing.begin("Initialize opt info");
            LibraryOptimizationInfoInitializer libraryOptimizationInfoInitializer = new LibraryOptimizationInfoInitializer(appView);
            libraryOptimizationInfoInitializer.run();
            this.modeledLibraryTypes.addAll(libraryOptimizationInfoInitializer.getModeledLibraryTypes());
            timing.end();
        }
    }

    private void initializeFinalLibraryFields() {
        for (DexItemFactory.LibraryMembers libraryMembers : this.appView.dexItemFactory().libraryMembersCollection) {
            libraryMembers.forEachFinalField(this.finalLibraryFields::add);
        }
    }

    private void register(LibraryMethodModelCollection<?> optimizer) {
        DexType modeledType = optimizer.getType();
        LibraryMethodModelCollection<?> existing = this.libraryMethodModelCollections.put(modeledType, optimizer);
        assert (existing == null);
        this.modeledLibraryTypes.add(modeledType);
    }

    public boolean isFinalLibraryField(DexEncodedField field) {
        return field.isFinal() && this.finalLibraryFields.contains(field.getReference());
    }

    public boolean isModeled(DexType type) {
        return this.modeledLibraryTypes.contains(type);
    }

    @Override
    public void optimize(IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor, CompilationContext.MethodProcessingContext methodProcessingContext) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        BasicBlockIterator blockIterator = code.listIterator();
        Set<BasicBlock> blocksToRemove = Sets.newIdentityHashSet();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (blocksToRemove.contains(block)) continue;
            InstructionListIterator instructionIterator = block.listIterator(code);
            IdentityHashMap<LibraryMethodModelCollection, LibraryMethodModelCollection.State> optimizationStates = new IdentityHashMap<LibraryMethodModelCollection, LibraryMethodModelCollection.State>();
            while (instructionIterator.hasNext()) {
                LibraryMethodModelCollection<?> optimizer;
                InvokeMethod invoke;
                DexClassAndMethod singleTarget;
                Instruction instruction = (Instruction)instructionIterator.next();
                if (!instruction.isInvokeMethod() || (singleTarget = (invoke = instruction.asInvokeMethod()).lookupSingleTarget(this.appView, code.context())) == null || (optimizer = this.libraryMethodModelCollections.get(singleTarget.getHolderType())) == null) continue;
                if (invoke.hasUnusedOutValue() && !((DexEncodedMethod)singleTarget.getDefinition()).isInstanceInitializer() && !invoke.instructionMayHaveSideEffects(this.appView, code.context())) {
                    instructionIterator.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                LibraryMethodModelCollection.State optimizationState = optimizationStates.computeIfAbsent(optimizer, libraryMethodModelCollection -> libraryMethodModelCollection.createInitialState(methodProcessor));
                optimizer.optimize(code, blockIterator, instructionIterator, invoke, singleTarget, affectedValues, blocksToRemove, optimizationState, methodProcessingContext);
            }
        }
        code.removeBlocks(blocksToRemove);
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }
}

