/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.library.StatelessLibraryMethodModelCollection;
import com.android.tools.r8.shaking.ProguardConfiguration;
import java.util.Set;

public class LogMethodOptimizer
extends StatelessLibraryMethodModelCollection {
    private static final int VERBOSE = 2;
    private static final int DEBUG = 3;
    private static final int INFO = 4;
    private static final int WARN = 5;
    private static final int ERROR = 6;
    private static final int ASSERT = 7;
    private final AppView<?> appView;
    private final DexType logType;
    private final DexMethod isLoggableMethod;
    private final DexMethod vMethod;
    private final DexMethod dMethod;
    private final DexMethod iMethod;
    private final DexMethod wMethod;
    private final DexMethod eMethod;
    private final DexMethod wtfMethod;

    LogMethodOptimizer(AppView<?> appView) {
        DexType logType;
        this.appView = appView;
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        this.logType = logType = dexItemFactory.androidUtilLogType;
        this.isLoggableMethod = dexItemFactory.createMethod(logType, dexItemFactory.createProto(dexItemFactory.booleanType, dexItemFactory.stringType, dexItemFactory.intType), "isLoggable");
        this.vMethod = dexItemFactory.createMethod(logType, dexItemFactory.createProto(dexItemFactory.intType, dexItemFactory.stringType, dexItemFactory.stringType), "v");
        this.dMethod = dexItemFactory.createMethod(logType, dexItemFactory.createProto(dexItemFactory.intType, dexItemFactory.stringType, dexItemFactory.stringType), "d");
        this.iMethod = dexItemFactory.createMethod(logType, dexItemFactory.createProto(dexItemFactory.intType, dexItemFactory.stringType, dexItemFactory.stringType), "i");
        this.wMethod = dexItemFactory.createMethod(logType, dexItemFactory.createProto(dexItemFactory.intType, dexItemFactory.stringType, dexItemFactory.stringType), "w");
        this.eMethod = dexItemFactory.createMethod(logType, dexItemFactory.createProto(dexItemFactory.intType, dexItemFactory.stringType, dexItemFactory.stringType), "e");
        this.wtfMethod = dexItemFactory.createMethod(logType, dexItemFactory.createProto(dexItemFactory.intType, dexItemFactory.stringType, dexItemFactory.stringType), "wtf");
    }

    public static boolean isEnabled(AppView<?> appView) {
        ProguardConfiguration proguardConfiguration = appView.options().getProguardConfiguration();
        return proguardConfiguration != null && proguardConfiguration.getMaxRemovedAndroidLogLevel() >= 2;
    }

    private void replaceInvokeWithConstNumber(IRCode code, InstructionListIterator instructionIterator, InvokeMethod invoke, int value) {
        if (invoke.hasOutValue() && invoke.outValue().hasAnyUsers()) {
            instructionIterator.replaceCurrentInstructionWithConstInt(code, value);
        } else {
            instructionIterator.removeOrReplaceByDebugLocalRead();
        }
    }

    @Override
    public DexType getType() {
        return this.logType;
    }

    @Override
    public void optimize(IRCode code, BasicBlockIterator blockIterator, InstructionListIterator instructionIterator, InvokeMethod invoke, DexClassAndMethod singleTarget, Set<Value> affectedValues, Set<BasicBlock> blocksToRemove) {
        int maxRemovedAndroidLogLevel = this.appView.options().getProguardConfiguration().getMaxRemovedAndroidLogLevel();
        if (singleTarget.getReference() == this.isLoggableMethod) {
            Instruction definition;
            Value logLevelValue = invoke.arguments().get(1).getAliasedValue();
            if (!logLevelValue.isPhi() && !logLevelValue.hasLocalInfo() && (definition = logLevelValue.definition).isConstNumber()) {
                int logLevel = definition.asConstNumber().getIntValue();
                this.replaceInvokeWithConstNumber(code, instructionIterator, invoke, maxRemovedAndroidLogLevel >= logLevel ? 0 : 1);
            }
        } else if (singleTarget.getReference() == this.vMethod) {
            if (maxRemovedAndroidLogLevel >= 2) {
                this.replaceInvokeWithConstNumber(code, instructionIterator, invoke, 0);
            }
        } else if (singleTarget.getReference() == this.dMethod) {
            if (maxRemovedAndroidLogLevel >= 3) {
                this.replaceInvokeWithConstNumber(code, instructionIterator, invoke, 0);
            }
        } else if (singleTarget.getReference() == this.iMethod) {
            if (maxRemovedAndroidLogLevel >= 4) {
                this.replaceInvokeWithConstNumber(code, instructionIterator, invoke, 0);
            }
        } else if (singleTarget.getReference() == this.wMethod) {
            if (maxRemovedAndroidLogLevel >= 5) {
                this.replaceInvokeWithConstNumber(code, instructionIterator, invoke, 0);
            }
        } else if (singleTarget.getReference() == this.eMethod) {
            if (maxRemovedAndroidLogLevel >= 6) {
                this.replaceInvokeWithConstNumber(code, instructionIterator, invoke, 0);
            }
        } else if (singleTarget.getReference() == this.wtfMethod && maxRemovedAndroidLogLevel >= 7) {
            this.replaceInvokeWithConstNumber(code, instructionIterator, invoke, 0);
        }
    }
}

