/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.library.StatelessLibraryMethodModelCollection;
import java.util.Set;

public class ObjectMethodOptimizer
extends StatelessLibraryMethodModelCollection {
    private final DexItemFactory dexItemFactory;

    ObjectMethodOptimizer(AppView<?> appView) {
        this.dexItemFactory = appView.dexItemFactory();
    }

    private void optimizeGetClass(InstructionListIterator instructionIterator, InvokeMethod invoke) {
        if (!(invoke.hasOutValue() && invoke.outValue().hasAnyUsers() || !invoke.inValues().get(0).isNeverNull())) {
            instructionIterator.removeOrReplaceByDebugLocalRead();
        }
    }

    @Override
    public DexType getType() {
        return this.dexItemFactory.objectType;
    }

    @Override
    public void optimize(IRCode code, BasicBlockIterator blockIterator, InstructionListIterator instructionIterator, InvokeMethod invoke, DexClassAndMethod singleTarget, Set<Value> affectedValues, Set<BasicBlock> blocksToRemove) {
        if (singleTarget.getReference() == this.dexItemFactory.objectMembers.getClass) {
            this.optimizeGetClass(instructionIterator, invoke);
        }
    }
}

