/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.UtilityMethodsForCodeOptimizations;
import com.android.tools.r8.ir.optimize.library.LibraryMethodModelCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Reference2BooleanOpenHashMap;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ValueUtils;
import com.android.tools.r8.utils.WorkList;
import java.util.Set;

public class StringBuilderMethodOptimizer
implements LibraryMethodModelCollection<State> {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final InternalOptions options;
    private final DexItemFactory.StringBuildingMethods stringBuilderMethods;

    StringBuilderMethodOptimizer(AppView<?> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        this.appView = appView;
        this.dexItemFactory = dexItemFactory;
        this.options = appView.options();
        this.stringBuilderMethods = dexItemFactory.stringBuilderMethods;
    }

    private void optimizeAppend(InstructionListIterator instructionIterator, InvokeMethodWithReceiver invoke, DexClassAndMethod singleTarget, State state, CompilationContext.MethodProcessingContext methodProcessingContext) {
        boolean isStringBuilderUnused = state.isUnusedBuilder(invoke.getReceiver());
        if (invoke.hasOutValue() && (this.options.isGeneratingDex() || isStringBuilderUnused)) {
            invoke.outValue().replaceUsers(invoke.getReceiver());
            invoke.getReceiver().uniquePhiUsers().forEach(Phi::removeTrivialPhi);
            invoke.clearOutValue();
        }
        if (isStringBuilderUnused) {
            this.optimizeAppendOnUnusedStringBuilder(instructionIterator, invoke, singleTarget, state, methodProcessingContext);
        }
    }

    private void optimizeAppendOnUnusedStringBuilder(InstructionListIterator instructionIterator, InvokeMethodWithReceiver invoke, DexClassAndMethod singleTarget, State state, CompilationContext.MethodProcessingContext methodProcessingContext) {
        assert (!invoke.hasOutValue());
        DexMethod appendMethod = (DexMethod)singleTarget.getReference();
        if (this.stringBuilderMethods.isAppendPrimitiveMethod(appendMethod) || this.stringBuilderMethods.isAppendStringMethod(appendMethod)) {
            instructionIterator.removeOrReplaceByDebugLocalRead();
        } else if (this.stringBuilderMethods.isAppendObjectMethod(appendMethod)) {
            Value object = invoke.getArgument(1);
            if (object.isNeverNull()) {
                instructionIterator.replaceCurrentInstruction(((InvokeVirtual.Builder)((InvokeVirtual.Builder)InvokeVirtual.builder().setMethod(this.dexItemFactory.objectMembers.toString)).setSingleArgument(object)).build());
            } else if (this.options.canUseJavaUtilObjects()) {
                instructionIterator.replaceCurrentInstruction(((InvokeStatic.Builder)((InvokeStatic.Builder)InvokeStatic.builder().setMethod(this.dexItemFactory.objectsMethods.toStringWithObject)).setSingleArgument(object)).build());
                instructionIterator.previous();
            } else {
                UtilityMethodsForCodeOptimizations.UtilityMethodForCodeOptimizations toStringIfNotNullMethod = UtilityMethodsForCodeOptimizations.synthesizeToStringIfNotNullMethod(this.appView, methodProcessingContext);
                toStringIfNotNullMethod.optimize(state.methodProcessor);
                InvokeStatic replacement = ((InvokeStatic.Builder)((InvokeStatic.Builder)InvokeStatic.builder().setMethod(toStringIfNotNullMethod.getMethod())).setSingleArgument(object)).build();
                instructionIterator.replaceCurrentInstruction(replacement);
            }
        }
    }

    private void optimizeToString(InstructionListIterator instructionIterator, InvokeMethodWithReceiver invoke) {
        if (!(!ValueUtils.isNonNullStringBuilder(invoke.getReceiver(), this.dexItemFactory) || invoke.hasOutValue() && invoke.outValue().hasNonDebugUsers())) {
            instructionIterator.removeOrReplaceByDebugLocalRead();
        }
    }

    @Override
    public State createInitialState(MethodProcessor methodProcessor) {
        return new State(methodProcessor);
    }

    @Override
    public DexType getType() {
        return this.dexItemFactory.stringBuilderType;
    }

    @Override
    public void optimize(IRCode code, BasicBlockIterator blockIterator, InstructionListIterator instructionIterator, InvokeMethod invoke, DexClassAndMethod singleTarget, Set<Value> affectedValues, Set<BasicBlock> blocksToRemove, State state, CompilationContext.MethodProcessingContext methodProcessingContext) {
        if (invoke.isInvokeMethodWithReceiver()) {
            InvokeMethodWithReceiver invokeWithReceiver = invoke.asInvokeMethodWithReceiver();
            if (this.stringBuilderMethods.isAppendMethod((DexMethod)singleTarget.getReference())) {
                this.optimizeAppend(instructionIterator, invokeWithReceiver, singleTarget, state, methodProcessingContext);
            } else if (singleTarget.getReference() == this.dexItemFactory.stringBuilderMethods.toString) {
                this.optimizeToString(instructionIterator, invokeWithReceiver);
            }
        }
    }

    class State
    implements LibraryMethodModelCollection.State {
        final MethodProcessor methodProcessor;
        final Reference2BooleanMap<Value> unusedBuilders = new Reference2BooleanOpenHashMap<Value>();

        State(MethodProcessor methodProcessor) {
            this.methodProcessor = methodProcessor;
        }

        private void computeIsUnusedBuilder(Value value) {
            assert (!this.unusedBuilders.containsKey(value));
            Set<Value> aliases = Sets.newIdentityHashSet();
            boolean isUnused = this.computeAllAliasesIfUnusedStringBuilder(value, aliases);
            aliases.forEach(alias -> this.unusedBuilders.put((Value)alias, isUnused));
        }

        private boolean computeAllAliasesIfUnusedStringBuilder(Value value, Set<Value> aliases) {
            WorkList<Value> worklist = WorkList.newIdentityWorkList(value);
            while (worklist.hasNext()) {
                Value alias = worklist.next();
                aliases.add(alias);
                if (this.unusedBuilders.containsKey(alias)) {
                    assert (!this.unusedBuilders.getBoolean(alias));
                    return false;
                }
                if (alias.hasPhiUsers()) {
                    return false;
                }
                if (alias.isPhi()) {
                    return false;
                }
                Instruction definition = alias.definition;
                switch (definition.opcode()) {
                    case 9: {
                        worklist.addIfNotSeen(definition.inValues());
                        break;
                    }
                    case 49: {
                        assert (definition.asNewInstance().clazz == ((StringBuilderMethodOptimizer)StringBuilderMethodOptimizer.this).dexItemFactory.stringBuilderType);
                        break;
                    }
                    case 40: {
                        InvokeVirtual invoke = definition.asInvokeVirtual();
                        if (!StringBuilderMethodOptimizer.this.stringBuilderMethods.isAppendMethod(invoke.getInvokedMethod())) {
                            return false;
                        }
                        worklist.addIfNotSeen(invoke.getReceiver());
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                block13: for (Instruction user : alias.uniqueUsers()) {
                    switch (user.opcode()) {
                        case 9: {
                            worklist.addIfNotSeen(user.outValue());
                            break;
                        }
                        case 25: {
                            break;
                        }
                        case 33: {
                            InvokeMethod invoke = user.asInvokeDirect();
                            if (invoke.arguments().lastIndexOf(alias) > 0) {
                                return false;
                            }
                            if (StringBuilderMethodOptimizer.this.stringBuilderMethods.isConstructorMethod(invoke.getInvokedMethod())) continue block13;
                            return false;
                        }
                        case 38: {
                            InvokeMethod invoke = user.asInvokeStatic();
                            DexMethod invokedMethod = invoke.getInvokedMethod();
                            if (invokedMethod == ((StringBuilderMethodOptimizer)StringBuilderMethodOptimizer.this).dexItemFactory.objectsMethods.toStringWithObject || invokedMethod == ((StringBuilderMethodOptimizer)StringBuilderMethodOptimizer.this).dexItemFactory.stringMembers.valueOf) {
                                if (!invoke.hasOutValue() || !invoke.outValue().hasNonDebugUsers()) continue block13;
                                return false;
                            }
                            return false;
                        }
                        case 40: {
                            InvokeMethod invoke = user.asInvokeVirtual();
                            if (invoke.arguments().lastIndexOf(alias) > 0) {
                                return false;
                            }
                            DexMethod invokedMethod = invoke.getInvokedMethod();
                            if (StringBuilderMethodOptimizer.this.stringBuilderMethods.isAppendMethod(invokedMethod)) {
                                if (!invoke.hasOutValue()) continue block13;
                                worklist.addIfNotSeen(invoke.outValue());
                                break;
                            }
                            if (invokedMethod == ((StringBuilderMethodOptimizer)StringBuilderMethodOptimizer.this).dexItemFactory.objectMembers.toString || invokedMethod == ((StringBuilderMethodOptimizer)StringBuilderMethodOptimizer.this).stringBuilderMethods.toString) {
                                if (!invoke.hasOutValue() || !invoke.outValue().hasNonDebugUsers()) continue block13;
                                return false;
                            }
                            return false;
                        }
                        default: {
                            return false;
                        }
                    }
                }
            }
            return true;
        }

        boolean isUnusedBuilder(Value value) {
            if (!this.unusedBuilders.containsKey(value)) {
                this.computeIsUnusedBuilder(value);
                assert (this.unusedBuilders.containsKey(value));
            }
            return this.unusedBuilders.getBoolean(value);
        }
    }
}

