/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.library.sideeffects;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.List;

public class JavaLangObjectsSideEffectCollection {
    public static boolean toStringMayHaveSideEffects(AppView<?> appView, List<Value> arguments) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        TypeElement type = arguments.get(0).getType();
        if (type.isArrayType() || type.isNullType()) {
            return false;
        }
        assert (type.isClassType());
        DexType classType = type.asClassType().getClassType();
        DexMethod toStringMethodReference = dexItemFactory.objectMembers.toString.withHolder(classType, dexItemFactory);
        if (appView.getLibraryMethodSideEffectModelCollection().isSideEffectFreeFinalMethod(toStringMethodReference, arguments)) {
            return false;
        }
        if (((AppInfo)appView.appInfo()).hasLiveness()) {
            MethodResolutionResult.SingleResolutionResult resolutionResult;
            AppInfoWithLiveness appInfo = ((AppInfo)appView.appInfo()).withLiveness();
            if (appInfo.isAssumeNoSideEffectsMethod(toStringMethodReference)) {
                return false;
            }
            DexClass clazz = appInfo.definitionFor(classType);
            if (clazz != null && clazz.isEffectivelyFinal(appView) && (resolutionResult = appInfo.resolveMethodOn(clazz, toStringMethodReference).asSingleResolution()) != null && !resolutionResult.getResolvedMethod().getOptimizationInfo().mayHaveSideEffects()) {
                return false;
            }
        }
        return true;
    }
}

