/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.LinearFlowInstructionListIterator;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.DupDupDupPeephole;
import com.android.tools.r8.ir.optimize.peepholes.LoadLoadDupPeephole;
import com.android.tools.r8.ir.optimize.peepholes.MoveLoadUpPeephole;
import com.android.tools.r8.ir.optimize.peepholes.RemoveDebugPositionPeephole;
import com.android.tools.r8.ir.optimize.peepholes.StoreLoadPeephole;
import com.android.tools.r8.ir.optimize.peepholes.StoreLoadToDupStorePeephole;
import com.android.tools.r8.ir.optimize.peepholes.StoreSequenceLoadPeephole;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IteratorUtils;
import com.android.tools.r8.utils.PredicateUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Predicate;

public class BasicBlockMuncher {
    private static List<BasicBlockPeephole> nonDestructivePeepholes() {
        return ImmutableList.of(new RemoveDebugPositionPeephole(), new MoveLoadUpPeephole(), new StoreLoadPeephole());
    }

    private static List<BasicBlockPeephole> destructivePeepholes() {
        return ImmutableList.of(new StoreSequenceLoadPeephole(), new StoreLoadPeephole(), new LoadLoadDupPeephole(), new DupDupDupPeephole(), new StoreLoadToDupStorePeephole());
    }

    public static void optimize(IRCode code, InternalOptions options) {
        BasicBlockMuncher.runPeepholes(code, BasicBlockMuncher.nonDestructivePeepholes(), options);
        BasicBlockMuncher.runPeepholes(code, BasicBlockMuncher.destructivePeepholes(), options);
    }

    /*
     * Unable to fully structure code
     */
    private static void runPeepholes(IRCode code, List<BasicBlockPeephole> peepholes, InternalOptions options) {
        blocksIterator = code.listIterator(code.blocks.size());
        iterations = 0;
        while (blocksIterator.hasPrevious()) {
            currentBlock = (BasicBlock)blocksIterator.previous();
            it = new LinearFlowInstructionListIterator(code, currentBlock, currentBlock.getInstructions().size());
            matched = false;
            while (true) lbl-1000:
            // 5 sources

            {
                for (BasicBlockPeephole peepHole : peepholes) {
                    localMatch = peepHole.match(it);
                    if (localMatch && peepHole.resetAfterMatch()) {
                        it = new LinearFlowInstructionListIterator(code, currentBlock, currentBlock.getInstructions().size());
                        continue;
                    }
                    matched |= localMatch;
                }
                if (it.hasPrevious()) {
                    if (options.testing.basicBlockMuncherIterationLimit != InternalOptions.TestingOptions.NO_LIMIT) {
                        if (iterations > options.testing.basicBlockMuncherIterationLimit) {
                            throw new CompilationError("Too many iterations in BasicBlockMuncher");
                        }
                        ++iterations;
                    }
                    it.previous();
                    ** continue;
                }
                if (!matched) break;
                matched = false;
                it = new LinearFlowInstructionListIterator(code, currentBlock, currentBlock.getInstructions().size());
            }
            if (IteratorUtils.previousUntilUnsafe(blocksIterator, PredicateUtils.not((Predicate<BasicBlock>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, hasVisitedBlock(com.android.tools.r8.ir.code.BasicBlock ), (Lcom/android/tools/r8/ir/code/BasicBlock;)Z)((LinearFlowInstructionListIterator)it))) == null) continue;
            blocksIterator.next();
        }
    }
}

