/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.peepholes;

import com.android.tools.r8.ir.code.DebugPosition;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.optimize.peepholes.BasicBlockPeephole;
import com.android.tools.r8.ir.optimize.peepholes.Match;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeLayout;
import com.android.tools.r8.ir.optimize.peepholes.Point;

public class RemoveDebugPositionPeephole
implements BasicBlockPeephole {
    private final Point debugPositionExp = new Point(Instruction::isDebugPosition);
    private final Point secondInstructionExp = new Point(Instruction::isConstInstruction);
    private final PeepholeLayout layout = PeepholeLayout.lookForward(this.debugPositionExp, this.secondInstructionExp);

    @Override
    public boolean match(InstructionListIterator it) {
        Instruction next;
        Match match = this.layout.test(it);
        if (match == null) {
            return false;
        }
        DebugPosition debugPosition = this.debugPositionExp.get(match).asDebugPosition();
        Instruction secondInstruction = this.secondInstructionExp.get(match);
        Position position = debugPosition.getPosition();
        if (position.equals(secondInstruction.getPosition())) {
            it.removeOrReplaceByDebugLocalRead();
            return true;
        }
        boolean movedPosition = false;
        it.next();
        Instruction current = (Instruction)it.next();
        assert (current == secondInstruction);
        while (current.isConstInstruction() && it.hasNext() && (next = (Instruction)it.next()).getPosition().equals(current.getPosition())) {
            movedPosition = true;
            current.forceOverwritePosition(position);
            current = next;
        }
        it.previousUntil(i -> i == debugPosition);
        if (movedPosition) {
            it.next();
            it.removeOrReplaceByDebugLocalRead();
            return true;
        }
        return false;
    }

    @Override
    public boolean resetAfterMatch() {
        return false;
    }
}

