/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.typechecks;

import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import com.android.tools.r8.utils.collections.SortedProgramMethodSet;

public class CheckCastAndInstanceOfMethodSpecialization {
    private static final OptimizationFeedbackSimple feedback = OptimizationFeedbackSimple.getInstance();
    private final AppView<AppInfoWithLiveness> appView;
    private final IRConverter converter;
    private final SortedProgramMethodSet candidatesForInstanceOfOptimization = SortedProgramMethodSet.create();

    public CheckCastAndInstanceOfMethodSpecialization(AppView<AppInfoWithLiveness> appView, IRConverter converter) {
        assert (!appView.options().debug);
        this.appView = appView;
        this.converter = converter;
    }

    private boolean isCandidateForInstanceOfOptimization(ProgramMethod method, AbstractValue abstractReturnValue) {
        return ((DexMethod)method.getReference()).getReturnType().isBooleanType() && abstractReturnValue.isSingleBoolean();
    }

    private void processCandidateForInstanceOfOptimization(ProgramMethod method, MethodProcessor methodProcessor) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        if (!definition.isNonPrivateVirtualMethod()) {
            return;
        }
        MethodOptimizationInfo optimizationInfo = ((DexEncodedMethod)method.getDefinition()).getOptimizationInfo();
        if (optimizationInfo.mayHaveSideEffects()) {
            return;
        }
        AbstractValue abstractReturnValue = optimizationInfo.getAbstractReturnValue();
        if (!abstractReturnValue.isSingleBoolean()) {
            return;
        }
        ProgramMethod parentMethod = this.resolveOnSuperClass(method);
        if (parentMethod == null || !((DexEncodedMethod)parentMethod.getDefinition()).isNonPrivateVirtualMethod()) {
            return;
        }
        MethodOptimizationInfo parentOptimizationInfo = ((DexEncodedMethod)parentMethod.getDefinition()).getOptimizationInfo();
        if (parentOptimizationInfo.mayHaveSideEffects()) {
            return;
        }
        AbstractValue abstractParentReturnValue = parentOptimizationInfo.getAbstractReturnValue();
        if (!abstractParentReturnValue.isSingleBoolean()) {
            return;
        }
        assert (!this.appView.appInfo().isPinned(method.getReference()));
        assert (!this.appView.appInfo().isPinned(parentMethod.getReference()));
        if (this.appView.appInfo().getObjectAllocationInfoCollection().hasInstantiatedStrictSubtype(method.getHolder())) {
            return;
        }
        DexEncodedMethod parentMethodDefinition = (DexEncodedMethod)parentMethod.getDefinition();
        if (abstractParentReturnValue != abstractReturnValue) {
            if (AccessControl.isClassAccessible(method.getHolder(), parentMethod, this.appView).isTrue()) {
                parentMethod.setCode(parentMethodDefinition.buildInstanceOfCode(method.getHolderType(), abstractParentReturnValue.isTrue(), this.appView.options()), this.appView);
                IRCode code = parentMethodDefinition.getCode().buildIR(parentMethod, this.appView, parentMethod.getOrigin());
                this.converter.markProcessed(code, feedback);
                feedback.fixupUnusedArguments(parentMethod, unusedArguments -> unusedArguments.clear(0));
                feedback.unsetAbstractReturnValue(parentMethod);
                feedback.unsetClassInlinerMethodConstraint(parentMethod);
            } else {
                return;
            }
        }
        this.appView.withArgumentPropagator(argumentPropagator -> argumentPropagator.transferArgumentInformation(method, parentMethod));
        feedback.unsetInlinedIntoSingleCallSite(parentMethod);
        methodProcessor.getCallSiteInformation().unsetCallSiteInformation(parentMethod);
        method.getHolder().removeMethod((DexMethod)method.getReference());
        this.converter.onMethodPruned(method);
    }

    private ProgramMethod resolveOnSuperClass(ProgramMethod method) {
        DexProgramClass superClass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(method.getHolder().superType));
        if (superClass == null) {
            return null;
        }
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOn((DexClass)superClass, (DexMethod)method.getReference()).asSingleResolution();
        if (resolutionResult == null) {
            return null;
        }
        return resolutionResult.getResolvedProgramMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCandidateForOptimization(ProgramMethod method, AbstractValue abstractReturnValue, MethodProcessor methodProcessor) {
        if (!this.converter.isInWave()) {
            return;
        }
        assert (methodProcessor.isPrimaryMethodProcessor());
        if (this.isCandidateForInstanceOfOptimization(method, abstractReturnValue)) {
            CheckCastAndInstanceOfMethodSpecialization checkCastAndInstanceOfMethodSpecialization = this;
            synchronized (checkCastAndInstanceOfMethodSpecialization) {
                if (this.candidatesForInstanceOfOptimization.isEmpty()) {
                    this.converter.addWaveDoneAction(() -> this.execute(methodProcessor));
                }
                this.candidatesForInstanceOfOptimization.add(method);
            }
        }
    }

    public void execute(MethodProcessor methodProcessor) {
        assert (!this.candidatesForInstanceOfOptimization.isEmpty());
        ProgramMethodSet processed = ProgramMethodSet.create();
        for (ProgramMethod method : this.candidatesForInstanceOfOptimization) {
            if (processed.contains(method)) continue;
            this.processCandidateForInstanceOfOptimization(method, methodProcessor);
        }
    }
}

