/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.ir.regalloc.RegisterPositions;
import java.util.BitSet;

public class RegisterPositionsWithExtraBlockedRegisters
extends RegisterPositions {
    private final RegisterPositions positions;
    private final BitSet extraBlockedRegisters;

    public RegisterPositionsWithExtraBlockedRegisters(RegisterPositions positions) {
        this.positions = positions;
        this.extraBlockedRegisters = new BitSet(positions.getLimit());
    }

    @Override
    public boolean hasType(int index, RegisterPositions.Type type) {
        assert (!this.isBlockedTemporarily(index));
        return this.positions.hasType(index, type);
    }

    @Override
    public void set(int index, int value, LiveIntervals intervals) {
        this.positions.set(index, value, intervals);
    }

    @Override
    public int get(int index) {
        assert (!this.isBlockedTemporarily(index));
        return this.positions.get(index);
    }

    @Override
    public int getLimit() {
        return this.positions.getLimit();
    }

    @Override
    public void setBlocked(int index) {
        this.positions.setBlocked(index);
    }

    public void setBlockedTemporarily(int index) {
        this.extraBlockedRegisters.set(index);
    }

    @Override
    public boolean isBlocked(int index) {
        return this.positions.isBlocked(index) || this.isBlockedTemporarily(index);
    }

    public boolean isBlockedTemporarily(int index) {
        return this.extraBlockedRegisters.get(index);
    }
}

