/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.synthetic;

import com.android.tools.r8.cf.code.CfConstNull;
import com.android.tools.r8.cf.code.CfConstNumber;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfFrame;
import com.android.tools.r8.cf.code.CfIf;
import com.android.tools.r8.cf.code.CfIfCmp;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLabel;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStaticFieldRead;
import com.android.tools.r8.cf.code.CfStaticFieldWrite;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.ir.optimize.enums.EnumInstanceFieldData;
import com.android.tools.r8.ir.synthetic.SyntheticCfCodeProvider;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.utils.collections.ImmutableDeque;
import com.android.tools.r8.utils.collections.ImmutableInt2ReferenceSortedMap;
import java.util.ArrayList;
import java.util.List;

public abstract class EnumUnboxingCfCodeProvider
extends SyntheticCfCodeProvider {
    EnumUnboxingCfCodeProvider(AppView<?> appView, DexType holder) {
        super(appView, holder);
    }

    void addCfInstructionsForAbstractValue(List<CfInstruction> instructions, AbstractValue value, DexType returnType) {
        if (value.isSingleStringValue()) {
            assert (returnType == this.appView.dexItemFactory().stringType);
            instructions.add(new CfConstString(value.asSingleStringValue().getDexString()));
        } else if (value.isSingleNumberValue()) {
            instructions.add(new CfConstNumber(value.asSingleNumberValue().getValue(), ValueType.fromDexType(returnType)));
        } else {
            throw new Unreachable("Only Number and String fields in enums are supported.");
        }
    }

    public static class EnumUnboxingValuesCfCodeProvider
    extends EnumUnboxingCfCodeProvider {
        private final DexField utilityField;
        private final int numEnumInstances;
        private final DexMethod initializationMethod;

        public EnumUnboxingValuesCfCodeProvider(AppView<?> appView, DexType holder, DexField utilityField, int numEnumInstances, DexMethod initializationMethod) {
            super(appView, holder);
            assert (utilityField.type == appView.dexItemFactory().intArrayType);
            this.utilityField = utilityField;
            this.numEnumInstances = numEnumInstances;
            this.initializationMethod = initializationMethod;
        }

        @Override
        public CfCode generateCfCode() {
            ArrayList<CfInstruction> instructions = new ArrayList<CfInstruction>();
            CfLabel nullDest = new CfLabel();
            instructions.add(new CfStaticFieldRead(this.utilityField, this.utilityField));
            instructions.add(new CfIf(If.Type.NE, ValueType.OBJECT, nullDest));
            instructions.add(new CfConstNumber(this.numEnumInstances, ValueType.INT));
            assert (this.initializationMethod.getArity() == 1);
            instructions.add(new CfInvoke(184, this.initializationMethod, false));
            instructions.add(new CfStaticFieldWrite(this.utilityField, this.utilityField));
            instructions.add(nullDest);
            instructions.add(new CfFrame((Int2ReferenceSortedMap<CfFrame.FrameType>)ImmutableInt2ReferenceSortedMap.builder().build(), ImmutableDeque.of(new CfFrame.FrameType[0])));
            instructions.add(new CfStaticFieldRead(this.utilityField, this.utilityField));
            instructions.add(new CfReturn(ValueType.OBJECT));
            return this.standardCfCodeFromInstructions(instructions);
        }
    }

    public static class EnumUnboxingValueOfCfCodeProvider
    extends EnumUnboxingCfCodeProvider {
        private final DexType enumType;
        private final EnumInstanceFieldData.EnumInstanceFieldMappingData fieldDataMap;

        public EnumUnboxingValueOfCfCodeProvider(AppView<?> appView, DexType holder, DexType enumType, EnumInstanceFieldData.EnumInstanceFieldMappingData fieldDataMap) {
            super(appView, holder);
            this.enumType = enumType;
            this.fieldDataMap = fieldDataMap;
        }

        @Override
        public CfCode generateCfCode() {
            DexItemFactory factory = this.appView.dexItemFactory();
            ArrayList<CfInstruction> instructions = new ArrayList<CfInstruction>();
            ImmutableInt2ReferenceSortedMap<CfFrame.FrameType> locals = ImmutableInt2ReferenceSortedMap.builder().put(0, CfFrame.FrameType.initialized(factory.stringType)).build();
            CfLabel nullDest = new CfLabel();
            instructions.add(new CfLoad(ValueType.fromDexType(factory.stringType), 0));
            instructions.add(new CfIf(If.Type.NE, ValueType.OBJECT, nullDest));
            instructions.add(new CfNew(factory.npeType));
            instructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Dup));
            instructions.add(new CfConstString(this.appView.dexItemFactory().createString("Name is null")));
            instructions.add(new CfInvoke(183, factory.npeMethods.initWithMessage, false));
            instructions.add(new CfThrow());
            instructions.add(nullDest);
            instructions.add(new CfFrame((Int2ReferenceSortedMap<CfFrame.FrameType>)locals, ImmutableDeque.of(new CfFrame.FrameType[0])));
            this.fieldDataMap.forEach((unboxedEnumValue, value) -> {
                CfLabel dest = new CfLabel();
                instructions.add(new CfLoad(ValueType.fromDexType(factory.stringType), 0));
                this.addCfInstructionsForAbstractValue((List<CfInstruction>)instructions, (AbstractValue)value, factory.stringType);
                instructions.add(new CfInvoke(182, factory.stringMembers.equals, false));
                instructions.add(new CfIf(If.Type.EQ, ValueType.INT, dest));
                instructions.add(new CfConstNumber(unboxedEnumValue.intValue(), ValueType.INT));
                instructions.add(new CfReturn(ValueType.INT));
                instructions.add(dest);
                instructions.add(new CfFrame((Int2ReferenceSortedMap<CfFrame.FrameType>)locals, ImmutableDeque.of(new CfFrame.FrameType[0])));
            });
            instructions.add(new CfNew(factory.illegalArgumentExceptionType));
            instructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Dup));
            instructions.add(new CfConstString(this.appView.dexItemFactory().createString("No enum constant " + this.enumType.toSourceString().replace('$', '.') + ".")));
            instructions.add(new CfLoad(ValueType.fromDexType(factory.stringType), 0));
            instructions.add(new CfInvoke(182, factory.stringMembers.concat, false));
            instructions.add(new CfInvoke(183, factory.illegalArgumentExceptionMethods.initWithMessage, false));
            instructions.add(new CfThrow());
            return this.standardCfCodeFromInstructions(instructions);
        }
    }

    public static class EnumUnboxingInstanceFieldCfCodeProvider
    extends EnumUnboxingCfCodeProvider {
        private final DexType returnType;
        private final EnumInstanceFieldData.EnumInstanceFieldMappingData fieldDataMap;
        private final AbstractValue nullValue;

        public EnumUnboxingInstanceFieldCfCodeProvider(AppView<?> appView, DexType holder, EnumDataMap.EnumData data2, DexField field) {
            this(appView, holder, data2, field, null);
        }

        public EnumUnboxingInstanceFieldCfCodeProvider(AppView<?> appView, DexType holder, EnumDataMap.EnumData data2, DexField field, AbstractValue nullValue) {
            super(appView, holder);
            this.returnType = field.getType();
            this.fieldDataMap = data2.getInstanceFieldData(field).asEnumFieldMappingData();
            this.nullValue = nullValue;
        }

        @Override
        public CfCode generateCfCode() {
            DexItemFactory factory = this.appView.dexItemFactory();
            ArrayList<CfInstruction> instructions = new ArrayList<CfInstruction>();
            ImmutableInt2ReferenceSortedMap<CfFrame.FrameType> locals = ImmutableInt2ReferenceSortedMap.builder().put(0, CfFrame.FrameType.initialized(factory.intType)).build();
            this.fieldDataMap.forEach((unboxedEnumValue, value) -> {
                CfLabel dest = new CfLabel();
                instructions.add(new CfLoad(ValueType.fromDexType(factory.intType), 0));
                instructions.add(new CfConstNumber(unboxedEnumValue.intValue(), ValueType.INT));
                instructions.add(new CfIfCmp(If.Type.NE, ValueType.INT, dest));
                this.addCfInstructionsForAbstractValue((List<CfInstruction>)instructions, (AbstractValue)value, this.returnType);
                instructions.add(new CfReturn(ValueType.fromDexType(this.returnType)));
                instructions.add(dest);
                instructions.add(new CfFrame((Int2ReferenceSortedMap<CfFrame.FrameType>)locals, ImmutableDeque.of(new CfFrame.FrameType[0])));
            });
            if (this.nullValue != null) {
                this.addCfInstructionsForAbstractValue(instructions, this.nullValue, this.returnType);
                instructions.add(new CfReturn(ValueType.fromDexType(this.returnType)));
            } else {
                instructions.add(new CfConstNull());
                instructions.add(new CfThrow());
            }
            return this.standardCfCodeFromInstructions(instructions);
        }
    }
}

