/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.synthetic;

import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.OptionalBool;
import java.util.List;
import java.util.function.Consumer;

public class FieldAccessorBuilder {
    private DexField field;
    private OptionalBool isInstanceField = OptionalBool.unknown();
    private OptionalBool isSetter = OptionalBool.unknown();
    private DexMethod sourceMethod;

    private FieldAccessorBuilder() {
    }

    public static FieldAccessorBuilder builder() {
        return new FieldAccessorBuilder();
    }

    private boolean isSetter() {
        return this.isSetter.isTrue();
    }

    private boolean isInstanceField() {
        return this.isInstanceField.isTrue();
    }

    private boolean validate() {
        assert (this.field != null);
        assert (!this.isInstanceField.isUnknown());
        assert (!this.isSetter.isUnknown());
        assert (this.sourceMethod != null);
        return true;
    }

    public FieldAccessorBuilder apply(Consumer<FieldAccessorBuilder> consumer) {
        consumer.accept(this);
        return this;
    }

    public FieldAccessorBuilder applyIf(boolean condition, Consumer<FieldAccessorBuilder> thenConsumer, Consumer<FieldAccessorBuilder> elseConsumer) {
        return this.apply(condition ? thenConsumer : elseConsumer);
    }

    public FieldAccessorBuilder setField(DexClassAndField field) {
        return field.getAccessFlags().isStatic() ? this.setStaticField((DexField)field.getReference()) : this.setInstanceField((DexField)field.getReference());
    }

    public FieldAccessorBuilder setGetter() {
        this.isSetter = OptionalBool.FALSE;
        return this;
    }

    public FieldAccessorBuilder setInstanceField(DexField field) {
        this.field = field;
        this.isInstanceField = OptionalBool.TRUE;
        return this;
    }

    public FieldAccessorBuilder setSetter() {
        this.isSetter = OptionalBool.TRUE;
        return this;
    }

    public FieldAccessorBuilder setSourceMethod(DexMethod sourceMethod) {
        this.sourceMethod = sourceMethod;
        return this;
    }

    public FieldAccessorBuilder setStaticField(DexField field) {
        this.field = field;
        this.isInstanceField = OptionalBool.FALSE;
        return this;
    }

    public CfCode build() {
        assert (this.validate());
        int maxStack = 0;
        int maxLocals = 0;
        ImmutableList.Builder instructions = ImmutableList.builder();
        if (this.isInstanceField()) {
            instructions.add(new CfLoad(ValueType.OBJECT, maxLocals));
            ++maxStack;
            ++maxLocals;
        }
        if (this.isSetter()) {
            ValueType fieldType = ValueType.fromDexType(this.field.getType());
            instructions.add(new CfLoad(fieldType, maxLocals));
            maxStack += fieldType.requiredRegisters();
            maxLocals += fieldType.requiredRegisters();
        }
        int opcode = 178 + BooleanUtils.intValue(this.isSetter()) + (this.isInstanceField.ordinal() << 1);
        instructions.add(CfFieldInstruction.create(opcode, this.field, this.field));
        if (this.isSetter()) {
            instructions.add(new CfReturnVoid());
        } else {
            ValueType fieldType = ValueType.fromDexType(this.field.getType());
            maxStack = Math.max(fieldType.requiredRegisters(), maxStack);
            instructions.add(new CfReturn(fieldType));
        }
        ImmutableList<CfTryCatch> tryCatchRanges = ImmutableList.of();
        ImmutableList<CfCode.LocalVariableInfo> localVariables = ImmutableList.of();
        return new CfCode(this.sourceMethod.getHolderType(), maxStack, maxLocals, (List<CfInstruction>)((Object)instructions.build()), tryCatchRanges, localVariables);
    }
}

