/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.synthetic;

import com.android.tools.r8.cf.code.CfCheckCast;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfTryCatch;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.ConsumerUtils;
import java.util.List;
import java.util.function.Consumer;

public class ForwardMethodBuilder {
    private final DexItemFactory factory;
    private DexMethod sourceMethod = null;
    private DexMethod targetMethod = null;
    private boolean sourceMethodHasExtraUnusedParameter = false;
    private boolean staticSource = false;
    private InvokeType invokeType = null;
    private Boolean isInterface = null;
    private boolean castResult = false;
    private boolean isConstructorDelegate = false;
    private AppInfoWithClassHierarchy appInfoForCastArguments = null;

    public static ForwardMethodBuilder builder(DexItemFactory factory) {
        return new ForwardMethodBuilder(factory);
    }

    private ForwardMethodBuilder(DexItemFactory factory) {
        this.factory = factory;
    }

    private void maybeInsertArgumentCast(int argumentIndex, DexType sourceArgumentType, ImmutableList.Builder<CfInstruction> instructions) {
        DexType targetArgumentType;
        if (this.appInfoForCastArguments == null) {
            return;
        }
        if (this.isStaticSource() != this.isStaticTarget()) {
            argumentIndex += this.isStaticSource() ? -1 : 1;
        }
        DexType dexType = targetArgumentType = argumentIndex == -1 ? this.targetMethod.holder : this.targetMethod.getParameters().values[argumentIndex];
        if (sourceArgumentType != targetArgumentType && targetArgumentType != this.appInfoForCastArguments.dexItemFactory().objectType) {
            assert (this.appInfoForCastArguments.isSubtype(targetArgumentType, sourceArgumentType));
            instructions.add((Object)new CfCheckCast(targetArgumentType));
        }
    }

    private int getInvokeOpcode() {
        switch (this.invokeType) {
            case STATIC: {
                return 184;
            }
            case VIRTUAL: {
                return 182;
            }
            case SPECIAL: {
                return 183;
            }
            case INTERFACE: {
                return 185;
            }
        }
        throw new Unreachable("Unexpected invoke type: " + (Object)((Object)this.invokeType));
    }

    private DexType[] getSourceParameters() {
        return this.sourceMethod.getParameters().values;
    }

    private boolean isSourceReturnVoid() {
        return this.sourceMethod.getReturnType().isVoidType();
    }

    private ValueType getSourceReturnType() {
        assert (!this.isSourceReturnVoid());
        return ValueType.fromDexType(this.sourceMethod.getReturnType());
    }

    private boolean isStaticSource() {
        return this.staticSource;
    }

    private boolean isStaticTarget() {
        return this.invokeType == InvokeType.STATIC;
    }

    private int sourceArguments() {
        return this.sourceMethod.getParameters().size() + (this.isStaticSource() ? 0 : 1) - BooleanUtils.intValue(this.sourceMethodHasExtraUnusedParameter);
    }

    private int targetArguments() {
        return this.targetMethod.getParameters().size() + (this.isStaticTarget() || this.isConstructorDelegate ? 0 : 1);
    }

    private boolean validate() {
        assert (this.sourceMethod != null);
        assert (this.targetMethod != null);
        assert (this.invokeType != null);
        assert (this.isInterface != null);
        assert (this.sourceArguments() == this.targetArguments());
        if (this.isConstructorDelegate) {
            assert (this.isStaticSource());
            assert (!this.sourceMethod.getReturnType().isVoidType());
            assert (this.targetMethod.getReturnType().isVoidType());
            assert (this.invokeType == InvokeType.SPECIAL);
        } else if (this.castResult && !this.sourceMethod.getReturnType().isVoidType() && !this.targetMethod.getReturnType().isVoidType() ? !$assertionsDisabled && ValueType.fromDexType(this.sourceMethod.getReturnType()) != ValueType.fromDexType(this.targetMethod.getReturnType()) : !$assertionsDisabled && this.sourceMethod.getReturnType() != this.targetMethod.getReturnType()) {
            throw new AssertionError();
        }
        return true;
    }

    public ForwardMethodBuilder apply(Consumer<ForwardMethodBuilder> fn) {
        fn.accept(this);
        return this;
    }

    public ForwardMethodBuilder applyIf(boolean condition, Consumer<ForwardMethodBuilder> thenConsumer) {
        return this.applyIf(condition, thenConsumer, ConsumerUtils.emptyConsumer());
    }

    public ForwardMethodBuilder applyIf(boolean condition, Consumer<ForwardMethodBuilder> thenConsumer, Consumer<ForwardMethodBuilder> elseConsumer) {
        if (condition) {
            thenConsumer.accept(this);
        } else {
            elseConsumer.accept(this);
        }
        return this;
    }

    public ForwardMethodBuilder setNonStaticSource(DexMethod method) {
        this.sourceMethod = method;
        this.staticSource = false;
        return this;
    }

    public ForwardMethodBuilder setNonStaticSourceWithExtraUnusedParameter(DexMethod method) {
        this.sourceMethod = method;
        this.staticSource = false;
        this.sourceMethodHasExtraUnusedParameter = true;
        return this;
    }

    public ForwardMethodBuilder setStaticSource(DexMethod method) {
        this.sourceMethod = method;
        this.staticSource = true;
        return this;
    }

    public ForwardMethodBuilder setStaticTarget(DexMethod method, boolean isInterface) {
        this.targetMethod = method;
        this.invokeType = InvokeType.STATIC;
        this.isInterface = isInterface;
        return this;
    }

    public ForwardMethodBuilder setSuperTarget(DexMethod method, boolean isInterface) {
        this.targetMethod = method;
        this.invokeType = InvokeType.SPECIAL;
        this.isInterface = isInterface;
        return this;
    }

    public ForwardMethodBuilder setVirtualTarget(DexMethod method, boolean isInterface) {
        this.targetMethod = method;
        this.invokeType = isInterface ? InvokeType.INTERFACE : InvokeType.VIRTUAL;
        this.isInterface = isInterface;
        return this;
    }

    public ForwardMethodBuilder setConstructorTarget(DexMethod method) {
        return this.setDirectTarget(method, false);
    }

    public ForwardMethodBuilder setDirectTarget(DexMethod method, boolean isInterface) {
        this.targetMethod = method;
        this.invokeType = InvokeType.SPECIAL;
        this.isInterface = isInterface;
        return this;
    }

    public ForwardMethodBuilder setCastResult() {
        this.castResult = true;
        return this;
    }

    public ForwardMethodBuilder setCastArguments(AppInfoWithClassHierarchy appInfo) {
        this.appInfoForCastArguments = appInfo;
        return this;
    }

    public ForwardMethodBuilder setConstructorTarget(DexMethod method, DexItemFactory factory) {
        assert (method.isInstanceInitializer(factory));
        this.targetMethod = method;
        this.isConstructorDelegate = true;
        this.invokeType = InvokeType.SPECIAL;
        this.isInterface = false;
        return this;
    }

    public CfCode build() {
        assert (this.validate());
        int maxStack = 0;
        int maxLocals = 0;
        ImmutableList.Builder<CfInstruction> instructions = ImmutableList.builder();
        if (this.isConstructorDelegate) {
            assert (this.isStaticSource());
            assert (this.invokeType == InvokeType.SPECIAL);
            instructions.add((Object)new CfNew(this.targetMethod.getHolderType()));
            instructions.add((Object)new CfStackInstruction(CfStackInstruction.Opcode.Dup));
            maxStack += 2;
        } else if (!this.isStaticSource()) {
            instructions.add((Object)new CfLoad(ValueType.OBJECT, maxLocals));
            this.maybeInsertArgumentCast(-1, this.sourceMethod.holder, instructions);
            ++maxStack;
            ++maxLocals;
        }
        DexType[] sourceParameters = this.getSourceParameters();
        for (int i = 0; i < sourceParameters.length; ++i) {
            DexType parameter = sourceParameters[i];
            ValueType parameterType = ValueType.fromDexType(parameter);
            if (!this.sourceMethodHasExtraUnusedParameter || i != sourceParameters.length - 1) {
                instructions.add((Object)new CfLoad(parameterType, maxLocals));
                this.maybeInsertArgumentCast(i, parameter, instructions);
            }
            maxStack += parameterType.requiredRegisters();
            maxLocals += parameterType.requiredRegisters();
        }
        instructions.add((Object)new CfInvoke(this.getInvokeOpcode(), this.targetMethod, this.isInterface));
        if (!this.targetMethod.getReturnType().isVoidType()) {
            maxStack = Math.max(maxStack, ValueType.fromDexType(this.targetMethod.getReturnType()).requiredRegisters());
        }
        if (this.isSourceReturnVoid()) {
            assert (!this.isConstructorDelegate);
            instructions.add((Object)new CfReturnVoid());
        } else {
            if (!this.isConstructorDelegate && this.sourceMethod.getReturnType() != this.targetMethod.getReturnType()) {
                assert (this.castResult);
                if (this.sourceMethod.getReturnType() != this.factory.objectType) {
                    instructions.add((Object)new CfCheckCast(this.sourceMethod.getReturnType()));
                }
            }
            instructions.add((Object)new CfReturn(this.getSourceReturnType()));
        }
        ImmutableList<CfTryCatch> tryCatchRanges = ImmutableList.of();
        ImmutableList<CfCode.LocalVariableInfo> localVariables = ImmutableList.of();
        return new CfCode(this.sourceMethod.holder, maxStack, maxLocals, (List<CfInstruction>)((Object)instructions.build()), tryCatchRanges, localVariables);
    }

    private static enum InvokeType {
        STATIC,
        VIRTUAL,
        INTERFACE,
        SPECIAL;

    }
}

