/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.it.unimi.dsi.fastutil.ints;

import com.android.tools.r8.it.unimi.dsi.fastutil.ints.AbstractInt2ShortMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ShortFunctions;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ShortMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSets;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSets;
import com.android.tools.r8.it.unimi.dsi.fastutil.shorts.ShortCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.shorts.ShortCollections;
import com.android.tools.r8.it.unimi.dsi.fastutil.shorts.ShortSets;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;

public class Int2ShortMaps {
    public static final EmptyMap EMPTY_MAP = new EmptyMap();

    private Int2ShortMaps() {
    }

    public static Int2ShortMap singleton(int key, short value) {
        return new Singleton(key, value);
    }

    public static Int2ShortMap singleton(Integer key, Short value) {
        return new Singleton(key, value);
    }

    public static Int2ShortMap synchronize(Int2ShortMap m3) {
        return new SynchronizedMap(m3);
    }

    public static Int2ShortMap synchronize(Int2ShortMap m3, Object sync) {
        return new SynchronizedMap(m3, sync);
    }

    public static Int2ShortMap unmodifiable(Int2ShortMap m3) {
        return new UnmodifiableMap(m3);
    }

    public static class UnmodifiableMap
    extends Int2ShortFunctions.UnmodifiableFunction
    implements Int2ShortMap,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Int2ShortMap map;
        protected transient ObjectSet<Int2ShortMap.Entry> entries;
        protected transient IntSet keys;
        protected transient ShortCollection values;

        protected UnmodifiableMap(Int2ShortMap m3) {
            super(m3);
            this.map = m3;
        }

        @Override
        public boolean containsValue(short v) {
            return this.map.containsValue(v);
        }

        @Override
        @Deprecated
        public boolean containsValue(Object ov) {
            return this.map.containsValue(ov);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public void putAll(Map<? extends Integer, ? extends Short> m3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSet<Int2ShortMap.Entry> int2ShortEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.unmodifiable(this.map.int2ShortEntrySet());
            }
            return this.entries;
        }

        @Override
        @Deprecated
        public ObjectSet<Map.Entry<Integer, Short>> entrySet() {
            return this.int2ShortEntrySet();
        }

        @Override
        public IntSet keySet() {
            if (this.keys == null) {
                this.keys = IntSets.unmodifiable(this.map.keySet());
            }
            return this.keys;
        }

        @Override
        public ShortCollection values() {
            if (this.values == null) {
                return ShortCollections.unmodifiable(this.map.values());
            }
            return this.values;
        }
    }

    public static class SynchronizedMap
    extends Int2ShortFunctions.SynchronizedFunction
    implements Int2ShortMap,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Int2ShortMap map;
        protected transient ObjectSet<Int2ShortMap.Entry> entries;
        protected transient IntSet keys;
        protected transient ShortCollection values;

        protected SynchronizedMap(Int2ShortMap m3, Object sync) {
            super(m3, sync);
            this.map = m3;
        }

        protected SynchronizedMap(Int2ShortMap m3) {
            super(m3);
            this.map = m3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s2) throws IOException {
            Object object = this.sync;
            synchronized (object) {
                s2.defaultWriteObject();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(short v) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(v);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public boolean containsValue(Object ov) {
            Object object = this.sync;
            synchronized (object) {
                return this.map.containsValue(ov);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends Integer, ? extends Short> m3) {
            Object object = this.sync;
            synchronized (object) {
                this.map.putAll(m3);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectSet<Int2ShortMap.Entry> int2ShortEntrySet() {
            Object object = this.sync;
            synchronized (object) {
                if (this.entries == null) {
                    this.entries = ObjectSets.synchronize(this.map.int2ShortEntrySet(), this.sync);
                }
                return this.entries;
            }
        }

        @Override
        @Deprecated
        public ObjectSet<Map.Entry<Integer, Short>> entrySet() {
            return this.int2ShortEntrySet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IntSet keySet() {
            Object object = this.sync;
            synchronized (object) {
                if (this.keys == null) {
                    this.keys = IntSets.synchronize(this.map.keySet(), this.sync);
                }
                return this.keys;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ShortCollection values() {
            Object object = this.sync;
            synchronized (object) {
                if (this.values == null) {
                    return ShortCollections.synchronize(this.map.values(), this.sync);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.sync;
            synchronized (object) {
                return this.map.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object object = this.sync;
            synchronized (object) {
                return this.map.equals(o);
            }
        }
    }

    public static class Singleton
    extends Int2ShortFunctions.Singleton
    implements Int2ShortMap,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected transient ObjectSet<Int2ShortMap.Entry> entries;
        protected transient IntSet keys;
        protected transient ShortCollection values;

        protected Singleton(int key, short value) {
            super(key, value);
        }

        @Override
        public boolean containsValue(short v) {
            return this.value == v;
        }

        @Override
        @Deprecated
        public boolean containsValue(Object ov) {
            return (Short)ov == this.value;
        }

        @Override
        public void putAll(Map<? extends Integer, ? extends Short> m3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSet<Int2ShortMap.Entry> int2ShortEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSets.singleton(new AbstractInt2ShortMap.BasicEntry(this.key, this.value));
            }
            return this.entries;
        }

        @Override
        @Deprecated
        public ObjectSet<Map.Entry<Integer, Short>> entrySet() {
            return this.int2ShortEntrySet();
        }

        @Override
        public IntSet keySet() {
            if (this.keys == null) {
                this.keys = IntSets.singleton(this.key);
            }
            return this.keys;
        }

        @Override
        public ShortCollection values() {
            if (this.values == null) {
                this.values = ShortSets.singleton(this.value);
            }
            return this.values;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            Map m3 = (Map)o;
            if (m3.size() != 1) {
                return false;
            }
            return m3.entrySet().iterator().next().equals(this.entrySet().iterator().next());
        }

        public String toString() {
            return "{" + this.key + "=>" + this.value + "}";
        }
    }

    public static class EmptyMap
    extends Int2ShortFunctions.EmptyFunction
    implements Int2ShortMap,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyMap() {
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }

        @Override
        public boolean containsValue(short v) {
            return false;
        }

        @Override
        @Deprecated
        public boolean containsValue(Object ov) {
            return false;
        }

        @Override
        public void putAll(Map<? extends Integer, ? extends Short> m3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSet<Int2ShortMap.Entry> int2ShortEntrySet() {
            return ObjectSets.EMPTY_SET;
        }

        @Override
        @Deprecated
        public ObjectSet<Map.Entry<Integer, Short>> entrySet() {
            return this.int2ShortEntrySet();
        }

        @Override
        public IntSet keySet() {
            return IntSets.EMPTY_SET;
        }

        @Override
        public ShortCollection values() {
            return ShortSets.EMPTY_SET;
        }

        @Override
        public Object clone() {
            return EMPTY_MAP;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map)) {
                return false;
            }
            return ((Map)o).isEmpty();
        }

        @Override
        public String toString() {
            return "{}";
        }
    }
}

