/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.it.unimi.dsi.fastutil.objects;

import com.android.tools.r8.it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.chars.CharCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.chars.CharIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.AbstractObject2CharFunction;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2CharMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractObject2CharMap<K>
extends AbstractObject2CharFunction<K>
implements Object2CharMap<K>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractObject2CharMap() {
    }

    @Override
    public boolean containsValue(char v) {
        return this.values().contains(v);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object ov) {
        if (ov == null) {
            return false;
        }
        return this.containsValue(((Character)ov).charValue());
    }

    @Override
    public boolean containsKey(Object k) {
        ObjectIterator i = this.object2CharEntrySet().iterator();
        while (i.hasNext()) {
            if (((Object2CharMap.Entry)i.next()).getKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends K, ? extends Character> m3) {
        int n = m3.size();
        Iterator<Map.Entry<K, Character>> i = m3.entrySet().iterator();
        if (m3 instanceof Object2CharMap) {
            while (n-- != 0) {
                Object2CharMap.Entry e = (Object2CharMap.Entry)i.next();
                this.put(e.getKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<K, Character> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ObjectSet<K> keySet() {
        return new AbstractObjectSet<K>(){

            @Override
            public boolean contains(Object k) {
                return AbstractObject2CharMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractObject2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2CharMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new AbstractObjectIterator<K>(){
                    final ObjectIterator<Map.Entry<K, Character>> i;
                    {
                        this.i = AbstractObject2CharMap.this.entrySet().iterator();
                    }

                    @Override
                    public K next() {
                        return ((Object2CharMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            @Override
            public boolean contains(char k) {
                return AbstractObject2CharMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractObject2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractObject2CharMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new AbstractCharIterator(){
                    final ObjectIterator<Map.Entry<K, Character>> i;
                    {
                        this.i = AbstractObject2CharMap.this.entrySet().iterator();
                    }

                    @Override
                    @Deprecated
                    public char nextChar() {
                        return ((Object2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    @Deprecated
    public ObjectSet<Map.Entry<K, Character>> entrySet() {
        return this.object2CharEntrySet();
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h2 += ((Map.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Object2CharMap.Entry e = (Object2CharMap.Entry)i.next();
            if (this == e.getKey()) {
                s2.append("(this map)");
            } else {
                s2.append(String.valueOf(e.getKey()));
            }
            s2.append("=>");
            s2.append(String.valueOf(e.getCharValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static class BasicEntry<K>
    implements Object2CharMap.Entry<K> {
        protected K key;
        protected char value;

        public BasicEntry(K key, Character value) {
            this.key = key;
            this.value = value.charValue();
        }

        public BasicEntry(K key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        @Deprecated
        public Character getValue() {
            return Character.valueOf(this.value);
        }

        @Override
        public char getCharValue() {
            return this.value;
        }

        @Override
        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Character setValue(Character value) {
            return Character.valueOf(this.setValue(value.charValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getValue() == null || !(e.getValue() instanceof Character)) {
                return false;
            }
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && this.value == ((Character)e.getValue()).charValue();
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

