/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.jar;

import com.android.tools.r8.ByteDataView;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.SourceFileEnvironment;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.debuginfo.DebugRepresentation;
import com.android.tools.r8.dex.ApplicationWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.errors.CodeSizeOverflowDiagnostic;
import com.android.tools.r8.errors.ConstantPoolOverflowDiagnostic;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.LensCodeRewriterUtils;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.org.objectweb.asm.AnnotationVisitor;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassTooLargeException;
import com.android.tools.r8.org.objectweb.asm.ClassWriter;
import com.android.tools.r8.org.objectweb.asm.FieldVisitor;
import com.android.tools.r8.org.objectweb.asm.MethodTooLargeException;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.org.objectweb.asm.tree.ClassNode;
import com.android.tools.r8.org.objectweb.asm.tree.MethodNode;
import com.android.tools.r8.org.objectweb.asm.util.CheckClassAdapter;
import com.android.tools.r8.org.objectweb.asm.util.Textifier;
import com.android.tools.r8.org.objectweb.asm.util.TraceMethodVisitor;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.AsmUtils;
import com.android.tools.r8.utils.ComparatorUtils;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LineNumberOptimizer;
import com.android.tools.r8.utils.OriginalSourceFiles;
import com.android.tools.r8.utils.PredicateUtils;
import com.android.tools.r8.utils.structural.Ordered;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;

public class CfApplicationWriter {
    private static final boolean RUN_VERIFIER = false;
    private static final boolean PRINT_CF = false;
    public static final int MARKER_STRING_CONSTANT_POOL_INDEX = 2;
    private static final CfVersion MIN_VERSION_FOR_COMPILER_GENERATED_CODE = CfVersion.V1_6;
    private final DexApplication application;
    private final AppView<?> appView;
    private final NamingLens namingLens;
    private final InternalOptions options;
    private final Marker marker;
    private final Predicate<DexType> isTypeMissing;

    public CfApplicationWriter(AppView<?> appView, Marker marker, NamingLens namingLens) {
        this.application = ((AppInfo)appView.appInfo()).app();
        this.appView = appView;
        this.namingLens = namingLens;
        this.options = appView.options();
        assert (marker != null);
        this.marker = marker;
        this.isTypeMissing = PredicateUtils.isNull(arg_0 -> appView.appInfo().definitionForWithoutExistenceAssert(arg_0));
    }

    private boolean includeMarker(Marker marker) {
        if (marker.isRelocator()) {
            return false;
        }
        assert (marker.isCfBackend() || marker.isDexBackend());
        if (this.options.desugarSpecificOptions().noCfMarkerForDesugaredCode) {
            return !marker.isCfBackend() || !marker.isDesugared();
        }
        return true;
    }

    private void writeApplication(AndroidApp inputApp, ClassFileConsumer consumer) {
        ProguardMapSupplier.ProguardMapId proguardMapId = null;
        if (this.options.proguardMapConsumer != null) {
            proguardMapId = LineNumberOptimizer.runAndWriteMap(inputApp, this.appView, this.namingLens, this.application.timing, OriginalSourceFiles.fromClasses(), DebugRepresentation.none(this.options));
            this.marker.setPgMapId(proguardMapId.getId());
        }
        Optional<String> markerString = this.includeMarker(this.marker) ? Optional.of(this.marker.toString()) : Optional.empty();
        SourceFileEnvironment sourceFileEnvironment = null;
        if (this.options.sourceFileProvider != null) {
            sourceFileEnvironment = ApplicationWriter.createSourceFileEnvironment(proguardMapId);
        }
        LensCodeRewriterUtils rewriter = new LensCodeRewriterUtils(this.appView);
        for (DexProgramClass clazz : this.application.classes()) {
            assert (SyntheticNaming.verifyNotInternalSynthetic(clazz.getType()));
            try {
                this.writeClass(clazz, consumer, rewriter, markerString, sourceFileEnvironment);
            }
            catch (ClassTooLargeException e) {
                throw this.appView.options().reporter.fatalError(new ConstantPoolOverflowDiagnostic(clazz.getOrigin(), Reference.classFromBinaryName(e.getClassName()), e.getConstantPoolCount()));
            }
            catch (MethodTooLargeException e) {
                throw this.appView.options().reporter.fatalError(new CodeSizeOverflowDiagnostic(clazz.getOrigin(), Reference.methodFromDescriptor(Reference.classFromBinaryName(e.getClassName()).getDescriptor(), e.getMethodName(), e.getDescriptor()), e.getCodeSize()));
            }
        }
        ApplicationWriter.supplyAdditionalConsumers(this.application, this.appView, this.namingLens, this.options);
    }

    private void writeClass(DexProgramClass clazz, ClassFileConsumer consumer, LensCodeRewriterUtils rewriter, Optional<String> markerString, SourceFileEnvironment sourceFileEnvironment) {
        int access;
        ClassWriter writer = new ClassWriter(0);
        if (markerString.isPresent()) {
            int markerStringPoolIndex = writer.newConst(markerString.get());
            assert (markerStringPoolIndex == 2);
        }
        String sourceFile = this.options.sourceFileProvider == null ? (clazz.sourceFile != null ? clazz.sourceFile.toString() : null) : this.options.sourceFileProvider.get(sourceFileEnvironment);
        String sourceDebug = this.getSourceDebugExtension(clazz.annotations());
        writer.visitSource(sourceFile, sourceDebug);
        CfVersion version = this.getClassFileVersion(clazz);
        if (version.isGreaterThanOrEqualTo(CfVersion.V1_8)) {
            clazz.accessFlags.unsetSuper();
        } else if (!clazz.accessFlags.isInterface()) {
            clazz.accessFlags.setSuper();
        }
        int n = access = this.options.testing.allowInvalidCfAccessFlags ? clazz.accessFlags.materialize() : clazz.accessFlags.getAsCfAccessFlags();
        if (clazz.isDeprecated()) {
            access = AsmUtils.withDeprecated(access);
        }
        String desc = this.namingLens.lookupDescriptor(clazz.type).toString();
        String name = this.namingLens.lookupInternalName(clazz.type);
        String signature = clazz.getClassSignature().toRenamedString(this.namingLens, this.isTypeMissing);
        String superName = clazz.type == this.options.itemFactory.objectType ? null : this.namingLens.lookupInternalName(clazz.superType);
        String[] interfaces = new String[clazz.interfaces.values.length];
        for (int i = 0; i < clazz.interfaces.values.length; ++i) {
            interfaces[i] = this.namingLens.lookupInternalName(clazz.interfaces.values[i]);
        }
        assert (SyntheticNaming.verifyNotInternalSynthetic(name));
        writer.visit(version.raw(), access, name, signature, superName, interfaces);
        this.appView.getSyntheticItems().writeAttributeIfIntermediateSyntheticClass(writer, clazz, this.appView);
        this.writeAnnotations(writer::visitAnnotation, clazz.annotations().annotations);
        ImmutableMap<DexString, DexValue> defaults = this.getAnnotationDefaults(clazz.annotations());
        if (clazz.getEnclosingMethodAttribute() != null) {
            clazz.getEnclosingMethodAttribute().write(writer, this.namingLens);
        }
        if (clazz.getNestHostClassAttribute() != null) {
            clazz.getNestHostClassAttribute().write(writer, this.namingLens);
        }
        for (NestMemberClassAttribute nestMemberClassAttribute : clazz.getNestMembersClassAttributes()) {
            nestMemberClassAttribute.write(writer, this.namingLens);
            assert (clazz.getNestHostClassAttribute() == null) : "A nest host cannot also be a nest member.";
        }
        if (clazz.isRecord()) {
            for (DexEncodedField dexEncodedField : clazz.instanceFields()) {
                String componentName = this.namingLens.lookupName((DexField)dexEncodedField.getReference()).toString();
                String componentDescriptor = this.namingLens.lookupDescriptor(((DexField)dexEncodedField.getReference()).type).toString();
                String componentSignature = dexEncodedField.getGenericSignature().toRenamedString(this.namingLens, this.isTypeMissing);
                writer.visitRecordComponent(componentName, componentDescriptor, componentSignature);
            }
        }
        for (InnerClassAttribute innerClassAttribute : clazz.getInnerClasses()) {
            innerClassAttribute.write(writer, this.namingLens, this.options);
        }
        for (DexEncodedField dexEncodedField : clazz.staticFields()) {
            this.writeField(dexEncodedField, writer);
        }
        for (DexEncodedField dexEncodedField : clazz.instanceFields()) {
            this.writeField(dexEncodedField, writer);
        }
        if (this.options.desugarSpecificOptions().sortMethodsOnCfOutput) {
            ArrayList programMethodSorted = new ArrayList();
            clazz.forEachProgramMethod(programMethodSorted::add);
            programMethodSorted.sort(this::compareMethodsThroughLens);
            programMethodSorted.forEach(method -> this.writeMethod((ProgramMethod)method, version, rewriter, writer, defaults));
        } else {
            clazz.forEachProgramMethod(method -> this.writeMethod((ProgramMethod)method, version, rewriter, writer, defaults));
        }
        writer.visitEnd();
        byte[] result = writer.toByteArray();
        ExceptionUtils.withConsumeResourceHandler(this.options.reporter, handler -> consumer.accept(ByteDataView.of(result), desc, (DiagnosticsHandler)handler));
    }

    private int compareTypesThroughLens(DexType a, DexType b) {
        return this.namingLens.lookupDescriptor(a).compareTo(this.namingLens.lookupDescriptor(b));
    }

    private DexString returnTypeThroughLens(DexMethod method) {
        return this.namingLens.lookupDescriptor(method.getReturnType());
    }

    private int compareMethodsThroughLens(ProgramMethod a, ProgramMethod b) {
        assert (a.getHolder().equals(b.getHolder()));
        return Comparator.comparing(this::returnTypeThroughLens).thenComparing(DexMember::getName).thenComparing(m3 -> m3.getProto().parameters.values, ComparatorUtils.arrayComparator(this::compareTypesThroughLens)).compare((DexMethod)a.getReference(), (DexMethod)b.getReference());
    }

    private CfVersion getClassFileVersion(DexEncodedMethod method) {
        if (!method.hasClassFileVersion()) {
            assert (this.options.isDesugaredLibraryCompilation() || this.options.cfToCfDesugar) : "Expected class file version for " + ((DexMethod)method.getReference()).toSourceString();
            assert (MIN_VERSION_FOR_COMPILER_GENERATED_CODE.isLessThan(this.options.classFileVersionAfterDesugaring(InternalOptions.SUPPORTED_CF_VERSION)));
            return this.options.cfToCfDesugar ? this.options.classFileVersionAfterDesugaring(InternalOptions.SUPPORTED_CF_VERSION) : MIN_VERSION_FOR_COMPILER_GENERATED_CODE;
        }
        return method.getClassFileVersion();
    }

    private CfVersion getClassFileVersion(DexProgramClass clazz) {
        CfVersion version = clazz.hasClassFileVersion() ? clazz.getInitialClassFileVersion() : MIN_VERSION_FOR_COMPILER_GENERATED_CODE;
        for (DexEncodedMethod method : clazz.directMethods()) {
            version = Ordered.max(version, this.getClassFileVersion(method));
        }
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            version = Ordered.max(version, this.getClassFileVersion(method));
        }
        return version;
    }

    private DexValue getSystemAnnotationValue(DexAnnotationSet annotations, DexType type) {
        DexAnnotation annotation = annotations.getFirstMatching(type);
        if (annotation == null) {
            return null;
        }
        assert (annotation.visibility == 2);
        DexEncodedAnnotation encodedAnnotation = annotation.annotation;
        assert (encodedAnnotation.elements.length == 1);
        return encodedAnnotation.elements[0].value;
    }

    private String getSourceDebugExtension(DexAnnotationSet annotations) {
        DexValue debugExtensions = this.getSystemAnnotationValue(annotations, this.application.dexItemFactory.annotationSourceDebugExtension);
        if (debugExtensions == null) {
            return null;
        }
        return ((DexString)debugExtensions.asDexValueString().getValue()).toString();
    }

    private ImmutableMap<DexString, DexValue> getAnnotationDefaults(DexAnnotationSet annotations) {
        DexValue value = this.getSystemAnnotationValue(annotations, this.application.dexItemFactory.annotationDefault);
        if (value == null) {
            return ImmutableMap.of();
        }
        DexEncodedAnnotation annotation = value.asDexValueAnnotation().value;
        ImmutableMap.Builder<DexString, DexValue> builder = ImmutableMap.builder();
        for (DexAnnotationElement element : annotation.elements) {
            builder.put(element.name, element.value);
        }
        return builder.build();
    }

    private String[] getExceptions(DexAnnotationSet annotations) {
        DexValue value = this.getSystemAnnotationValue(annotations, this.application.dexItemFactory.annotationThrows);
        if (value == null) {
            return null;
        }
        DexValue[] values2 = value.asDexValueArray().getValues();
        String[] res = new String[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            res[i] = this.namingLens.lookupInternalName((DexType)values2[i].asDexValueType().value);
        }
        return res;
    }

    private Object getStaticValue(DexEncodedField field) {
        if (!field.accessFlags.isStatic() || !field.hasExplicitStaticValue()) {
            return null;
        }
        return field.getStaticValue().asAsmEncodedObject();
    }

    private void writeField(DexEncodedField field, ClassWriter writer) {
        int access = field.accessFlags.getAsCfAccessFlags();
        if (field.isDeprecated()) {
            access = AsmUtils.withDeprecated(access);
        }
        String name = this.namingLens.lookupName((DexField)field.getReference()).toString();
        String desc = this.namingLens.lookupDescriptor(((DexField)field.getReference()).type).toString();
        String signature = field.getGenericSignature().toRenamedString(this.namingLens, this.isTypeMissing);
        Object value = this.getStaticValue(field);
        FieldVisitor visitor = writer.visitField(access, name, desc, signature, value);
        this.writeAnnotations(visitor::visitAnnotation, field.annotations().annotations);
        visitor.visitEnd();
    }

    private void writeMethod(ProgramMethod method, CfVersion classFileVersion, LensCodeRewriterUtils rewriter, ClassWriter writer, ImmutableMap<DexString, DexValue> defaults) {
        AnnotationVisitor defaultVisitor;
        NamingLens namingLens = this.namingLens;
        if (this.appView.isAlreadyLibraryDesugared(method.getHolder())) {
            namingLens = NamingLens.getIdentityLens();
        }
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        int access = definition.getAccessFlags().getAsCfAccessFlags();
        if (definition.isDeprecated()) {
            access = AsmUtils.withDeprecated(access);
        }
        String name = namingLens.lookupName((DexMethod)method.getReference()).toString();
        String desc = definition.descriptor(namingLens);
        String signature = ((DexEncodedMethod)method.getDefinition()).getGenericSignature().toRenamedString(namingLens, this.isTypeMissing);
        String[] exceptions = this.getExceptions(definition.annotations());
        MethodVisitor visitor = writer.visitMethod(access, name, desc, signature, exceptions);
        if (defaults.containsKey(definition.getName()) && (defaultVisitor = visitor.visitAnnotationDefault()) != null) {
            this.writeAnnotationElement(defaultVisitor, null, defaults.get(definition.getName()));
            defaultVisitor.visitEnd();
        }
        this.writeMethodParametersAnnotation(visitor, definition.annotations().annotations);
        this.writeAnnotations(visitor::visitAnnotation, definition.annotations().annotations);
        this.writeParameterAnnotations(visitor, definition.parameterAnnotationsList);
        if (!definition.shouldNotHaveCode()) {
            this.writeCode(method, classFileVersion, namingLens, rewriter, visitor);
        }
        visitor.visitEnd();
    }

    private void writeMethodParametersAnnotation(MethodVisitor visitor, DexAnnotation[] annotations) {
        for (DexAnnotation annotation : annotations) {
            if (annotation.annotation.type != this.appView.dexItemFactory().annotationMethodParameters) continue;
            assert (annotation.visibility == 2);
            assert (annotation.annotation.elements.length == 2);
            assert (annotation.annotation.elements[0].name.toString().equals("names"));
            assert (annotation.annotation.elements[1].name.toString().equals("accessFlags"));
            DexValue.DexValueArray names = annotation.annotation.elements[0].value.asDexValueArray();
            DexValue.DexValueArray accessFlags = annotation.annotation.elements[1].value.asDexValueArray();
            assert (names != null && accessFlags != null);
            assert (names.getValues().length == accessFlags.getValues().length);
            for (int i = 0; i < names.getValues().length; ++i) {
                DexValue.DexValueString name = names.getValues()[i].asDexValueString();
                DexValue.DexValueInt access = accessFlags.getValues()[i].asDexValueInt();
                visitor.visitParameter(((DexString)name.value).toString(), access.value);
            }
        }
    }

    private void writeParameterAnnotations(MethodVisitor visitor, ParameterAnnotationsList parameterAnnotations) {
        visitor.visitAnnotableParameterCount(parameterAnnotations.getAnnotableParameterCount(), true);
        visitor.visitAnnotableParameterCount(parameterAnnotations.getAnnotableParameterCount(), false);
        for (int i = 0; i < parameterAnnotations.size(); ++i) {
            int iFinal = i;
            this.writeAnnotations((d, vis) -> visitor.visitParameterAnnotation(iFinal, d, vis), parameterAnnotations.get((int)i).annotations);
        }
    }

    private void writeAnnotations(AnnotationConsumer visitor, DexAnnotation[] annotations) {
        for (DexAnnotation dexAnnotation : annotations) {
            if (dexAnnotation.visibility == 2) continue;
            AnnotationVisitor v = visitor.visit(this.namingLens.lookupDescriptor(dexAnnotation.annotation.type).toString(), dexAnnotation.visibility == 1);
            if (v == null) continue;
            this.writeAnnotation(v, dexAnnotation.annotation);
            v.visitEnd();
        }
    }

    private void writeAnnotation(AnnotationVisitor v, DexEncodedAnnotation annotation) {
        for (DexAnnotationElement element : annotation.elements) {
            this.writeAnnotationElement(v, element.name.toString(), element.value);
        }
    }

    private void writeAnnotationElement(AnnotationVisitor visitor, String name, DexValue value) {
        switch (value.getValueKind()) {
            case ANNOTATION: {
                DexValue.DexValueAnnotation valueAnnotation = value.asDexValueAnnotation();
                AnnotationVisitor innerVisitor = visitor.visitAnnotation(name, this.namingLens.lookupDescriptor(valueAnnotation.value.type).toString());
                if (innerVisitor == null) break;
                this.writeAnnotation(innerVisitor, valueAnnotation.value);
                innerVisitor.visitEnd();
                break;
            }
            case ARRAY: {
                DexValue[] values2 = value.asDexValueArray().getValues();
                AnnotationVisitor innerVisitor = visitor.visitArray(name);
                if (innerVisitor == null) break;
                for (DexValue elementValue : values2) {
                    this.writeAnnotationElement(innerVisitor, null, elementValue);
                }
                innerVisitor.visitEnd();
                break;
            }
            case ENUM: {
                DexField enumField = (DexField)value.asDexValueEnum().getValue();
                visitor.visitEnum(name, this.namingLens.lookupDescriptor(enumField.getType()).toString(), this.namingLens.lookupName(enumField).toString());
                break;
            }
            case FIELD: {
                throw new Unreachable("writeAnnotationElement of DexValueField");
            }
            case METHOD: {
                throw new Unreachable("writeAnnotationElement of DexValueMethod");
            }
            case METHOD_HANDLE: {
                throw new Unreachable("writeAnnotationElement of DexValueMethodHandle");
            }
            case METHOD_TYPE: {
                throw new Unreachable("writeAnnotationElement of DexValueMethodType");
            }
            case STRING: {
                visitor.visit(name, ((DexString)value.asDexValueString().getValue()).toString());
                break;
            }
            case TYPE: {
                visitor.visit(name, Type.getType(this.namingLens.lookupDescriptor((DexType)value.asDexValueType().value).toString()));
                break;
            }
            default: {
                visitor.visit(name, value.getBoxedValue());
            }
        }
    }

    private void writeCode(ProgramMethod method, CfVersion classFileVersion, NamingLens namingLens, LensCodeRewriterUtils rewriter, MethodVisitor visitor) {
        Code code = ((DexEncodedMethod)method.getDefinition()).getCode();
        assert (code.isCfWritableCode());
        code.asCfWritableCode().writeCf(method, classFileVersion, this.appView, namingLens, rewriter, visitor);
    }

    public static String printCf(byte[] result) {
        ClassReader reader = new ClassReader(result);
        ClassNode node = new ClassNode(589824);
        reader.accept(node, 589824);
        StringWriter writer = new StringWriter();
        for (MethodNode method : node.methods) {
            writer.append(method.name).append(method.desc).append('\n');
            TraceMethodVisitor visitor = new TraceMethodVisitor(new Textifier());
            method.accept(visitor);
            visitor.p.print(new PrintWriter(writer));
            writer.append('\n');
        }
        return writer.toString();
    }

    private static void verifyCf(byte[] result) {
        ClassReader reader = new ClassReader(result);
        PrintWriter pw = new PrintWriter(System.out);
        CheckClassAdapter.verify(reader, false, pw);
    }

    public void write(ClassFileConsumer consumer) {
        assert (this.options.proguardMapConsumer == null);
        this.write(consumer, null);
    }

    public void write(ClassFileConsumer consumer, AndroidApp inputApp) {
        this.application.timing.begin("CfApplicationWriter.write");
        try {
            this.writeApplication(inputApp, consumer);
        }
        finally {
            this.application.timing.end();
        }
    }

    private static interface AnnotationConsumer {
        public AnnotationVisitor visit(String var1, boolean var2);
    }
}

