/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmAnnotation;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmAnnotationArgument;
import com.android.tools.r8.kotlin.KotlinAnnotationInfo;
import com.android.tools.r8.kotlin.KotlinTypeReference;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

abstract class KotlinAnnotationArgumentInfo
implements EnqueuerMetadataTraceable {
    private static final Map<String, KotlinAnnotationArgumentInfo> EMPTY_ARGUMENTS = ImmutableMap.of();

    KotlinAnnotationArgumentInfo() {
    }

    private static KotlinAnnotationArgumentInfo createArgument(KmAnnotationArgument arg, DexItemFactory factory) {
        if (arg instanceof KmAnnotationArgument.KClassValue) {
            return KotlinAnnotationClassValueInfo.create((KmAnnotationArgument.KClassValue)arg, factory);
        }
        if (arg instanceof KmAnnotationArgument.EnumValue) {
            return KotlinAnnotationEnumValueInfo.create((KmAnnotationArgument.EnumValue)arg, factory);
        }
        if (arg instanceof KmAnnotationArgument.AnnotationValue) {
            return KotlinAnnotationAnnotationValueInfo.create((KmAnnotationArgument.AnnotationValue)arg, factory);
        }
        if (arg instanceof KmAnnotationArgument.ArrayValue) {
            return KotlinAnnotationArrayValueInfo.create((KmAnnotationArgument.ArrayValue)arg, factory);
        }
        return KotlinAnnotationPrimitiveArgumentInfo.create(arg);
    }

    static Map<String, KotlinAnnotationArgumentInfo> create(Map<String, KmAnnotationArgument> arguments, DexItemFactory factory) {
        if (arguments.isEmpty()) {
            return EMPTY_ARGUMENTS;
        }
        LinkedHashMap<String, KotlinAnnotationArgumentInfo> modeled = new LinkedHashMap<String, KotlinAnnotationArgumentInfo>();
        arguments.forEach((key, arg) -> modeled.put((String)key, KotlinAnnotationArgumentInfo.createArgument(arg, factory)));
        return modeled;
    }

    abstract boolean rewrite(Consumer<KmAnnotationArgument> var1, AppView<?> var2, NamingLens var3);

    private static class KotlinAnnotationPrimitiveArgumentInfo
    extends KotlinAnnotationArgumentInfo {
        private final KmAnnotationArgument argument;

        private KotlinAnnotationPrimitiveArgumentInfo(KmAnnotationArgument argument) {
            this.argument = argument;
        }

        private static KotlinAnnotationPrimitiveArgumentInfo create(KmAnnotationArgument argument) {
            return new KotlinAnnotationPrimitiveArgumentInfo(argument);
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
        }

        @Override
        boolean rewrite(Consumer<KmAnnotationArgument> consumer, AppView<?> appView, NamingLens namingLens) {
            consumer.accept(this.argument);
            return false;
        }
    }

    private static class KotlinAnnotationArrayValueInfo
    extends KotlinAnnotationArgumentInfo {
        private static final KotlinAnnotationArrayValueInfo EMPTY = new KotlinAnnotationArrayValueInfo(ImmutableList.of());
        private final List<KotlinAnnotationArgumentInfo> value;

        private KotlinAnnotationArrayValueInfo(List<KotlinAnnotationArgumentInfo> value) {
            this.value = value;
        }

        private static KotlinAnnotationArrayValueInfo create(KmAnnotationArgument.ArrayValue arg, DexItemFactory factory) {
            if (arg.getElements().isEmpty()) {
                return EMPTY;
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (KmAnnotationArgument argument : arg.getElements()) {
                builder.add(KotlinAnnotationArgumentInfo.createArgument(argument, factory));
            }
            return new KotlinAnnotationArrayValueInfo((List<KotlinAnnotationArgumentInfo>)((Object)builder.build()));
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
            for (KotlinAnnotationArgumentInfo kotlinAnnotationArgumentInfo : this.value) {
                kotlinAnnotationArgumentInfo.trace(definitionSupplier);
            }
        }

        @Override
        boolean rewrite(Consumer<KmAnnotationArgument> consumer, AppView<?> appView, NamingLens namingLens) {
            ArrayList rewrittenArguments = new ArrayList();
            boolean rewritten = false;
            for (KotlinAnnotationArgumentInfo kotlinAnnotationArgumentInfo : this.value) {
                rewritten |= kotlinAnnotationArgumentInfo.rewrite(rewrittenArg -> {
                    if (rewrittenArg != null) {
                        rewrittenArguments.add(rewrittenArg);
                    }
                }, appView, namingLens);
            }
            consumer.accept(new KmAnnotationArgument.ArrayValue(rewrittenArguments));
            return rewritten;
        }
    }

    private static class KotlinAnnotationAnnotationValueInfo
    extends KotlinAnnotationArgumentInfo {
        private final KotlinAnnotationInfo value;

        private KotlinAnnotationAnnotationValueInfo(KotlinAnnotationInfo value) {
            this.value = value;
        }

        private static KotlinAnnotationAnnotationValueInfo create(KmAnnotationArgument.AnnotationValue arg, DexItemFactory factory) {
            return new KotlinAnnotationAnnotationValueInfo(KotlinAnnotationInfo.create(arg.getAnnotation(), factory));
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
            this.value.trace(definitionSupplier);
        }

        @Override
        boolean rewrite(Consumer<KmAnnotationArgument> consumer, AppView<?> appView, NamingLens namingLens) {
            return this.value.rewrite((KmAnnotation rewrittenAnnotation) -> {
                if (rewrittenAnnotation != null) {
                    consumer.accept(new KmAnnotationArgument.AnnotationValue(rewrittenAnnotation));
                }
            }, appView, namingLens);
        }
    }

    private static class KotlinAnnotationEnumValueInfo
    extends KotlinAnnotationArgumentInfo {
        private final KotlinTypeReference enumClassName;
        private final String enumEntryName;

        private KotlinAnnotationEnumValueInfo(KotlinTypeReference enumClassName, String enumEntryName) {
            this.enumClassName = enumClassName;
            this.enumEntryName = enumEntryName;
        }

        private static KotlinAnnotationEnumValueInfo create(KmAnnotationArgument.EnumValue arg, DexItemFactory factory) {
            return new KotlinAnnotationEnumValueInfo(KotlinTypeReference.fromBinaryName(arg.getEnumClassName(), factory, arg.getEnumClassName()), arg.getEnumEntryName());
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
            this.enumClassName.trace(definitionSupplier);
        }

        @Override
        boolean rewrite(Consumer<KmAnnotationArgument> consumer, AppView<?> appView, NamingLens namingLens) {
            return this.enumClassName.toRenamedBinaryNameOrDefault(rewrittenEnumClassName -> consumer.accept(new KmAnnotationArgument.EnumValue((String)rewrittenEnumClassName, this.enumEntryName)), appView, namingLens, "kotlin/Any");
        }
    }

    private static class KotlinAnnotationClassValueInfo
    extends KotlinAnnotationArgumentInfo {
        private final KotlinTypeReference value;
        private final int arrayDimensionCount;

        private KotlinAnnotationClassValueInfo(KotlinTypeReference value, int arrayDimensionCount) {
            this.value = value;
            this.arrayDimensionCount = arrayDimensionCount;
        }

        private static KotlinAnnotationClassValueInfo create(KmAnnotationArgument.KClassValue arg, DexItemFactory factory) {
            return new KotlinAnnotationClassValueInfo(KotlinTypeReference.fromBinaryName(arg.getClassName(), factory, arg.getClassName()), arg.getArrayDimensionCount());
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
            this.value.trace(definitionSupplier);
        }

        @Override
        boolean rewrite(Consumer<KmAnnotationArgument> consumer, AppView<?> appView, NamingLens namingLens) {
            return this.value.toRenamedBinaryNameOrDefault(rewrittenValue -> consumer.accept(new KmAnnotationArgument.KClassValue((String)rewrittenValue, this.arrayDimensionCount)), appView, namingLens, "kotlin/Any");
        }
    }
}

