/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmClassifier;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeVisitor;
import com.android.tools.r8.kotlin.KotlinMetadataDiagnostic;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.kotlin.KotlinTypeReference;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.Reporter;

public abstract class KotlinClassifierInfo
implements EnqueuerMetadataTraceable {
    public static KotlinClassifierInfo create(KmClassifier classifier, DexItemFactory factory, Reporter reporter) {
        if (classifier instanceof KmClassifier.Class) {
            String originalTypeName = ((KmClassifier.Class)classifier).getName();
            boolean isLocalOrAnonymous = originalTypeName.startsWith(".");
            String descriptor = DescriptorUtils.getDescriptorFromKotlinClassifier(isLocalOrAnonymous ? originalTypeName.substring(1) : originalTypeName);
            if (DescriptorUtils.isClassDescriptor(descriptor)) {
                return new KotlinClassClassifierInfo(KotlinTypeReference.fromDescriptor(descriptor, factory), isLocalOrAnonymous);
            }
            return new KotlinUnknownClassClassifierInfo(originalTypeName);
        }
        if (classifier instanceof KmClassifier.TypeAlias) {
            return new KotlinTypeAliasClassifierInfo(((KmClassifier.TypeAlias)classifier).getName());
        }
        if (classifier instanceof KmClassifier.TypeParameter) {
            return new KotlinTypeParameterClassifierInfo(((KmClassifier.TypeParameter)classifier).getId());
        }
        reporter.warning(KotlinMetadataDiagnostic.unknownClassifier(classifier.toString()));
        return new KotlinUnknownClassifierInfo(classifier.toString());
    }

    abstract boolean rewrite(KmTypeVisitor var1, AppView<?> var2, NamingLens var3);

    public DexType rewriteType(GraphLens graphLens) {
        return null;
    }

    public static class KotlinUnknownClassifierInfo
    extends KotlinClassifierInfo {
        private final String classifier;

        private KotlinUnknownClassifierInfo(String classifier) {
            this.classifier = classifier;
        }

        @Override
        boolean rewrite(KmTypeVisitor visitor, AppView<?> appView, NamingLens namingLens) {
            visitor.visitTypeAlias(this.classifier);
            return false;
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
        }
    }

    public static class KotlinUnknownClassClassifierInfo
    extends KotlinClassifierInfo {
        private final String classifier;

        private KotlinUnknownClassClassifierInfo(String classifier) {
            this.classifier = classifier;
        }

        @Override
        boolean rewrite(KmTypeVisitor visitor, AppView<?> appView, NamingLens namingLens) {
            visitor.visitClass(this.classifier);
            return false;
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
        }
    }

    public static class KotlinTypeAliasClassifierInfo
    extends KotlinClassifierInfo {
        private final String typeAlias;

        private KotlinTypeAliasClassifierInfo(String typeAlias) {
            this.typeAlias = typeAlias;
        }

        @Override
        boolean rewrite(KmTypeVisitor visitor, AppView<?> appView, NamingLens namingLens) {
            visitor.visitTypeAlias(this.typeAlias);
            return false;
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
        }
    }

    public static class KotlinTypeParameterClassifierInfo
    extends KotlinClassifierInfo {
        private final int typeId;

        private KotlinTypeParameterClassifierInfo(int typeId) {
            this.typeId = typeId;
        }

        @Override
        boolean rewrite(KmTypeVisitor visitor, AppView<?> appView, NamingLens namingLens) {
            visitor.visitTypeParameter(this.typeId);
            return false;
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
        }
    }

    public static class KotlinClassClassifierInfo
    extends KotlinClassifierInfo {
        private final KotlinTypeReference type;
        private final boolean isLocalOrAnonymous;

        private KotlinClassClassifierInfo(KotlinTypeReference type, boolean isLocalOrAnonymous) {
            this.type = type;
            this.isLocalOrAnonymous = isLocalOrAnonymous;
        }

        @Override
        boolean rewrite(KmTypeVisitor visitor, AppView<?> appView, NamingLens namingLens) {
            return this.type.toRenamedDescriptorOrDefault(descriptor -> visitor.visitClass(KotlinMetadataUtils.getKotlinLocalOrAnonymousNameFromDescriptor(descriptor, this.isLocalOrAnonymous)), appView, namingLens, "Lkotlin/Any;");
        }

        @Override
        public void trace(DexDefinitionSupplier definitionSupplier) {
            this.type.trace(definitionSupplier);
        }

        @Override
        public DexType rewriteType(GraphLens graphLens) {
            return this.type.rewriteType(graphLens);
        }
    }
}

