/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmClass;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmExtensionsKt;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import com.android.tools.r8.kotlin.KotlinJvmMethodSignatureInfo;
import com.android.tools.r8.kotlin.KotlinMethodLevelInfo;
import com.android.tools.r8.kotlin.KotlinValueParameterInfo;
import com.android.tools.r8.kotlin.KotlinVersionRequirementInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.util.List;

public class KotlinConstructorInfo
implements KotlinMethodLevelInfo {
    private final int flags;
    private final List<KotlinValueParameterInfo> valueParameters;
    private final KotlinVersionRequirementInfo versionRequirements;
    private final KotlinJvmMethodSignatureInfo signature;

    private KotlinConstructorInfo(int flags, List<KotlinValueParameterInfo> valueParameters, KotlinVersionRequirementInfo versionRequirements, KotlinJvmMethodSignatureInfo signature) {
        this.flags = flags;
        this.valueParameters = valueParameters;
        this.versionRequirements = versionRequirements;
        this.signature = signature;
    }

    public static KotlinConstructorInfo create(KmConstructor kmConstructor, DexItemFactory factory, Reporter reporter, boolean readConstructorSignature) {
        return new KotlinConstructorInfo(kmConstructor.getFlags(), KotlinValueParameterInfo.create(kmConstructor.getValueParameters(), factory, reporter), KotlinVersionRequirementInfo.create(kmConstructor.getVersionRequirements()), readConstructorSignature ? KotlinJvmMethodSignatureInfo.create(JvmExtensionsKt.getSignature(kmConstructor), factory) : null);
    }

    boolean rewrite(KmClass kmClass, DexEncodedMethod method, AppView<?> appView, NamingLens namingLens) {
        KmConstructor kmConstructor = new KmConstructor(this.flags);
        boolean rewritten = false;
        if (this.signature != null) {
            rewritten = this.signature.rewrite((JvmMethodSignature rewrittenSignature) -> JvmExtensionsKt.setSignature(kmConstructor, rewrittenSignature), method, appView, namingLens);
        }
        for (KotlinValueParameterInfo valueParameterInfo : this.valueParameters) {
            rewritten |= valueParameterInfo.rewrite(kmConstructor::visitValueParameter, appView, namingLens);
        }
        kmClass.getConstructors().add(kmConstructor);
        return rewritten |= this.versionRequirements.rewrite(kmConstructor::visitVersionRequirement);
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    @Override
    public KotlinConstructorInfo asConstructor() {
        return this;
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        FunctionUtils.forEachApply(this.valueParameters, param -> param::trace, definitionSupplier);
        if (this.signature != null) {
            this.signature.trace(definitionSupplier);
        }
    }
}

