/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmContract;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmContractVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmEffect;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinEffectInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.util.List;

public class KotlinContractInfo
implements EnqueuerMetadataTraceable {
    private static final KotlinContractInfo NO_EFFECT = new KotlinContractInfo(ImmutableList.of());
    private final List<KotlinEffectInfo> effects;

    private KotlinContractInfo(List<KotlinEffectInfo> effects) {
        this.effects = effects;
    }

    static KotlinContractInfo create(KmContract kmContract, DexItemFactory factory, Reporter reporter) {
        if (kmContract == null) {
            return NO_EFFECT;
        }
        List<KmEffect> effects = kmContract.getEffects();
        if (effects.isEmpty()) {
            return NO_EFFECT;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (KmEffect effect : effects) {
            builder.add(KotlinEffectInfo.create(effect, factory, reporter));
        }
        return new KotlinContractInfo((List<KotlinEffectInfo>)((Object)builder.build()));
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        FunctionUtils.forEachApply(this.effects, effect -> effect::trace, definitionSupplier);
    }

    boolean rewrite(KmVisitorProviders.KmContractVisitorProvider visitorProvider, AppView<?> appView, NamingLens namingLens) {
        if (this == NO_EFFECT) {
            return false;
        }
        boolean rewritten = false;
        KmContractVisitor kmContractVisitor = visitorProvider.get();
        for (KotlinEffectInfo effect : this.effects) {
            rewritten |= effect.rewrite(kmContractVisitor::visitEffect, appView, namingLens);
        }
        kmContractVisitor.visitEnd();
        return rewritten;
    }
}

