/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.math.IntMath;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmDeclarationContainer;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunction;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmProperty;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmTypeAlias;
import com.android.tools.r8.jetbrains.kotlinx.metadata.internal.metadata.deserialization.Flags;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmExtensionsKt;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinFunctionInfo;
import com.android.tools.r8.kotlin.KotlinJvmSignatureExtensionInformation;
import com.android.tools.r8.kotlin.KotlinMetadataMembersTracker;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.kotlin.KotlinPropertyInfo;
import com.android.tools.r8.kotlin.KotlinTypeAliasInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.math.RoundingMode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class KotlinDeclarationContainerInfo
implements EnqueuerMetadataTraceable {
    private final List<KotlinTypeAliasInfo> typeAliases;
    private final List<KotlinFunctionInfo> functionsWithNoBacking;
    private final List<KotlinPropertyInfo> propertiesWithNoBacking;

    private KotlinDeclarationContainerInfo(List<KotlinTypeAliasInfo> typeAliases, List<KotlinFunctionInfo> functionsWithNoBacking, List<KotlinPropertyInfo> propertiesWithNoBacking) {
        this.typeAliases = typeAliases;
        this.functionsWithNoBacking = functionsWithNoBacking;
        this.propertiesWithNoBacking = propertiesWithNoBacking;
    }

    public static KotlinDeclarationContainerInfo create(KmDeclarationContainer container, Map<String, DexEncodedMethod> methodSignatureMap, Map<String, DexEncodedField> fieldSignatureMap, DexItemFactory factory, Reporter reporter, Consumer<DexEncodedMethod> keepByteCode, KotlinJvmSignatureExtensionInformation extensionInformation, KotlinMetadataMembersTracker originalAssignmentTracker) {
        ImmutableList.Builder notBackedFunctions = ImmutableList.builder();
        int functionCounter = 0;
        for (KmFunction kmFunction : container.getFunctions()) {
            JvmMethodSignature signature = JvmExtensionsKt.getSignature(kmFunction);
            if (signature == null) {
                assert (false);
                continue;
            }
            KotlinFunctionInfo kotlinFunctionInfo = KotlinFunctionInfo.create(kmFunction, factory, reporter, extensionInformation.hasJvmMethodSignatureExtensionForFunction(functionCounter++));
            DexEncodedMethod method = methodSignatureMap.get(signature.asString());
            if (method == null) {
                notBackedFunctions.add(kotlinFunctionInfo);
                if (KotlinMetadataUtils.isValidMethodDescriptor(signature.getDesc())) continue;
                continue;
            }
            KotlinDeclarationContainerInfo.keepIfInline(kmFunction.getFlags(), method, signature, methodSignatureMap, keepByteCode);
            method.setKotlinMemberInfo(kotlinFunctionInfo);
            originalAssignmentTracker.add((DexMember<?, ?>)method.getReference());
        }
        ImmutableList.Builder notBackedProperties = ImmutableList.builder();
        for (KmProperty kmProperty : container.getProperties()) {
            DexEncodedMethod method;
            DexEncodedField field;
            KotlinPropertyInfo kotlinPropertyInfo = KotlinPropertyInfo.create(kmProperty, factory, reporter);
            KotlinMetadataUtils.KmPropertyProcessor propertyProcessor = new KotlinMetadataUtils.KmPropertyProcessor(kmProperty);
            boolean hasBacking = false;
            if (propertyProcessor.fieldSignature() != null && (field = fieldSignatureMap.get(propertyProcessor.fieldSignature().asString())) != null) {
                hasBacking = true;
                field.setKotlinMemberInfo(kotlinPropertyInfo);
                originalAssignmentTracker.add((DexMember<?, ?>)field.getReference());
            }
            if (propertyProcessor.getterSignature() != null && (method = methodSignatureMap.get(propertyProcessor.getterSignature().asString())) != null) {
                hasBacking = true;
                KotlinDeclarationContainerInfo.keepIfAccessorInline(kmProperty.getGetterFlags(), method, keepByteCode);
                method.setKotlinMemberInfo(kotlinPropertyInfo);
                originalAssignmentTracker.add((DexMember<?, ?>)method.getReference());
            }
            if (propertyProcessor.setterSignature() != null && (method = methodSignatureMap.get(propertyProcessor.setterSignature().asString())) != null) {
                hasBacking = true;
                KotlinDeclarationContainerInfo.keepIfAccessorInline(kmProperty.getGetterFlags(), method, keepByteCode);
                method.setKotlinMemberInfo(kotlinPropertyInfo);
                originalAssignmentTracker.add((DexMember<?, ?>)method.getReference());
            }
            if (hasBacking) continue;
            notBackedProperties.add(kotlinPropertyInfo);
        }
        return new KotlinDeclarationContainerInfo(KotlinDeclarationContainerInfo.getTypeAliases(container.getTypeAliases(), factory, reporter), (List<KotlinFunctionInfo>)((Object)notBackedFunctions.build()), (List<KotlinPropertyInfo>)((Object)notBackedProperties.build()));
    }

    private static void keepIfInline(int flags, DexEncodedMethod method, JvmMethodSignature signature, Map<String, DexEncodedMethod> methodSignatureMap, Consumer<DexEncodedMethod> keepByteCode) {
        if (Flags.IS_INLINE.get(flags).booleanValue()) {
            for (int i = 1; i <= IntMath.divide(method.getParameters().size(), 32, RoundingMode.CEILING); ++i) {
                DexEncodedMethod defaultValueMethod = methodSignatureMap.get(KotlinMetadataUtils.toDefaultJvmMethodSignature(signature, i).toString());
                if (defaultValueMethod == null) continue;
                keepByteCode.accept(defaultValueMethod);
                return;
            }
            keepByteCode.accept(method);
        }
    }

    private static void keepIfAccessorInline(int flags, DexEncodedMethod method, Consumer<DexEncodedMethod> keepByteCode) {
        if (Flags.IS_INLINE_ACCESSOR.get(flags).booleanValue()) {
            keepByteCode.accept(method);
        }
    }

    private static List<KotlinTypeAliasInfo> getTypeAliases(List<KmTypeAlias> aliases, DexItemFactory factory, Reporter reporter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (KmTypeAlias alias : aliases) {
            builder.add(KotlinTypeAliasInfo.create(alias, factory, reporter));
        }
        return builder.build();
    }

    boolean rewrite(KmVisitorProviders.KmFunctionVisitorProvider functionProvider, KmVisitorProviders.KmPropertyVisitorProvider propertyProvider, KmVisitorProviders.KmTypeAliasVisitorProvider typeAliasProvider, DexClass clazz, AppView<?> appView, NamingLens namingLens, KotlinMetadataMembersTracker rewrittenMembersWithKotlinInfo) {
        boolean rewritten = false;
        for (KotlinTypeAliasInfo typeAlias : this.typeAliases) {
            rewritten |= typeAlias.rewrite(typeAliasProvider, appView, namingLens);
        }
        LinkedHashMap<KotlinPropertyInfo, KotlinPropertyGroup> properties = new LinkedHashMap<KotlinPropertyInfo, KotlinPropertyGroup>();
        for (DexEncodedField field : clazz.fields()) {
            if (!field.getKotlinInfo().isProperty()) continue;
            properties.computeIfAbsent(field.getKotlinInfo().asProperty(), ignored -> new KotlinPropertyGroup()).setBackingField(field);
            rewrittenMembersWithKotlinInfo.add((DexMember<?, ?>)field.getReference());
        }
        for (DexEncodedMethod method : clazz.methods()) {
            if (method.getKotlinInfo().isFunction()) {
                rewritten |= method.getKotlinInfo().asFunction().rewrite(functionProvider, method, appView, namingLens);
                rewrittenMembersWithKotlinInfo.add((DexMember<?, ?>)method.getReference());
                continue;
            }
            KotlinPropertyInfo kotlinPropertyInfo = method.getKotlinInfo().asProperty();
            if (kotlinPropertyInfo == null) continue;
            rewrittenMembersWithKotlinInfo.add((DexMember<?, ?>)method.getReference());
            KotlinPropertyGroup kotlinPropertyGroup = properties.computeIfAbsent(kotlinPropertyInfo, ignored -> new KotlinPropertyGroup());
            if (((DexMethod)method.getReference()).proto.returnType == appView.dexItemFactory().voidType) {
                kotlinPropertyGroup.setSetter(method);
                continue;
            }
            kotlinPropertyGroup.setGetter(method);
        }
        for (KotlinPropertyInfo kotlinPropertyInfo : properties.keySet()) {
            KotlinPropertyGroup kotlinPropertyGroup = (KotlinPropertyGroup)properties.get(kotlinPropertyInfo);
            rewritten |= kotlinPropertyInfo.rewrite(propertyProvider, kotlinPropertyGroup.backingField, kotlinPropertyGroup.getter, kotlinPropertyGroup.setter, appView, namingLens);
        }
        for (KotlinFunctionInfo notBackedFunction : this.functionsWithNoBacking) {
            rewritten |= notBackedFunction.rewrite(functionProvider, null, appView, namingLens);
        }
        for (KotlinPropertyInfo notBackedProperty : this.propertiesWithNoBacking) {
            rewritten |= notBackedProperty.rewrite(propertyProvider, null, null, null, appView, namingLens);
        }
        return rewritten;
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        FunctionUtils.forEachApply(this.typeAliases, alias -> alias::trace, definitionSupplier);
        FunctionUtils.forEachApply(this.functionsWithNoBacking, function -> function::trace, definitionSupplier);
        FunctionUtils.forEachApply(this.propertiesWithNoBacking, property -> property::trace, definitionSupplier);
    }

    public static class KotlinPropertyGroup {
        private DexEncodedField backingField = null;
        private DexEncodedMethod setter = null;
        private DexEncodedMethod getter = null;

        void setBackingField(DexEncodedField backingField) {
            assert (this.backingField == null);
            this.backingField = backingField;
        }

        void setGetter(DexEncodedMethod getter) {
            assert (this.getter == null);
            this.getter = getter;
        }

        void setSetter(DexEncodedMethod setter) {
            assert (this.setter == null);
            this.setter = setter;
        }
    }
}

