/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunction;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunctionVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmExtensionsKt;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmFunctionExtensionVisitor;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinContractInfo;
import com.android.tools.r8.kotlin.KotlinJvmMethodSignatureInfo;
import com.android.tools.r8.kotlin.KotlinMethodLevelInfo;
import com.android.tools.r8.kotlin.KotlinTypeInfo;
import com.android.tools.r8.kotlin.KotlinTypeParameterInfo;
import com.android.tools.r8.kotlin.KotlinTypeReference;
import com.android.tools.r8.kotlin.KotlinValueParameterInfo;
import com.android.tools.r8.kotlin.KotlinVersionRequirementInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.util.Iterator;
import java.util.List;

public final class KotlinFunctionInfo
implements KotlinMethodLevelInfo {
    private final int flags;
    private final String name;
    private final List<KotlinValueParameterInfo> valueParameters;
    public final KotlinTypeInfo returnType;
    private final KotlinTypeInfo receiverParameterType;
    private final List<KotlinTypeParameterInfo> typeParameters;
    private final KotlinJvmMethodSignatureInfo signature;
    private final KotlinTypeReference lambdaClassOrigin;
    private final KotlinVersionRequirementInfo versionRequirements;
    private final KotlinContractInfo contract;
    private final boolean crossInlineParameter;

    private KotlinFunctionInfo(int flags, String name, KotlinTypeInfo returnType, KotlinTypeInfo receiverParameterType, List<KotlinValueParameterInfo> valueParameters, List<KotlinTypeParameterInfo> typeParameters, KotlinJvmMethodSignatureInfo signature, KotlinTypeReference lambdaClassOrigin, KotlinVersionRequirementInfo versionRequirements, KotlinContractInfo contract, boolean crossInlineParameter) {
        this.flags = flags;
        this.name = name;
        this.returnType = returnType;
        this.receiverParameterType = receiverParameterType;
        this.valueParameters = valueParameters;
        this.typeParameters = typeParameters;
        this.signature = signature;
        this.lambdaClassOrigin = lambdaClassOrigin;
        this.versionRequirements = versionRequirements;
        this.contract = contract;
        this.crossInlineParameter = crossInlineParameter;
    }

    static KotlinFunctionInfo create(KmFunction kmFunction, DexItemFactory factory, Reporter reporter, boolean readMethodSignature) {
        boolean isCrossInline = false;
        List<KotlinValueParameterInfo> valueParameters = KotlinValueParameterInfo.create(kmFunction.getValueParameters(), factory, reporter);
        for (KotlinValueParameterInfo valueParameter : valueParameters) {
            if (!valueParameter.isCrossInline()) continue;
            isCrossInline = true;
            break;
        }
        return new KotlinFunctionInfo(kmFunction.getFlags(), kmFunction.getName(), KotlinTypeInfo.create(kmFunction.getReturnType(), factory, reporter), KotlinTypeInfo.create(kmFunction.getReceiverParameterType(), factory, reporter), valueParameters, KotlinTypeParameterInfo.create(kmFunction.getTypeParameters(), factory, reporter), readMethodSignature ? KotlinJvmMethodSignatureInfo.create(JvmExtensionsKt.getSignature(kmFunction), factory) : null, KotlinFunctionInfo.getlambdaClassOrigin(kmFunction, factory), KotlinVersionRequirementInfo.create(kmFunction.getVersionRequirements()), KotlinContractInfo.create(kmFunction.getContract(), factory, reporter), isCrossInline);
    }

    private static KotlinTypeReference getlambdaClassOrigin(KmFunction kmFunction, DexItemFactory factory) {
        String lambdaClassOriginName = JvmExtensionsKt.getLambdaClassOriginName(kmFunction);
        if (lambdaClassOriginName != null) {
            return KotlinTypeReference.fromBinaryName(lambdaClassOriginName, factory, lambdaClassOriginName);
        }
        return null;
    }

    public boolean hasCrossInlineParameter() {
        return this.crossInlineParameter;
    }

    public String getName() {
        return this.name;
    }

    boolean rewrite(KmVisitorProviders.KmFunctionVisitorProvider visitorProvider, DexEncodedMethod method, AppView<?> appView, NamingLens namingLens) {
        Iterator<KotlinTypeParameterInfo> rewrittenName;
        String methodName;
        boolean rewritten = false;
        String finalName = this.name;
        if (method != null && !(methodName = ((DexMethod)method.getReference()).name.toString()).equals(rewrittenName = namingLens.lookupName((DexMethod)method.getReference()).toString())) {
            rewritten = true;
            finalName = rewrittenName;
        }
        KmFunctionVisitor kmFunction = visitorProvider.get(this.flags, finalName);
        rewritten |= this.returnType.rewrite(kmFunction::visitReturnType, appView, namingLens);
        for (KotlinValueParameterInfo valueParameterInfo : this.valueParameters) {
            rewritten |= valueParameterInfo.rewrite(kmFunction::visitValueParameter, appView, namingLens);
        }
        for (KotlinTypeParameterInfo typeParameterInfo : this.typeParameters) {
            rewritten |= typeParameterInfo.rewrite(kmFunction::visitTypeParameter, appView, namingLens);
        }
        if (this.receiverParameterType != null) {
            rewritten |= this.receiverParameterType.rewrite(kmFunction::visitReceiverParameterType, appView, namingLens);
        }
        rewritten |= this.versionRequirements.rewrite(kmFunction::visitVersionRequirement);
        JvmFunctionExtensionVisitor extensionVisitor = (JvmFunctionExtensionVisitor)kmFunction.visitExtensions(JvmFunctionExtensionVisitor.TYPE);
        if (this.signature != null && extensionVisitor != null) {
            rewritten |= this.signature.rewrite(extensionVisitor::visit, method, appView, namingLens);
        }
        if (this.lambdaClassOrigin != null && extensionVisitor != null) {
            rewritten |= this.lambdaClassOrigin.toRenamedBinaryNameOrDefault(lambdaClassOriginName -> {
                if (lambdaClassOriginName != null) {
                    extensionVisitor.visitLambdaClassOriginName((String)lambdaClassOriginName);
                }
            }, appView, namingLens, null);
        }
        return rewritten |= this.contract.rewrite(kmFunction::visitContract, appView, namingLens);
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public KotlinFunctionInfo asFunction() {
        return this;
    }

    public boolean isExtensionFunction() {
        return this.receiverParameterType != null;
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        FunctionUtils.forEachApply(this.valueParameters, param -> param::trace, definitionSupplier);
        this.returnType.trace(definitionSupplier);
        if (this.receiverParameterType != null) {
            this.receiverParameterType.trace(definitionSupplier);
        }
        FunctionUtils.forEachApply(this.typeParameters, param -> param::trace, definitionSupplier);
        if (this.signature != null) {
            this.signature.trace(definitionSupplier);
        }
        if (this.lambdaClassOrigin != null) {
            this.lambdaClassOrigin.trace(definitionSupplier);
        }
        this.contract.trace(definitionSupplier);
    }
}

