/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.kotlin.KotlinTypeReference;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FunctionUtils;
import java.util.List;
import java.util.function.Consumer;

public class KotlinJvmMethodSignatureInfo
implements EnqueuerMetadataTraceable {
    private static final List<KotlinTypeReference> EMPTY_PARAMETERS_LIST = ImmutableList.of();
    private final String name;
    private final KotlinTypeReference returnType;
    private final List<KotlinTypeReference> parameters;
    private final String invalidDescriptor;

    private KotlinJvmMethodSignatureInfo(String name, KotlinTypeReference returnType, List<KotlinTypeReference> parameters) {
        this.name = name;
        this.returnType = returnType;
        this.parameters = parameters;
        this.invalidDescriptor = null;
    }

    private KotlinJvmMethodSignatureInfo(String name, String invalidDescriptor) {
        this.name = name;
        this.invalidDescriptor = invalidDescriptor;
        this.parameters = EMPTY_PARAMETERS_LIST;
        this.returnType = null;
    }

    public static KotlinJvmMethodSignatureInfo create(JvmMethodSignature methodSignature, DexItemFactory factory) {
        if (methodSignature == null) {
            return null;
        }
        String name = methodSignature.getName();
        String descriptor = methodSignature.getDesc();
        if (!KotlinMetadataUtils.isValidMethodDescriptor(descriptor)) {
            return new KotlinJvmMethodSignatureInfo(methodSignature.getName(), descriptor);
        }
        String returnTypeDescriptor = DescriptorUtils.getReturnTypeDescriptor(descriptor);
        KotlinTypeReference returnType = KotlinTypeReference.fromDescriptor(returnTypeDescriptor, factory);
        String[] descriptors = DescriptorUtils.getArgumentTypeDescriptors(descriptor);
        if (descriptors.length == 0) {
            return new KotlinJvmMethodSignatureInfo(name, returnType, EMPTY_PARAMETERS_LIST);
        }
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (String paramDescriptor : descriptors) {
            parameters.add(KotlinTypeReference.fromDescriptor(paramDescriptor, factory));
        }
        return new KotlinJvmMethodSignatureInfo(name, returnType, (List<KotlinTypeReference>)((Object)parameters.build()));
    }

    boolean rewrite(Consumer<JvmMethodSignature> consumer, DexEncodedMethod method, AppView<?> appView, NamingLens namingLens) {
        String rewrittenName;
        String methodName;
        if (this.invalidDescriptor != null) {
            consumer.accept(new JvmMethodSignature(this.name, this.invalidDescriptor));
            return false;
        }
        assert (this.returnType != null);
        String finalName = this.name;
        boolean rewritten = false;
        if (method != null && !(methodName = ((DexMethod)method.getReference()).name.toString()).equals(rewrittenName = namingLens.lookupName((DexMethod)method.getReference()).toString())) {
            finalName = rewrittenName;
            rewritten = true;
        }
        StringBuilder descBuilder = new StringBuilder();
        descBuilder.append("(");
        String defValue = appView.dexItemFactory().objectType.toDescriptorString();
        for (KotlinTypeReference parameter : this.parameters) {
            rewritten |= parameter.toRenamedDescriptorOrDefault(descBuilder::append, appView, namingLens, defValue);
        }
        descBuilder.append(")");
        consumer.accept(new JvmMethodSignature(finalName, descBuilder.toString()));
        return rewritten |= this.returnType.toRenamedDescriptorOrDefault(descBuilder::append, appView, namingLens, defValue);
    }

    public String toString() {
        if (this.invalidDescriptor != null) {
            return this.name + "(" + this.invalidDescriptor + ")";
        }
        assert (this.returnType != null);
        StringBuilder descBuilder = new StringBuilder();
        descBuilder.append(this.name);
        descBuilder.append("(");
        for (KotlinTypeReference parameter : this.parameters) {
            descBuilder.append(parameter.toString());
        }
        descBuilder.append(")");
        descBuilder.append(this.returnType.toString());
        return descBuilder.toString();
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        if (this.invalidDescriptor != null) {
            return;
        }
        assert (this.returnType != null);
        this.returnType.trace(definitionSupplier);
        FunctionUtils.forEachApply(this.parameters, param -> param::trace, definitionSupplier);
    }
}

