/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.jetbrains.kotlin.Pair;
import com.android.tools.r8.jetbrains.kotlinx.metadata.internal.metadata.ProtoBuf;
import com.android.tools.r8.jetbrains.kotlinx.metadata.internal.metadata.jvm.JvmProtoBuf;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.ReflectionHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class KotlinJvmSignatureExtensionInformation {
    private static final KotlinJvmSignatureExtensionInformation EMPTY = KotlinJvmSignatureExtensionInformationBuilder.access$000(KotlinJvmSignatureExtensionInformation.builder());
    private final Set<Integer> noExtensionIndicesForFunctions;
    private final Set<Integer> noExtensionIndicesForConstructors;

    private KotlinJvmSignatureExtensionInformation(Set<Integer> noExtensionIndicesForFunctions, Set<Integer> noExtensionIndicesForConstructors) {
        this.noExtensionIndicesForFunctions = noExtensionIndicesForFunctions;
        this.noExtensionIndicesForConstructors = noExtensionIndicesForConstructors;
    }

    public static KotlinJvmSignatureExtensionInformation readInformationFromMessage(KotlinClassMetadata.FileFacade fileFacadeMetadata, InternalOptions options) {
        return KotlinJvmSignatureExtensionInformation.readPackageDataFromMessage(fileFacadeMetadata, options);
    }

    public static KotlinJvmSignatureExtensionInformation readInformationFromMessage(KotlinClassMetadata.MultiFileClassPart classPart, InternalOptions options) {
        return KotlinJvmSignatureExtensionInformation.readPackageDataFromMessage(classPart, options);
    }

    private static KotlinJvmSignatureExtensionInformation readPackageDataFromMessage(Object object, InternalOptions options) {
        try {
            Pair kotlinPairData = (Pair)ReflectionHelper.performReflection(object, ReflectionHelper.builder().readField("packageData$delegate").setSetAccessible(true).done().readMethod("getValue").setSetAccessible(true).done().build());
            return KotlinJvmSignatureExtensionInformation.builder().visit((ProtoBuf.Package)kotlinPairData.getSecond()).build();
        }
        catch (Exception e) {
            options.warningReadingKotlinMetadataReflective();
            return KotlinJvmSignatureExtensionInformation.empty();
        }
    }

    public static KotlinJvmSignatureExtensionInformation readInformationFromMessage(KotlinClassMetadata.SyntheticClass syntheticClass, InternalOptions options) {
        try {
            Pair kotlinPairData = (Pair)ReflectionHelper.performReflection(syntheticClass, ReflectionHelper.builder().readField("functionData$delegate").setSetAccessible(true).done().readMethod("getValue").setSetAccessible(true).done().build());
            if (kotlinPairData == null) {
                return KotlinJvmSignatureExtensionInformation.empty();
            }
            return KotlinJvmSignatureExtensionInformation.builder().visit((ProtoBuf.Function)kotlinPairData.getSecond(), 0).build();
        }
        catch (Exception e) {
            options.warningReadingKotlinMetadataReflective();
            return KotlinJvmSignatureExtensionInformation.empty();
        }
    }

    public static KotlinJvmSignatureExtensionInformation readInformationFromMessage(KotlinClassMetadata.Class kMetadata, InternalOptions options) {
        try {
            Pair kotlinPairData = (Pair)ReflectionHelper.performReflection(kMetadata, ReflectionHelper.builder().readField("classData$delegate").setSetAccessible(true).done().readMethod("getValue").setSetAccessible(true).done().build());
            return KotlinJvmSignatureExtensionInformation.builder().visit((ProtoBuf.Class)kotlinPairData.getSecond()).build();
        }
        catch (Exception e) {
            options.warningReadingKotlinMetadataReflective();
            return KotlinJvmSignatureExtensionInformation.empty();
        }
    }

    public static KotlinJvmSignatureExtensionInformationBuilder builder() {
        return new KotlinJvmSignatureExtensionInformationBuilder();
    }

    public static KotlinJvmSignatureExtensionInformation empty() {
        return EMPTY;
    }

    public boolean hasJvmMethodSignatureExtensionForFunction(int index) {
        return !this.noExtensionIndicesForFunctions.contains(index);
    }

    public boolean hasJvmMethodSignatureExtensionForConstructor(int index) {
        return !this.noExtensionIndicesForConstructors.contains(index);
    }

    private static class KotlinJvmSignatureExtensionInformationBuilder {
        private final Set<Integer> noExtensionIndicesForFunctions = new HashSet<Integer>();
        private final Set<Integer> noExtensionIndicesForConstructors = new HashSet<Integer>();

        private KotlinJvmSignatureExtensionInformationBuilder() {
        }

        private KotlinJvmSignatureExtensionInformation build() {
            return new KotlinJvmSignatureExtensionInformation(this.noExtensionIndicesForFunctions, this.noExtensionIndicesForConstructors);
        }

        private KotlinJvmSignatureExtensionInformationBuilder visit(ProtoBuf.Class clazz) {
            this.visitFunctions(clazz.getFunctionList());
            this.visitConstructors(clazz.getConstructorList());
            return this;
        }

        private KotlinJvmSignatureExtensionInformationBuilder visit(ProtoBuf.Package pkg) {
            this.visitFunctions(pkg.getFunctionList());
            return this;
        }

        private void visitFunctions(List<ProtoBuf.Function> functions) {
            ListUtils.forEachWithIndex(functions, this::visit);
        }

        private void visitConstructors(List<ProtoBuf.Constructor> constructors) {
            ListUtils.forEachWithIndex(constructors, (constructor, index) -> {
                if (!constructor.hasExtension(JvmProtoBuf.constructorSignature)) {
                    this.noExtensionIndicesForConstructors.add(index);
                }
            });
        }

        public KotlinJvmSignatureExtensionInformationBuilder visit(ProtoBuf.Function function, int index) {
            if (!function.hasExtension(JvmProtoBuf.methodSignature)) {
                this.noExtensionIndicesForFunctions.add(index);
            }
            return this;
        }
    }
}

