/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmLambda;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmExtensionsKt;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinFunctionInfo;
import com.android.tools.r8.kotlin.KotlinJvmSignatureExtensionInformation;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.Reporter;

public class KotlinLambdaInfo
implements EnqueuerMetadataTraceable {
    private final KotlinFunctionInfo function;
    private final boolean hasBacking;

    private KotlinLambdaInfo(KotlinFunctionInfo function, boolean hasBacking) {
        this.function = function;
        this.hasBacking = hasBacking;
    }

    static KotlinLambdaInfo create(DexClass clazz, KmLambda lambda, DexItemFactory factory, Reporter reporter, KotlinJvmSignatureExtensionInformation extensionInformation) {
        if (lambda == null) {
            assert (false);
            return null;
        }
        KotlinFunctionInfo kotlinFunctionInfo = KotlinFunctionInfo.create(lambda.function, factory, reporter, extensionInformation.hasJvmMethodSignatureExtensionForFunction(0));
        JvmMethodSignature signature = JvmExtensionsKt.getSignature(lambda.function);
        if (signature != null) {
            for (DexEncodedMethod method : clazz.methods()) {
                if (!KotlinMetadataUtils.toJvmMethodSignature((DexMethod)method.getReference()).asString().equals(signature.asString())) continue;
                method.setKotlinMemberInfo(kotlinFunctionInfo);
                return new KotlinLambdaInfo(kotlinFunctionInfo, true);
            }
        }
        return new KotlinLambdaInfo(kotlinFunctionInfo, false);
    }

    boolean rewrite(KmVisitorProviders.KmLambdaVisitorProvider visitorProvider, DexClass clazz, AppView<?> appView, NamingLens namingLens) {
        if (!this.hasBacking) {
            this.function.rewrite(visitorProvider.get()::visitFunction, null, appView, namingLens);
            return true;
        }
        DexEncodedMethod backing = null;
        for (DexEncodedMethod method : clazz.methods()) {
            if (method.getKotlinInfo() != this.function) continue;
            backing = method;
            break;
        }
        return this.function.rewrite(visitorProvider.get()::visitFunction, backing, appView, namingLens);
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        this.function.trace(definitionSupplier);
    }
}

