/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmProperty;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinPropertyInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.FunctionUtils;
import com.android.tools.r8.utils.Reporter;
import java.util.List;

public class KotlinLocalDelegatedPropertyInfo
implements EnqueuerMetadataTraceable {
    private static final KotlinLocalDelegatedPropertyInfo EMPTY_DELEGATED_PROPERTIES = new KotlinLocalDelegatedPropertyInfo(ImmutableList.of());
    private final List<KotlinPropertyInfo> propertyInfos;

    private KotlinLocalDelegatedPropertyInfo(List<KotlinPropertyInfo> propertyInfos) {
        this.propertyInfos = propertyInfos;
    }

    static KotlinLocalDelegatedPropertyInfo create(List<KmProperty> kmProperties, DexItemFactory factory, Reporter reporter) {
        if (kmProperties == null || kmProperties.size() == 0) {
            return EMPTY_DELEGATED_PROPERTIES;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (KmProperty kmProperty : kmProperties) {
            KotlinPropertyInfo kotlinPropertyInfo = KotlinPropertyInfo.create(kmProperty, factory, reporter);
            assert (kotlinPropertyInfo.getFieldSignature() == null);
            assert (kotlinPropertyInfo.getGetterSignature() == null);
            assert (kotlinPropertyInfo.getSetterSignature() == null);
            builder.add(kotlinPropertyInfo);
        }
        return new KotlinLocalDelegatedPropertyInfo((List<KotlinPropertyInfo>)((Object)builder.build()));
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        FunctionUtils.forEachApply(this.propertyInfos, prop -> prop::trace, definitionSupplier);
    }

    boolean rewrite(KmVisitorProviders.KmPropertyVisitorProvider visitorProvider, AppView<?> appView, NamingLens namingLens) {
        boolean rewritten = false;
        for (KotlinPropertyInfo propertyInfo : this.propertyInfos) {
            rewritten |= propertyInfo.rewrite(visitorProvider, null, null, null, appView, namingLens);
        }
        return rewritten;
    }
}

