/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassResolutionResult;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.analysis.EnqueuerAnalysis;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.kotlin.KotlinClassMetadataReader;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.shaking.KeepClassInfo;
import java.util.Set;

public class KotlinMetadataEnqueuerExtension
extends EnqueuerAnalysis {
    private static final OptimizationFeedback feedback = OptimizationFeedbackSimple.getInstance();
    private final AppView<?> appView;
    private final Enqueuer.EnqueuerDefinitionSupplier enqueuerDefinitionSupplier;
    private final Set<DexType> prunedTypes;

    public KotlinMetadataEnqueuerExtension(AppView<?> appView, Enqueuer.EnqueuerDefinitionSupplier enqueuerDefinitionSupplier, Set<DexType> prunedTypes) {
        this.appView = appView;
        this.enqueuerDefinitionSupplier = enqueuerDefinitionSupplier;
        this.prunedTypes = prunedTypes;
    }

    private KotlinMetadataDefinitionSupplier definitionsForContext(ProgramDefinition context) {
        return new KotlinMetadataDefinitionSupplier(context, this.enqueuerDefinitionSupplier, this.prunedTypes);
    }

    @Override
    public void done(Enqueuer enqueuer) {
        boolean keepKotlinMetadata = KeepClassInfo.isKotlinMetadataClassKept(this.appView.dexItemFactory(), this.appView.options(), arg_0 -> this.appView.appInfo().definitionForWithoutExistenceAssert(arg_0), enqueuer::getKeepInfo);
        if (enqueuer.getMode().isInitialTreeShaking()) {
            Set<DexMethod> keepByteCodeFunctions = Sets.newIdentityHashSet();
            Set<DexProgramClass> localOrAnonymousClasses = Sets.newIdentityHashSet();
            enqueuer.forAllLiveClasses(clazz -> {
                assert (clazz.getKotlinInfo().isNoKotlinInformation());
                if (enqueuer.getKeepInfo((DexProgramClass)clazz).isKotlinMetadataRemovalAllowed(this.appView.options(), keepKotlinMetadata)) {
                    if (KotlinClassMetadataReader.isLambda(this.appView, clazz) && clazz.hasClassInitializer()) {
                        feedback.classInitializerMayBePostponed(clazz.getClassInitializer());
                    }
                    clazz.clearKotlinInfo();
                    clazz.removeAnnotations(annotation -> annotation.getAnnotationType() == this.appView.dexItemFactory().kotlinMetadataType);
                } else {
                    clazz.setKotlinInfo(KotlinClassMetadataReader.getKotlinInfo(clazz, this.appView, method -> keepByteCodeFunctions.add((DexMethod)method.getReference())));
                    if (clazz.getEnclosingMethodAttribute() != null && clazz.getEnclosingMethodAttribute().getEnclosingMethod() != null) {
                        localOrAnonymousClasses.add((DexProgramClass)clazz);
                    }
                }
            });
            for (DexProgramClass localOrAnonymousClass : localOrAnonymousClasses) {
                DexEncodedMethod method;
                EnclosingMethodAttribute enclosingAttribute = localOrAnonymousClass.getEnclosingMethodAttribute();
                DexClass holder = this.definitionsForContext(localOrAnonymousClass).definitionForHolder(enclosingAttribute.getEnclosingMethod());
                if (holder == null || (method = holder.lookupMethod(enclosingAttribute.getEnclosingMethod())) != null && (!method.getKotlinInfo().isFunction() || !method.getKotlinInfo().asFunction().hasCrossInlineParameter())) continue;
                localOrAnonymousClass.forEachProgramMethod(m3 -> keepByteCodeFunctions.add((DexMethod)m3.getReference()));
            }
            this.appView.setCfByteCodePassThrough(keepByteCodeFunctions);
        } else {
            assert (enqueuer.getMode().isFinalTreeShaking());
            enqueuer.forAllLiveClasses(clazz -> {
                if (enqueuer.getKeepInfo((DexProgramClass)clazz).isKotlinMetadataRemovalAllowed(this.appView.options(), keepKotlinMetadata)) {
                    clazz.clearKotlinInfo();
                    clazz.members().forEach(DexEncodedMember::clearKotlinInfo);
                    clazz.removeAnnotations(annotation -> annotation.getAnnotationType() == this.appView.dexItemFactory().kotlinMetadataType);
                } else assert (KotlinClassMetadataReader.hasKotlinClassMetadataAnnotation(clazz, this.definitionsForContext((ProgramDefinition)clazz)) == (clazz.getKotlinInfo() != KotlinMetadataUtils.getNoKotlinInfo()));
            });
        }
        enqueuer.forAllLiveClasses(clazz -> {
            clazz.getKotlinInfo().trace(this.definitionsForContext((ProgramDefinition)clazz));
            clazz.forEachProgramMember(member -> ((DexEncodedMember)member.getDefinition()).getKotlinInfo().trace(this.definitionsForContext((ProgramDefinition)member)));
        });
    }

    public class KotlinMetadataDefinitionSupplier
    implements DexDefinitionSupplier {
        private final ProgramDefinition context;
        private final Enqueuer.EnqueuerDefinitionSupplier enqueuerDefinitionSupplier;
        private final Set<DexType> prunedTypes;

        private KotlinMetadataDefinitionSupplier(ProgramDefinition context, Enqueuer.EnqueuerDefinitionSupplier enqueuerDefinitionSupplier, Set<DexType> prunedTypes) {
            this.context = context;
            this.enqueuerDefinitionSupplier = enqueuerDefinitionSupplier;
            this.prunedTypes = prunedTypes;
        }

        @Override
        public ClassResolutionResult contextIndependentDefinitionForWithResolutionResult(DexType type) {
            throw new Unreachable("Not yet used");
        }

        @Override
        public DexClass definitionFor(DexType type) {
            if (this.prunedTypes != null && this.prunedTypes.contains(type)) {
                return null;
            }
            return this.enqueuerDefinitionSupplier.definitionFor(type, this.context);
        }

        @Override
        public DexItemFactory dexItemFactory() {
            return KotlinMetadataEnqueuerExtension.this.appView.dexItemFactory();
        }
    }
}

